/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dp.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelendling<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"dp", (String)"modelendling"), "main");
    public final ModelPart head;
    public final ModelPart leg_l1;
    public final ModelPart leg_l2;
    public final ModelPart leg_r1;
    public final ModelPart leg_r2;

    public Modelendling(ModelPart root) {
        this.head = root.getChild("head");
        this.leg_l1 = root.getChild("leg_l1");
        this.leg_l2 = root.getChild("leg_l2");
        this.leg_r1 = root.getChild("leg_r1");
        this.leg_r2 = root.getChild("leg_r2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition leg_l1 = partdefinition.addOrReplaceChild("leg_l1", CubeListBuilder.create().texOffs(0, 16).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)22.0f, (float)-2.5f));
        PartDefinition leg_l2 = partdefinition.addOrReplaceChild("leg_l2", CubeListBuilder.create().texOffs(8, 16).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)22.0f, (float)2.5f));
        PartDefinition leg_r1 = partdefinition.addOrReplaceChild("leg_r1", CubeListBuilder.create().texOffs(4, 16).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)22.0f, (float)-2.5f));
        PartDefinition leg_r2 = partdefinition.addOrReplaceChild("leg_r2", CubeListBuilder.create().texOffs(12, 16).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)22.0f, (float)2.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg_l1.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg_l2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg_r1.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg_r2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg_r1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg_r2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg_l1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg_l2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

