/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dp.item;

import net.mcreator.dp.init.DpModItems;
import net.mcreator.dp.procedures.ProcedureSwordProcedure;
import net.mcreator.dp.procedures.VoidTooweapEntityHitProcedure;
import net.mcreator.dp.procedures.VoidTooweapSwingProcedure;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class VoidSwordItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 8064;
        }

        public float getSpeed() {
            return 64.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
        }

        public int getEnchantmentValue() {
            return 128;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)DpModItems.VOID_CRYSTAL.get())});
        }
    };

    public VoidSwordItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)127.0f, (float)-2.0f)).fireResistant());
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        VoidTooweapEntityHitProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        return retval;
    }

    public void onCraftedBy(ItemStack itemstack, Level world, Player entity) {
        super.onCraftedBy(itemstack, world, entity);
        ProcedureSwordProcedure.execute((LevelAccessor)world, itemstack);
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        VoidTooweapSwingProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        return retval;
    }
}

