/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dp.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.PlantType;
import net.neoforged.neoforge.common.util.DeferredSoundType;

public class EdmundWoodBlock
extends SugarCaneBlock
implements BonemealableBlock {
    public EdmundWoodBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().sound((SoundType)new DeferredSoundType(1.0f, 1.0f, () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("dp:block_havana_log")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("dp:block_havana_log")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("dp:block_havana_log")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("dp:block_havana_log")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("dp:block_havana_log")))).strength(16.0f, 512.0f).noOcclusion().dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return EdmundWoodBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0).move(offset.x, offset.y, offset.z);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.PLAINS;
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.isEmptyBlock(pos.above())) {
            int i = 1;
            while (world.getBlockState(pos.below(i)).is((Block)this)) {
                ++i;
            }
            if (i < 14) {
                int j = (Integer)blockstate.getValue((Property)AGE);
                if (CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)blockstate, (boolean)true)) {
                    if (j == 15) {
                        world.setBlockAndUpdate(pos.above(), this.defaultBlockState());
                        CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos.above(), (BlockState)this.defaultBlockState());
                        world.setBlock(pos, (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        world.setBlock(pos, (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                }
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState blockstate) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState blockstate) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState blockstate) {
    }
}

