/*
 * Decompiled with CFR 0.152.
 */
package ru.bk.oharass.freedomchat;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import ru.bk.oharass.freedomchat.rewrite.CustomServerMetadata;

@ChannelHandler.Sharable
public class FreedomHandler
extends MessageToByteEncoder<Packet<?>> {
    private static final int STATUS_RESPONSE_PACKET_ID = 0;
    private final StreamCodec<ByteBuf, Packet<? super ClientGamePacketListener>> s2cPlayPacketCodec;
    private final boolean rewriteChat;
    private final boolean claimSecureChatEnforced;
    private final boolean noChatReports;
    private final boolean bedrockOnly;

    public FreedomHandler(boolean rewriteChat, boolean claimSecureChatEnforced, boolean noChatReports, boolean bedrockOnly) {
        RegistryAccess.Frozen registryAccess = MinecraftServer.getServer().registryAccess();
        Function bufRegistryAccess = RegistryFriendlyByteBuf.decorator((RegistryAccess)registryAccess);
        this.s2cPlayPacketCodec = GameProtocols.CLIENTBOUND_TEMPLATE.bind(bufRegistryAccess).codec();
        this.rewriteChat = rewriteChat;
        this.claimSecureChatEnforced = claimSecureChatEnforced;
        this.noChatReports = noChatReports;
        this.bedrockOnly = bedrockOnly;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean acceptOutboundMessage(Object msg) {
        if (this.rewriteChat && msg instanceof ClientboundPlayerChatPacket) {
            ClientboundPlayerChatPacket packet = (ClientboundPlayerChatPacket)msg;
            if (!this.bedrockOnly) return true;
            if (this.isBedrockPlayer(packet.sender())) return true;
        }
        if (this.noChatReports) {
            if (msg instanceof ClientboundStatusResponsePacket) return true;
        }
        if (!this.claimSecureChatEnforced) return false;
        if (!(msg instanceof ClientboundLoginPacket)) return false;
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, Packet msg, ByteBuf out) {
        FriendlyByteBuf fbb = new FriendlyByteBuf(out);
        if (msg instanceof ClientboundPlayerChatPacket) {
            ClientboundPlayerChatPacket packet = (ClientboundPlayerChatPacket)msg;
            this.encode(ctx, packet, fbb);
        } else if (msg instanceof ClientboundStatusResponsePacket) {
            ClientboundStatusResponsePacket packet = (ClientboundStatusResponsePacket)msg;
            this.encode(ctx, packet, fbb);
        } else if (msg instanceof ClientboundLoginPacket) {
            ClientboundLoginPacket packet = (ClientboundLoginPacket)msg;
            this.encode(ctx, packet, fbb);
        }
    }

    private void encode(ChannelHandlerContext ctx, ClientboundPlayerChatPacket msg, FriendlyByteBuf buf) {
        Component content = Objects.requireNonNullElseGet(msg.unsignedContent(), () -> Component.literal((String)msg.body().content()));
        ChatType.Bound chatType = msg.chatType();
        Component decoratedContent = chatType.decorate(content);
        ClientboundSystemChatPacket system = new ClientboundSystemChatPacket(decoratedContent, false);
        this.s2cPlayPacketCodec.encode((Object)buf, (Object)system);
    }

    private void encode(ChannelHandlerContext ctx, ClientboundLoginPacket msg, FriendlyByteBuf buf) {
        ClientboundLoginPacket rewritten = new ClientboundLoginPacket(msg.playerId(), msg.hardcore(), msg.levels(), msg.maxPlayers(), msg.chunkRadius(), msg.simulationDistance(), msg.reducedDebugInfo(), msg.showDeathScreen(), msg.doLimitedCrafting(), msg.commonPlayerSpawnInfo(), true);
        this.s2cPlayPacketCodec.encode((Object)buf, (Object)rewritten);
    }

    private void encode(ChannelHandlerContext ctx, ClientboundStatusResponsePacket msg, FriendlyByteBuf buf) {
        ServerStatus status = msg.status();
        CustomServerMetadata customStatus = new CustomServerMetadata(status.description(), status.players(), status.version(), status.favicon(), status.enforcesSecureChat(), true);
        buf.writeVarInt(0);
        buf.writeJsonWithCodec(CustomServerMetadata.CODEC, (Object)customStatus);
    }

    private boolean isBedrockPlayer(UUID uuid) {
        return uuid.version() == 0;
    }
}

