/*
 * Decompiled with CFR 0.152.
 */
package ru.bk.oharass.freedomchat;

import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_155;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bk.oharass.freedomchat.FreedomHandler;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.CommentedConfigurationNode;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.ConfigurateException;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.NodeStyle;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class FreedomChat
implements ModInitializer {
    public static final String MOD_ID = "freedomchat";
    private final Logger logger = LoggerFactory.getLogger((String)"freedomchat");
    private MinecraftServer server;
    private static FreedomHandler handler;

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            block3: {
                this.server = server;
                if (!Boolean.getBoolean("im.evan.freedomchat.bypassprotocolcheck") && class_155.method_31372() != 773) {
                    this.logger.warn("This version of FreedomChat only supports protocol version 773 (1.21.9). Please use the appropriate version of FreedomChat for your server");
                    this.logger.warn("If you know what you are doing, set the im.evan.freedomchat.bypassprotocolcheck system property to true to bypass this check");
                    return;
                }
                Path configPath = Path.of("config/FreedomChat/config.yml", new String[0]);
                YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).nodeStyle(NodeStyle.BLOCK).build();
                try {
                    CommentedConfigurationNode config = (CommentedConfigurationNode)loader.load();
                    boolean rewriteChat = ((CommentedConfigurationNode)config.node(new Object[]{"rewrite-chat"})).getBoolean(true);
                    boolean claimSecureChatEnforced = ((CommentedConfigurationNode)config.node(new Object[]{"claim-secure-chat-enforced"})).getBoolean(false);
                    boolean noChatReports = ((CommentedConfigurationNode)config.node(new Object[]{"send-prevents-chat-reports-to-client"})).getBoolean(false);
                    boolean bedrockOnly = ((CommentedConfigurationNode)config.node(new Object[]{"rewrite-bedrock-only"})).getBoolean(false);
                    loader.save(config);
                    handler = new FreedomHandler(this, rewriteChat, claimSecureChatEnforced, noChatReports, bedrockOnly);
                }
                catch (ConfigurateException e) {
                    this.logger.error("An error occurred while loading this configuration: " + e.getMessage());
                    if (e.getCause() == null) break block3;
                    e.getCause().printStackTrace();
                }
            }
        });
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public static FreedomHandler getHandler() {
        return handler;
    }
}

