/*
 * Decompiled with CFR 0.152.
 */
package ru.bk.oharass.freedomchat;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2678;
import net.minecraft.class_2924;
import net.minecraft.class_2926;
import net.minecraft.class_5455;
import net.minecraft.class_7438;
import net.minecraft.class_7439;
import net.minecraft.class_9095;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import ru.bk.oharass.freedomchat.FreedomChat;
import ru.bk.oharass.freedomchat.rewrite.CustomServerMetadata;

@ChannelHandler.Sharable
public class FreedomHandler
extends MessageToByteEncoder<class_2596<?>> {
    private static final int STATUS_RESPONSE_PACKET_ID = 0;
    private final class_9139<ByteBuf, class_2596<? super class_2602>> s2cPlayPacketCodec;
    private final boolean rewriteChat;
    private final boolean claimSecureChatEnforced;
    private final boolean noChatReports;
    private final boolean bedrockOnly;

    public FreedomHandler(FreedomChat freedom, boolean rewriteChat, boolean claimSecureChatEnforced, boolean noChatReports, boolean bedrockOnly) {
        class_5455.class_6890 registryAccess = freedom.getServer().method_30611();
        Function bufRegistryAccess = class_9129.method_56350((class_5455)registryAccess);
        this.s2cPlayPacketCodec = class_9095.field_48173.method_68874(bufRegistryAccess).comp_2236();
        this.rewriteChat = rewriteChat;
        this.claimSecureChatEnforced = claimSecureChatEnforced;
        this.noChatReports = noChatReports;
        this.bedrockOnly = bedrockOnly;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean acceptOutboundMessage(Object msg) {
        if (this.rewriteChat && msg instanceof class_7438) {
            class_7438 packet = (class_7438)msg;
            if (!this.bedrockOnly) return true;
            if (this.isBedrockPlayer(packet.comp_1099())) return true;
        }
        if (this.noChatReports) {
            if (msg instanceof class_2924) return true;
        }
        if (!this.claimSecureChatEnforced) return false;
        if (!(msg instanceof class_2678)) return false;
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, class_2596 msg, ByteBuf out) {
        class_2540 fbb = new class_2540(out);
        if (msg instanceof class_7438) {
            class_7438 packet = (class_7438)msg;
            this.encode(ctx, packet, fbb);
        } else if (msg instanceof class_2924) {
            class_2924 packet = (class_2924)msg;
            this.encode(ctx, packet, fbb);
        } else if (msg instanceof class_2678) {
            class_2678 packet = (class_2678)msg;
            this.encode(ctx, packet, fbb);
        }
    }

    private void encode(ChannelHandlerContext ctx, class_7438 msg, class_2540 buf) {
        class_2561 content = Objects.requireNonNullElseGet(msg.comp_1103(), () -> class_2561.method_43470((String)msg.comp_1102().comp_1090()));
        class_2556.class_7602 chatType = msg.comp_943();
        class_2561 decoratedContent = chatType.method_44837(content);
        class_7439 system = new class_7439(decoratedContent, false);
        this.s2cPlayPacketCodec.encode((Object)buf, (Object)system);
    }

    private void encode(ChannelHandlerContext ctx, class_2678 msg, class_2540 buf) {
        class_2678 rewritten = new class_2678(msg.comp_88(), msg.comp_89(), msg.comp_92(), msg.comp_97(), msg.comp_98(), msg.comp_169(), msg.comp_99(), msg.comp_100(), msg.comp_1964(), msg.comp_1727(), true);
        this.s2cPlayPacketCodec.encode((Object)buf, (Object)rewritten);
    }

    private void encode(ChannelHandlerContext ctx, class_2924 msg, class_2540 buf) {
        class_2926 status = msg.comp_1272();
        CustomServerMetadata customStatus = new CustomServerMetadata(status.comp_1273(), status.comp_1274(), status.comp_1275(), status.comp_1276(), status.comp_1277(), true);
        buf.method_10804(0);
        buf.method_49395(CustomServerMetadata.CODEC, (Object)customStatus);
    }

    private boolean isBedrockPlayer(UUID uuid) {
        return uuid.version() == 0;
    }
}

