/*
 * Decompiled with CFR 0.152.
 */
package ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.transformation;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.ConfigurateException;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.ConfigurationNode;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.transformation.ConfigurationTransformation;

class ChainedConfigurationTransformation
implements ConfigurationTransformation {
    private final ConfigurationTransformation[] transformations;

    ChainedConfigurationTransformation(ConfigurationTransformation[] transformations) {
        this.transformations = Arrays.copyOf(transformations, transformations.length);
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        for (ConfigurationTransformation transformation : this.transformations) {
            try {
                transformation.apply(node);
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }
}

