/*
 * Decompiled with CFR 0.152.
 */
package ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml;

import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import net.kyori.option.Option;
import net.kyori.option.OptionSchema;
import org.checkerframework.checker.nullness.qual.Nullable;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.CommentedConfigurationNode;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.ConfigurationNode;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.ConfigurationOptions;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.loader.CommentHandler;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.loader.CommentHandlers;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.util.UnmodifiableCollections;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.NodeStyle;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.DumperOptions;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.LoaderOptions;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.Yaml;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.constructor.BaseConstructor;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.constructor.Constructor;
import ru.bk.oharass.freedomchat.lib.org.spongepowered.configurate.yaml.internal.snakeyaml.representer.Representer;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class);
    private final ThreadLocal<Yaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.HASH});
        LoaderOptions loaderOpts = new LoaderOptions().setAcceptTabs(true).setProcessComments(false);
        loaderOpts.setCodePointLimit(Integer.MAX_VALUE);
        DumperOptions opts = builder.options;
        opts.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder.optionState().value(Builder.NODE_STYLE)));
        opts.setIndent(builder.optionState().value(Builder.INDENT));
        this.yaml = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)new Constructor(loaderOpts), new Representer(opts), opts, loaderOpts));
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) {
        node.raw(this.yaml.get().load(reader));
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) {
        this.yaml.get().dump(node.raw(), writer);
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root(options);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private static final OptionSchema.Mutable UNSAFE_SCHEMA = OptionSchema.childSchema(AbstractConfigurationLoader.Builder.SCHEMA);
        public static final OptionSchema SCHEMA = UNSAFE_SCHEMA.frozenView();
        public static final Option<NodeStyle> NODE_STYLE = UNSAFE_SCHEMA.enumOption("yaml:node_style", NodeStyle.class, null);
        public static final Option<Integer> INDENT = UNSAFE_SCHEMA.intOption("yaml:indent", 4);
        private final DumperOptions options = new DumperOptions();

        Builder() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
        }

        @Override
        protected OptionSchema optionSchema() {
            return SCHEMA;
        }

        public Builder indent(int indent) {
            this.optionStateBuilder().value(INDENT, indent);
            return this;
        }

        public int indent() {
            return this.optionState().value(INDENT);
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.optionStateBuilder().value(NODE_STYLE, style);
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return this.optionState().value(NODE_STYLE);
        }

        @Override
        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

