/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.ICullable;
import meldexun.entityculling.ITileEntityBBCache;
import meldexun.entityculling.RayTracingCache;
import meldexun.entityculling.RayTracingEngine;
import meldexun.entityculling.reflection.ReflectionMethod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class CullingThread
extends Thread {
    private static final Set<ResourceLocation> ENTITY_BLACKLIST = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> TILE_ENTITY_BLACKLIST = new HashSet<ResourceLocation>();
    private static final ReflectionMethod<Boolean> METHOD_IS_BOX_IN_FRUSTUM = new ReflectionMethod(ClippingHelper.class, "func_228953_a_", "cubeInFrustum", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
    private final RayTracingEngine.MutableRayTraceResult mutableRayTraceResult = new RayTracingEngine.MutableRayTraceResult();
    private final RayTracingCache cache;
    private double sleepOverhead;
    public long[] time;
    private ClippingHelper frustum;
    private int camBlockX;
    private int camBlockY;
    private int camBlockZ;
    public double camX;
    public double camY;
    public double camZ;
    public Matrix4f matrix;
    public Matrix4f projection;

    public CullingThread() {
        this.cache = new RayTracingCache((Integer)EntityCullingConfig.CLIENT_CONFIG.cacheSize.get());
        this.sleepOverhead = 0.0;
        this.time = new long[10];
        this.matrix = new Matrix4f();
        this.projection = new Matrix4f();
        this.setName("Culling Thread");
        this.setDaemon(true);
    }

    public static void updateBlacklists() {
        ResourceLocation rs;
        ENTITY_BLACKLIST.clear();
        TILE_ENTITY_BLACKLIST.clear();
        for (String s : (List)EntityCullingConfig.CLIENT_CONFIG.skipHiddenEntityRenderingBlacklist.get()) {
            rs = new ResourceLocation(s);
            ForgeRegistries.ENTITIES.containsKey(rs);
            ENTITY_BLACKLIST.add(rs);
        }
        for (String s : (List)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRenderingBlacklist.get()) {
            rs = new ResourceLocation(s);
            ForgeRegistries.TILE_ENTITIES.containsKey(rs);
            TILE_ENTITY_BLACKLIST.add(rs);
        }
    }

    @Override
    public void run() {
        Minecraft mc = Minecraft.func_71410_x();
        while (true) {
            long t;
            block12: {
                t = System.nanoTime();
                try {
                    RayTracingEngine.resetCache();
                    this.cache.clearCache();
                    if (mc.field_71441_e == null || mc.func_175606_aa() == null) break block12;
                    this.frustum = new ClippingHelper(this.matrix, this.projection);
                    this.frustum.func_228952_a_(this.camX, this.camY, this.camZ);
                    this.camBlockX = MathHelper.func_76128_c((double)this.camX);
                    this.camBlockY = MathHelper.func_76128_c((double)this.camY);
                    this.camBlockZ = MathHelper.func_76128_c((double)this.camZ);
                    Iterator entityIterator = mc.field_71441_e.func_217416_b().iterator();
                    while (entityIterator.hasNext()) {
                        try {
                            Entity entity = (Entity)entityIterator.next();
                            this.updateEntityCullingState(entity);
                        }
                        catch (Exception e) {
                            // empty catch block
                            break;
                        }
                    }
                    Iterator tileEntityIterator = mc.field_71441_e.field_147482_g.iterator();
                    while (tileEntityIterator.hasNext()) {
                        try {
                            TileEntity tileEntity = (TileEntity)tileEntityIterator.next();
                            this.updateTileEntityCullingState(tileEntity);
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                }
                catch (Exception entityIterator) {
                    // empty catch block
                }
            }
            t = System.nanoTime() - t;
            if (((Boolean)EntityCullingConfig.CLIENT_CONFIG.debug.get()).booleanValue()) {
                System.arraycopy(this.time, 0, this.time, 1, this.time.length - 1);
                this.time[0] = t;
            }
            double d = (double)t / 1000000.0 + this.sleepOverhead;
            this.sleepOverhead = d % 1.0;
            long sleepTime = 10L - (long)d;
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void updateEntityCullingState(Entity entity) {
        ((ICullable)entity).setCulledFast(!this.checkEntityVisibility(entity));
        ((ICullable)entity).setCulledSlow(true);
        if (EntityCulling.IS_OPTIFINE_DETECTED) {
            ((ICullable)entity).setCulledShadowPass(!this.checkEntityShadowVisibility(entity));
        }
    }

    private void updateTileEntityCullingState(TileEntity tileEntity) {
        ((ICullable)tileEntity).setCulledFast(!this.checkTileEntityVisibility(tileEntity));
        ((ICullable)tileEntity).setCulledSlow(true);
        if (EntityCulling.IS_OPTIFINE_DETECTED) {
            ((ICullable)tileEntity).setCulledShadowPass(!this.checkTileEntityShadowVisibility(tileEntity));
        }
    }

    private boolean checkEntityVisibility(Entity entity) {
        double maxZ;
        double maxY;
        double maxX;
        double minZ;
        double minY;
        double minX;
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.enabled.get()).booleanValue()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.skipHiddenEntityRendering.get()).booleanValue()) {
            return true;
        }
        if (!entity.func_184222_aU()) {
            return true;
        }
        if ((double)entity.func_213311_cf() > (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenEntityRenderingSize.get() || (double)entity.func_213302_cg() > (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenEntityRenderingSize.get()) {
            return true;
        }
        if (!ENTITY_BLACKLIST.isEmpty() && ENTITY_BLACKLIST.contains(entity.func_200600_R().getRegistryName())) {
            return true;
        }
        AxisAlignedBB aabb = entity.func_184177_bl();
        if (aabb.func_181656_b()) {
            minX = entity.func_226277_ct_() - 2.0;
            minY = entity.func_226278_cu_() - 2.0;
            minZ = entity.func_226281_cx_() - 2.0;
            maxX = entity.func_226277_ct_() + 2.0;
            maxY = entity.func_226278_cu_() + 2.0;
            maxZ = entity.func_226281_cx_() + 2.0;
        } else {
            minX = aabb.field_72340_a - 0.5;
            minY = aabb.field_72338_b - 0.5;
            minZ = aabb.field_72339_c - 0.5;
            maxX = aabb.field_72336_d + 0.5;
            maxY = aabb.field_72337_e + 0.5;
            maxZ = aabb.field_72334_f + 0.5;
        }
        if (!entity.func_145770_h(this.camX, this.camY, this.camZ)) {
            return true;
        }
        if (!Boolean.TRUE.equals(METHOD_IS_BOX_IN_FRUSTUM.invoke(this.frustum, minX, minY, minZ, maxX, maxY, maxZ))) {
            return true;
        }
        if (this.checkVisibility(entity.field_70170_p, this.camX, this.camY, this.camZ, (minX + maxX) * 0.5, (minY + maxY) * 0.5, (minZ + maxZ) * 0.5, 1.0)) {
            return true;
        }
        return this.checkBoundingBoxVisibility(entity.field_70170_p, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private boolean checkTileEntityVisibility(TileEntity tileEntity) {
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.enabled.get()).booleanValue()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRendering.get()).booleanValue()) {
            return true;
        }
        AxisAlignedBB aabb = ((ITileEntityBBCache)tileEntity).getCachedAABB();
        if (aabb.field_72336_d - aabb.field_72340_a > (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRenderingSize.get() || aabb.field_72337_e - aabb.field_72338_b > (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRenderingSize.get() || aabb.field_72334_f - aabb.field_72339_c > (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRenderingSize.get()) {
            return true;
        }
        if (!TILE_ENTITY_BLACKLIST.isEmpty() && TILE_ENTITY_BLACKLIST.contains(tileEntity.func_200662_C().getRegistryName())) {
            return true;
        }
        double minX = aabb.field_72340_a;
        double minY = aabb.field_72338_b;
        double minZ = aabb.field_72339_c;
        double maxX = aabb.field_72336_d;
        double maxY = aabb.field_72337_e;
        double maxZ = aabb.field_72334_f;
        BlockPos pos = tileEntity.func_174877_v();
        if (pos.func_218140_a(this.camX, this.camY, this.camZ, true) >= tileEntity.func_145833_n() * tileEntity.func_145833_n()) {
            return true;
        }
        if (!Boolean.TRUE.equals(METHOD_IS_BOX_IN_FRUSTUM.invoke(this.frustum, minX, minY, minZ, maxX, maxY, maxZ))) {
            return true;
        }
        if (this.checkVisibility(tileEntity.func_145831_w(), this.camX, this.camY, this.camZ, (minX + maxX) * 0.5, (minY + maxY) * 0.5, (minZ + maxZ) * 0.5, 1.0)) {
            return true;
        }
        return this.checkBoundingBoxVisibility(tileEntity.func_145831_w(), minX, minY, minZ, maxX, maxY, maxZ);
    }

    private boolean checkEntityShadowVisibility(Entity entity) {
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.enabled.get()).booleanValue()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.entityShadowsEnabled.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.skipHiddenEntityRendering.get()).booleanValue()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.entityShadowsCulling.get()).booleanValue()) {
            return true;
        }
        if (!((ICullable)entity).isCulledFast()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.entityShadowsCullingLessAggressiveMode.get()).booleanValue()) {
            return false;
        }
        if (!entity.func_184222_aU()) {
            return true;
        }
        if ((double)entity.func_213311_cf() >= (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenEntityRenderingSize.get() || (double)entity.func_213302_cg() >= (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenEntityRenderingSize.get()) {
            return true;
        }
        if (!ENTITY_BLACKLIST.isEmpty() && ENTITY_BLACKLIST.contains(entity.func_200600_R().getRegistryName())) {
            return true;
        }
        return this.checkVisibility(entity.field_70170_p, this.camX, this.camY, this.camZ, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_213302_cg() * 0.5, entity.func_226281_cx_(), (Double)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.entityShadowsCullingLessAggressiveModeDiff.get());
    }

    private boolean checkTileEntityShadowVisibility(TileEntity tileEntity) {
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.enabled.get()).booleanValue()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.tileEntityShadowsEnabled.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRendering.get()).booleanValue()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.tileEntityShadowsCulling.get()).booleanValue()) {
            return true;
        }
        if (!((ICullable)tileEntity).isCulledFast()) {
            return true;
        }
        if (!((Boolean)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.tileEntityShadowsCullingLessAggressiveMode.get()).booleanValue()) {
            return false;
        }
        AxisAlignedBB aabb = ((ITileEntityBBCache)tileEntity).getCachedAABB();
        if (aabb.field_72336_d - aabb.field_72340_a > (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRenderingSize.get() || aabb.field_72337_e - aabb.field_72338_b > (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRenderingSize.get() || aabb.field_72334_f - aabb.field_72339_c > (Double)EntityCullingConfig.CLIENT_CONFIG.skipHiddenTileEntityRenderingSize.get()) {
            return true;
        }
        if (!TILE_ENTITY_BLACKLIST.isEmpty() && TILE_ENTITY_BLACKLIST.contains(tileEntity.func_200662_C().getRegistryName())) {
            return true;
        }
        BlockPos pos = tileEntity.func_174877_v();
        return this.checkVisibility(tileEntity.func_145831_w(), this.camX, this.camY, this.camZ, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (Double)EntityCullingConfig.CLIENT_CONFIG.optifineShaderOptions.tileEntityShadowsCullingLessAggressiveModeDiff.get());
    }

    private boolean checkBoundingBoxVisibility(World world, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        block19: {
            int y;
            int z;
            int x;
            int endZ;
            int endY;
            int endX;
            block18: {
                int y2;
                int z2;
                int y3;
                int x2;
                int startX = MathHelper.func_76128_c((double)minX);
                int startY = MathHelper.func_76128_c((double)minY);
                int startZ = MathHelper.func_76128_c((double)minZ);
                endX = MathHelper.func_76143_f((double)maxX);
                endY = MathHelper.func_76143_f((double)maxY);
                endZ = MathHelper.func_76143_f((double)maxZ);
                if (this.camX < (double)startX) {
                    x2 = startX;
                    for (y3 = startY; y3 <= endY; ++y3) {
                        for (z2 = startZ; z2 <= endZ; ++z2) {
                            if (!this.checkVisibilityCached(world, x2, y3, z2)) continue;
                            return true;
                        }
                    }
                } else if (this.camX > (double)endX) {
                    x2 = endX;
                    for (y3 = startY; y3 <= endY; ++y3) {
                        for (z2 = startZ; z2 <= endZ; ++z2) {
                            if (!this.checkVisibilityCached(world, x2, y3, z2)) continue;
                            return true;
                        }
                    }
                }
                if (this.camY < (double)startY) {
                    y2 = startY;
                    for (x = startX; x <= endX; ++x) {
                        for (z2 = startZ; z2 <= endZ; ++z2) {
                            if (!this.checkVisibilityCached(world, x, y2, z2)) continue;
                            return true;
                        }
                    }
                } else if (this.camY > (double)endY) {
                    y2 = endY;
                    for (x = startX; x <= endX; ++x) {
                        for (z2 = startZ; z2 <= endZ; ++z2) {
                            if (!this.checkVisibilityCached(world, x, y2, z2)) continue;
                            return true;
                        }
                    }
                }
                if (!(this.camZ < (double)startZ)) break block18;
                z = startZ;
                for (x = startX; x <= endX; ++x) {
                    for (y = startY; y <= endY; ++y) {
                        if (!this.checkVisibilityCached(world, x, y, z)) continue;
                        return true;
                    }
                }
                break block19;
            }
            if (!(this.camZ > (double)endZ)) break block19;
            z = endZ;
            for (x = startX; x <= endX; ++x) {
                for (y = startY; y <= endY; ++y) {
                    if (!this.checkVisibilityCached(world, x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkVisibilityCached(World world, int endX, int endY, int endZ) {
        int cachedValue;
        int cacheX = endX - this.camBlockX + this.cache.radiusBlocks;
        int cacheY = endY - this.camBlockY + this.cache.radiusBlocks;
        int cacheZ = endZ - this.camBlockZ + this.cache.radiusBlocks;
        RayTracingCache.RayTracingCacheChunk chunk = this.cache.getChunk(cacheX >> 4, cacheY >> 4, cacheZ >> 4);
        if (chunk != null && (cachedValue = chunk.getCachedValue(cacheX & 0xF, cacheY & 0xF, cacheZ & 0xF)) > 0) {
            return cachedValue >> 1 == 1;
        }
        boolean flag = this.checkVisibility(world, this.camX, this.camY, this.camZ, endX, endY, endZ, 1.0);
        if (chunk != null) {
            chunk.setCachedValue(cacheX & 0xF, cacheY & 0xF, cacheZ & 0xF, flag ? 2 : 1);
        }
        return flag;
    }

    private boolean checkVisibility(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, double maxDiff) {
        RayTracingEngine.MutableRayTraceResult rayTraceResult = RayTracingEngine.rayTraceBlocks(world, startX, startY, startZ, endX, endY, endZ, true, maxDiff, this.mutableRayTraceResult);
        return rayTraceResult == null;
    }
}

