/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import meldexun.entityculling.CullingThread;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.ICullable;
import meldexun.entityculling.gui.ShaderOptionsScreen;
import meldexun.entityculling.plugin.Hook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL15C;

public class EntityCullingClient {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CullingThread CULLING_THREAD = new CullingThread();
    public static int vertexBuffer;
    public static int indexBuffer;

    public static void init() {
        CULLING_THREAD.start();
    }

    public static void generateCubeDisplayList() {
        FloatBuffer vertexByteBuffer = ByteBuffer.allocateDirect(96).order(ByteOrder.nativeOrder()).asFloatBuffer();
        vertexByteBuffer.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f});
        vertexByteBuffer.rewind();
        ByteBuffer indexByteBuffer = ByteBuffer.allocateDirect(14).order(ByteOrder.nativeOrder());
        indexByteBuffer.put(new byte[]{0, 4, 1, 5, 7, 4, 6, 0, 2, 1, 3, 7, 2, 6});
        indexByteBuffer.rewind();
        vertexBuffer = GL15C.glGenBuffers();
        GL15C.glBindBuffer((int)34962, (int)vertexBuffer);
        GL15C.glBufferData((int)34962, (FloatBuffer)vertexByteBuffer, (int)35044);
        GL15C.glBindBuffer((int)34962, (int)0);
        indexBuffer = GL15C.glGenBuffers();
        GL15C.glBindBuffer((int)34963, (int)indexBuffer);
        GL15C.glBufferData((int)34963, (ByteBuffer)indexByteBuffer, (int)35044);
        GL15C.glBindBuffer((int)34963, (int)0);
    }

    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (((Boolean)EntityCullingConfig.CLIENT_CONFIG.debug.get()).booleanValue() && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 40L == 0L) {
                int i1 = (int)Arrays.stream(EntityCullingClient.CULLING_THREAD.time).sum() / 1000 / 10;
                int i2 = Hook.entitiesRendered;
                int i3 = Hook.entitiesOcclusionCulled;
                int i4 = Hook.tileEntitiesRendered;
                int i5 = Hook.tileEntitiesOcclusionCulled;
                LOGGER.info("Culling Thread: {}\u00b5s, Entities Rendered: {}, Entities Culled: {}, TileEntities Rendered: {}, TileEntities Culled: {}", (Object)i1, (Object)i2, (Object)i3, (Object)i4, (Object)i5);
            }
            if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 20L == 0L) {
                ICullable.deleteInvalidTileEntityQueries((World)Minecraft.func_71410_x().field_71441_e);
            }
        }
    }

    @SubscribeEvent
    public void onEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        if (event.getWorld().func_201670_d()) {
            ((ICullable)event.getEntity()).deleteQuery();
        }
    }

    @SubscribeEvent
    public void onWorldUnloadEvent(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            for (Entity e : ((ClientWorld)event.getWorld()).func_217416_b()) {
                ((ICullable)e).deleteQuery();
            }
            for (TileEntity te : ((ClientWorld)event.getWorld()).field_147482_g) {
                ((ICullable)te).deleteQuery();
            }
            ICullable.deleteTileEntityQueries();
        }
    }

    @SubscribeEvent
    public void onChunkUnloadEvent(ChunkEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            for (ClassInheritanceMultiMap entityMap : ((Chunk)event.getChunk()).func_177429_s()) {
                for (Entity e : entityMap) {
                    ((ICullable)e).deleteQuery();
                }
            }
            for (TileEntity te : ((Chunk)event.getChunk()).func_177434_r().values()) {
                ((ICullable)te).deleteQuery();
            }
        }
    }

    @SubscribeEvent
    public void onInitGuiEvent(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!EntityCulling.IS_OPTIFINE_DETECTED) {
            return;
        }
        Screen screen = event.getGui();
        if (!(screen instanceof OptionsScreen)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        event.addWidget((Widget)new Button(screen.field_230708_k_ / 2 - 155, screen.field_230709_l_ / 6 + 120 - 6 + 24, 150, 20, (ITextComponent)new TranslationTextComponent("options.entity_culling.shadows.button"), button -> mc.func_147108_a((Screen)new ShaderOptionsScreen(mc.field_71462_r))));
    }
}

