/*
 * Decompiled with CFR 0.152.
 */
package de.piju.mab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class Scheduler {
    private static final List<ScheduledTask> tasks = new ArrayList<ScheduledTask>();

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            Iterator<ScheduledTask> iterator = tasks.iterator();
            while (iterator.hasNext()) {
                ScheduledTask task = iterator.next();
                --task.ticks;
                if (task.ticks > 0) continue;
                task.runnable.run();
                iterator.remove();
            }
        });
    }

    public static void schedule(int delayTicks, Runnable runnable) {
        tasks.add(new ScheduledTask(delayTicks, runnable));
    }

    private static class ScheduledTask {
        int ticks;
        final Runnable runnable;

        ScheduledTask(int ticks, Runnable runnable) {
            this.ticks = ticks;
            this.runnable = runnable;
        }
    }
}

