/*
 * Decompiled with CFR 0.152.
 */
package de.piju.mab.save;

import de.piju.mab.MAB;
import de.piju.mab.TeamData;
import de.piju.mab.Timer;
import de.piju.mab.save.MABPersistence;
import de.piju.mab.save.TeamPersistence;
import de.piju.mab.save.TimerPersistence;
import de.piju.mab.save.TimerState;
import de.piju.mab.util.TickScheduler;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Saver {
    private static final Logger LOGGER = MAB.LOGGER;
    private static TimerState timerState;
    private static MABPersistence mabPersistence;

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(Saver::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(Saver::onServerStopping);
    }

    public static void initializeDefault(class_3218 world) {
        MAB.mainWorld = world;
        TeamData.createTeam("green");
        TeamData.createTeam("red");
        TeamData.createTeam("blue");
        TeamData.createTeam("yellow");
        TeamData.getTeam("green").setArenaOffset(0);
        TeamData.getTeam("red").setArenaOffset(500);
        TeamData.getTeam("blue").setArenaOffset(1000);
        TeamData.getTeam("yellow").setArenaOffset(1500);
        TeamData.getTeam("green").setTeleportPos(new class_2338(0, -63, 0));
        TeamData.getTeam("red").setTeleportPos(new class_2338(100000, -63, 100000));
        TeamData.getTeam("blue").setTeleportPos(new class_2338(0, -63, 100000));
        TeamData.getTeam("yellow").setTeleportPos(new class_2338(100000, -63, 0));
        TeamData.getTeam("green").setTeamColor(class_124.field_1060);
        TeamData.getTeam("red").setTeamColor(class_124.field_1061);
        TeamData.getTeam("yellow").setTeamColor(class_124.field_1054);
        TeamData.getTeam("blue").setTeamColor(class_124.field_1078);
        Timer.minutes = 1;
        Timer.stop(MAB.mainServer);
        MAB.LOGGER.info("[MAB] Teams initialised.");
    }

    private static void onServerStarted(MinecraftServer server) {
        TimerState timerState;
        MAB.mainServer = server;
        MAB.mainWorld = server.method_30002();
        if (!TeamData.teams.isEmpty()) {
            TeamData.teams.clear();
        }
        LOGGER.info("[MAB] Server started \u2013 Loading Teams & Timer...");
        Timer.state = timerState = TimerPersistence.get(server);
        if (timerState != null && timerState.isRunning()) {
            Timer.load(server);
        }
        mabPersistence = MABPersistence.get(server.method_30002());
        mabPersistence.applyToMAB();
        TeamPersistence.loadTeams(server);
        if (TeamData.teams.isEmpty()) {
            LOGGER.warn("[MAB] No saved teams found \u2013 Creating Standardteams...");
            Saver.initializeDefault(server.method_30002());
        } else {
            MAB.loadedFromSave = true;
        }
    }

    private static void onServerStopping(MinecraftServer server) {
        LOGGER.info("[MAB] Server stopping \u2013 Saving teams & timer...");
        TickScheduler.stopAll();
        TeamPersistence.saveTeams(server);
        if (timerState == null) {
            timerState = TimerPersistence.get(server);
        }
        if (mabPersistence != null) {
            mabPersistence.syncFromMAB();
        }
        TimerPersistence.save(server, timerState);
    }
}

