/*
 * Decompiled with CFR 0.152.
 */
package de.piju.mab.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public class TickScheduler {
    private static final Map<String, TickScheduler> SCHEDULERS = new ConcurrentHashMap<String, TickScheduler>();
    private final String name;
    private final Consumer<MinecraftServer> tickAction;
    private boolean running = false;
    private int tickDelay = 1;
    private int tickCounter = 0;

    public TickScheduler(String name, Consumer<MinecraftServer> tickAction) {
        this.name = name;
        this.tickAction = tickAction;
        SCHEDULERS.put(name, this);
    }

    public TickScheduler withDelay(int delay) {
        this.tickDelay = Math.max(1, delay);
        return this;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        ServerTickEvents.END_SERVER_TICK.register(this::tickHandler);
    }

    public void stop() {
        this.running = false;
    }

    private void tickHandler(MinecraftServer server) {
        if (!this.running) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= this.tickDelay) {
            this.tickCounter = 0;
            this.tickAction.accept(server);
        }
    }

    public static TickScheduler get(String name) {
        return SCHEDULERS.get(name);
    }

    public static void stopAll() {
        SCHEDULERS.values().forEach(s -> s.stop());
    }

    public static void remove(String name) {
        TickScheduler scheduler = SCHEDULERS.remove(name);
        if (scheduler != null) {
            scheduler.stop();
        }
    }

    public static Map<String, TickScheduler> getAll() {
        return SCHEDULERS;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getName() {
        return this.name;
    }
}

