/*
 * Decompiled with CFR 0.152.
 */
package de.piju.mab;

import de.piju.mab.Arenas;
import de.piju.mab.ItemManager;
import de.piju.mab.MAB;
import de.piju.mab.SavedEntity;
import de.piju.mab.TeamData;
import de.piju.mab.TitleUtil;
import de.piju.mab.util.TickScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1634;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.minecraft.class_7260;
import net.minecraft.class_7439;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class Finale {
    private final TeamData teamData;
    private final class_3218 serverWorld;
    private TeamData currentOpponentTeam;
    private int currentArenaNumber;
    private class_2338 currentArenaPos;
    private final List<SavedEntity> currentWaveEntities;
    private Map<UUID, class_1297> activeWaveEntities;
    private boolean firstArena = true;
    double[] maxWaveHealth = new double[1];
    double[] currentWaveHealth = new double[1];
    private int tickCounter = 0;
    private boolean waitingForSpawn = false;
    private int spawnDelayTicks = 0;
    private final TickScheduler scheduler;

    public Finale(TeamData teamData, class_3218 targetWorld) {
        this.teamData = teamData;
        Collections.shuffle(teamData.order);
        this.currentOpponentTeam = teamData.order.get(0);
        this.serverWorld = targetWorld;
        this.currentWaveEntities = new ArrayList<SavedEntity>();
        this.activeWaveEntities = new HashMap<UUID, class_1297>();
        teamData.bossBar.method_14091(true);
        teamData.bossBar.method_5408(0.0f);
        teamData.bossBar.method_5409(class_1259.class_1261.field_5790);
        teamData.getPlayersUUIDS().forEach(UUID2 -> {
            class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
            player.method_43496((class_2561)class_2561.method_43470((String)"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n"));
            player.method_43496((class_2561)class_2561.method_43470((String)"[Mob Radar (when holding in mainhand)]").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}));
            player.method_43496((class_2561)class_2561.method_43470((String)"Shows particles to the nearest mob").method_27692(class_124.field_1062));
            player.method_43496((class_2561)class_2561.method_43470((String)"Right click (on a block) to get speed").method_27692(class_124.field_1062));
            player.method_43496((class_2561)class_2561.method_43470((String)"Sneak and right click (on a block) to toggle the bossbar").method_27692(class_124.field_1062));
            if (MAB.resetPlayersInventoryForNewTeam) {
                ItemManager.savePlayer(player);
            }
            player.method_31549().field_7478 = false;
            player.method_31549().field_7479 = false;
            player.method_5996(class_5134.field_47759).method_6192(3.0);
            player.method_7355();
        });
        this.scheduler = new TickScheduler("finale_" + teamData.getTeamName(), this::onServerTick).withDelay(1);
        this.scheduler.start();
        teamData.finale = true;
    }

    public void teleportToArena() {
        this.currentArenaNumber = this.currentOpponentTeam.getArena_number(this.teamData.current_wave);
        class_2338 teleportPosOffset = Arenas.teleportPos.get(this.currentArenaNumber);
        class_2338 ownOffset = this.teamData.teleportPos;
        int arenaOffset = this.currentOpponentTeam.getArenaOffset();
        switch (this.currentOpponentTeam.getTeamName()) {
            case "red": {
                this.teamData.bossBar.method_5416(class_1259.class_1260.field_5784);
                break;
            }
            case "green": {
                this.teamData.bossBar.method_5416(class_1259.class_1260.field_5785);
                break;
            }
            case "yellow": {
                this.teamData.bossBar.method_5416(class_1259.class_1260.field_5782);
                break;
            }
            case "blue": {
                this.teamData.bossBar.method_5416(class_1259.class_1260.field_5780);
            }
        }
        class_2338 teleportPos = new class_2338(teleportPosOffset.method_10263() + ownOffset.method_10263() + arenaOffset, teleportPosOffset.method_10264(), teleportPosOffset.method_10260() + ownOffset.method_10260() + (MAB.arenasPerWave ? this.teamData.current_wave * 1000 : 0));
        this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
            class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = player;
                serverPlayer.method_14251(this.serverWorld, (double)teleportPos.method_10263(), (double)teleportPos.method_10264(), (double)teleportPos.method_10260(), 0.0f, 0.0f);
                serverPlayer.method_26284(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"mab", (String)"arena_dimension")), new class_2338(teleportPos.method_10263(), teleportPos.method_10264(), teleportPos.method_10260()), 0.0f, true, false);
            }
        });
        if (this.firstArena) {
            this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
                class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
                this.serverWorld.method_8503().method_3734().method_44252(this.serverWorld.method_8503().method_3739(), "give " + player.method_5477().getString() + " minecraft:clock[custom_name='[\"\",{\"text\":\"Mob Radar\",\"italic\":false,\"bold\":true,\"color\":\"light_purple\"}]',lore=['[\"\",{\"text\":\"Shows particles towards the nearest mob.\",\"italic\":false}]'],rarity=epic,enchantment_glint_override=true,attribute_modifiers={modifiers:[{type:\"generic.movement_speed\",amount:-0.05,slot:mainhand,id:1748342784713,operation:add_value}]}] 1");
            });
            this.firstArena = false;
        }
        this.waitingForSpawn = true;
        this.spawnDelayTicks = 100;
    }

    public void spawnWave(int waveNumber) {
        if (this.currentOpponentTeam.getWave(waveNumber).getEntities() == null) {
            this.maxWaveHealth[0] = 0.0;
            this.currentWaveHealth[0] = 0.0;
            this.nextWave();
            return;
        }
        this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
            class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
            TitleUtil.sendTitle(player, "", class_124.field_1060, "Wave: " + this.teamData.current_wave, this.currentOpponentTeam.getTeamColor(), 10, 70, 20);
        });
        this.currentWaveEntities.addAll(this.currentOpponentTeam.getWave(waveNumber).getEntities());
    }

    private void onServerTick(MinecraftServer server) {
        ++this.tickCounter;
        this.maxWaveHealth[0] = 0.0;
        this.currentWaveHealth[0] = 0.0;
        if (!this.activeWaveEntities.isEmpty()) {
            this.activeWaveEntities.forEach((uuid, entity) -> {
                if (entity instanceof class_1309) {
                    class_1309 e = (class_1309)entity;
                    this.currentWaveHealth[0] = this.currentWaveHealth[0] + (double)e.method_6032();
                }
            });
        }
        TeamData.getTeam(this.currentOpponentTeam.getTeamName()).getWave(this.teamData.current_wave).getEntities().forEach(savedEntity -> {
            this.maxWaveHealth[0] = this.maxWaveHealth[0] + savedEntity.getMaxHealth();
        });
        if (Objects.equals(this.currentOpponentTeam.getWaveName(this.teamData.current_wave), "")) {
            this.teamData.bossBar.method_5413(class_2561.method_30163((String)("Wave: " + this.teamData.current_wave)));
        } else {
            this.teamData.bossBar.method_5413(class_2561.method_30163((String)("Wave: " + this.currentOpponentTeam.getWaveName(this.teamData.current_wave))));
        }
        if (this.waitingForSpawn) {
            if (this.spawnDelayTicks % 20 == 0) {
                this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
                    class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
                    TitleUtil.sendTitle(player, "", this.currentOpponentTeam.formatting, "Starting in: " + this.spawnDelayTicks / 20, this.currentOpponentTeam.getTeamColor(), 10, 70, 20);
                });
            }
            if (--this.spawnDelayTicks <= 0) {
                this.waitingForSpawn = false;
                this.spawnWave(this.teamData.current_wave);
            }
            return;
        }
        this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
            class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
            if (player == null) {
                return;
            }
            if (!player.method_5805()) {
                return;
            }
            if (!this.teamData.killed_all_waves) {
                String text = String.format("Wave: " + this.teamData.current_wave, new Object[0]);
                class_5250 message = class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(this.currentOpponentTeam.getTeamColor()));
                class_7439 packet = new class_7439((class_2561)message, true);
                player.field_13987.method_14364((class_2596)packet);
            }
            if (player.method_6047().method_7909() == class_1802.field_8557) {
                double[] closest_distance = new double[]{9999.0};
                class_1297[] closest = new class_1297[1];
                class_243 playerVector = player.method_19538().method_1031(0.0, (double)player.method_5751() - 0.5, 0.0);
                this.activeWaveEntities.forEach((uuid, entity) -> {
                    class_243 entityVector = entity.method_19538().method_1031(0.0, (double)player.method_5751() - 0.5, 0.0);
                    class_243 fromPlayertoEntity = entityVector.method_1020(playerVector);
                    double distance = fromPlayertoEntity.method_1033();
                    if (distance < closest_distance[0]) {
                        closest_distance[0] = distance;
                        closest[0] = entity;
                    }
                });
                if (closest[0] == null) {
                    return;
                }
                class_243 entityVector = closest[0].method_19538().method_1031(0.0, (double)player.method_5751() - 0.5, 0.0);
                class_243 fromPlayertoEntity = entityVector.method_1020(playerVector);
                fromPlayertoEntity = fromPlayertoEntity.method_1029();
                for (int i = 1; i < 5; ++i) {
                    class_243 pos = playerVector.method_1019(fromPlayertoEntity.method_1021(0.3 * (double)i));
                    this.serverWorld.method_14199((class_2394)class_2398.field_38004, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                }
                ((class_1309)closest[0]).method_6092(new class_1293(class_1294.field_5912, 5, 0, false, false, true));
            }
        });
        if (this.tickCounter % 5 != 0) {
            return;
        }
        float newPercent = (float)(this.currentWaveHealth[0] / this.maxWaveHealth[0]);
        if (this.teamData.bossBar.method_5412() != newPercent) {
            this.teamData.bossBar.method_5408(newPercent);
        }
        if (!this.currentWaveEntities.isEmpty()) {
            SavedEntity savedEntity2 = this.currentWaveEntities.get(0);
            List spawnSpots = Arenas.arenaSpawns.get(this.currentArenaNumber);
            int randomIndex = new Random().nextInt(spawnSpots.size());
            class_2338 spawnpos = (class_2338)spawnSpots.get(randomIndex);
            int x = spawnpos.method_10263() + this.teamData.getTeleportPos().method_10263() + this.currentOpponentTeam.getArenaOffset();
            int y = spawnpos.method_10264();
            int z = spawnpos.method_10260() + this.teamData.getTeleportPos().method_10260() + (MAB.arenasPerWave ? this.teamData.current_wave * 1000 : 0);
            spawnpos = new class_2338(x, y, z);
            class_1297 spawn = savedEntity2.getType().method_5883((class_1937)this.serverWorld);
            if (spawn == null) {
                return;
            }
            if (MAB.withMobNbt) {
                spawn.method_5651(savedEntity2.getNbt());
            } else {
                ((class_1308)spawn).method_5943((class_5425)this.serverWorld, this.serverWorld.method_8404(spawn.method_24515()), class_3730.field_16462, (class_1315)null);
                class_2487 currentNbt = new class_2487();
                spawn.method_5647(currentNbt);
                currentNbt.method_10556("PersistenceRequired", true);
                currentNbt.method_10556("IsImmuneToZombification", true);
                if (spawn instanceof class_1634) {
                    currentNbt.method_10569("LifeTicks", 999999999);
                }
                spawn.method_5651(currentNbt);
            }
            if (spawn instanceof class_7260) {
                class_7260 warden = (class_7260)spawn;
                class_2487 brainNbt = new class_2487();
                class_2487 memories = new class_2487();
                class_2487 digCooldown = new class_2487();
                digCooldown.method_10566("value", (class_2520)new class_2487());
                digCooldown.method_10544("ttl", 1000000L);
                memories.method_10566("minecraft:dig_cooldown", (class_2520)digCooldown);
                brainNbt.method_10566("memories", (class_2520)memories);
                class_2487 root = new class_2487();
                root.method_10566("Brain", (class_2520)brainNbt);
                warden.method_5651(root);
            }
            if (spawn instanceof class_1308) {
                class_1308 mob = (class_1308)spawn;
                mob.method_5971();
            }
            spawn.method_5725(spawnpos, 0.0f, 0.0f);
            spawn.method_5826(UUID.randomUUID());
            spawn.method_18800(0.0, 0.0, 0.0);
            spawn.method_20803(0);
            spawn.method_5780("for_" + this.teamData.getTeamName());
            this.serverWorld.method_8649(spawn);
            this.activeWaveEntities.put(spawn.method_5667(), spawn);
            this.currentWaveEntities.remove(0);
        }
        boolean[] all_Alive = new boolean[]{true};
        this.teamData.getPlayersUUIDS().forEach(uuid -> {
            class_3222 player = MAB.mainServer.method_3760().method_14602(uuid);
            if (!player.method_5805()) {
                all_Alive[0] = false;
            }
        });
        if (!all_Alive[0]) {
            return;
        }
        Iterator<Map.Entry<UUID, class_1297>> iterator = this.activeWaveEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, class_1297> entry = iterator.next();
            UUID uuid2 = entry.getKey();
            class_1297 entity2 = this.serverWorld.method_14190(uuid2);
            if (!(entity2 instanceof class_1309)) continue;
            class_1309 living = (class_1309)entity2;
            class_1923 chunkPos = new class_1923(entity2.method_24515());
            if (living.method_6032() <= 0.0f && this.serverWorld.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
                iterator.remove();
                continue;
            }
            entry.setValue(entity2);
        }
        this.serverWorld.method_18198((class_5575)class_1299.field_6069, slime -> slime.method_5752().isEmpty() || slime.method_5752().stream().noneMatch(tag -> tag.startsWith("for_"))).forEach(slimeEntity -> slimeEntity.method_5650(class_1297.class_5529.field_26999));
        this.serverWorld.method_18198((class_5575)class_1299.field_6102, slime -> slime.method_5752().isEmpty() || slime.method_5752().stream().noneMatch(tag -> tag.startsWith("for_"))).forEach(slimeEntity -> slimeEntity.method_5650(class_1297.class_5529.field_26999));
        if (this.activeWaveEntities.isEmpty() && this.currentWaveEntities.isEmpty()) {
            this.nextWave();
        }
        int x1 = this.teamData.getTeleportPos().method_10263() + this.currentOpponentTeam.getArenaOffset() + (Arenas.offset_for_size.containsKey(this.currentArenaNumber) ? Arenas.offset_for_size.get(this.currentArenaNumber).method_10263() : 0);
        int y1 = Arenas.offset_for_size.containsKey(this.currentArenaNumber) ? Arenas.offset_for_size.get(this.currentArenaNumber).method_10264() : this.teamData.teleportPos.method_10264();
        int z1 = this.teamData.getTeleportPos().method_10260() + (MAB.arenasPerWave ? this.teamData.current_wave * 1000 : 0) + (Arenas.offset_for_size.containsKey(this.currentArenaNumber) ? Arenas.offset_for_size.get(this.currentArenaNumber).method_10260() : 0);
        int x2 = Arenas.size.get(this.currentArenaNumber).method_10263() + this.currentOpponentTeam.getArenaOffset() + this.teamData.getTeleportPos().method_10263();
        int y2 = Arenas.size.get(this.currentArenaNumber).method_10264();
        int z2 = Arenas.size.get(this.currentArenaNumber).method_10260() + this.teamData.getTeleportPos().method_10260() + (MAB.arenasPerWave ? this.teamData.current_wave * 1000 : 0);
        this.activeWaveEntities.forEach((uuid, entity) -> {
            if ((double)x1 > entity.method_23317() || (double)x2 < entity.method_23317() || (double)y1 > entity.method_23318() || (double)y2 < entity.method_23318() || (double)z1 > entity.method_23321() || (double)z2 < entity.method_23321()) {
                List spawnSpots = Arenas.arenaSpawns.get(this.currentArenaNumber);
                int randomIndex = new Random().nextInt(spawnSpots.size());
                class_2338 spawnpos = (class_2338)spawnSpots.get(randomIndex);
                int x = spawnpos.method_10263() + this.teamData.getTeleportPos().method_10263() + this.currentOpponentTeam.getArenaOffset();
                int y = spawnpos.method_10264();
                int z = spawnpos.method_10260() + this.teamData.getTeleportPos().method_10260() + (MAB.arenasPerWave ? this.teamData.current_wave * 1000 : 0);
                entity.method_5808((double)x, (double)y, (double)z, 0.0f, 0.0f);
            }
        });
    }

    private void nextWave() {
        if (this.teamData.current_wave == 3 && this.teamData.order.size() == 1) {
            if (this.teamData.killed_all_waves) {
                return;
            }
            this.teamData.killed_all_waves = true;
            this.teamData.bossBar.method_14091(false);
            TickScheduler.remove("finale_" + this.teamData.getTeamName());
            if (MAB.announceAllTeamsIfFinished) {
                this.serverWorld.method_18456().forEach(player -> {
                    if (!this.teamData.getPlayersUUIDS().contains(player.method_5667())) {
                        TitleUtil.sendTitle(player, "", class_124.field_1060, this.teamData.getTeamName() + " finished!", this.teamData.getTeamColor(), 10, 70, 20);
                    }
                });
            }
            this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
                class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
                TitleUtil.sendTitle(player, "", class_124.field_1060, "You finished!", this.teamData.getTeamColor(), 10, 70, 20);
            });
        } else if (this.teamData.current_wave == 3) {
            if (MAB.resetPlayersInventoryForNewTeam) {
                this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
                    class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
                    ItemManager.loadPlayer(player);
                });
                this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
                    class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
                    this.serverWorld.method_8503().method_3734().method_44252(this.serverWorld.method_8503().method_3739(), "give " + player.method_5477().getString() + " minecraft:clock[custom_name='[\"\",{\"text\":\"Mob Radar\",\"italic\":false,\"bold\":true,\"color\":\"light_purple\"}]',lore=['[\"\",{\"text\":\"Shows particles towards the nearest mob.\",\"italic\":false}]'],rarity=epic,enchantment_glint_override=true,attribute_modifiers={modifiers:[{type:\"generic.movement_speed\",amount:-0.05,slot:mainhand,id:1748342784713,operation:add_value}]}] 1");
                });
            }
            this.teamData.getPlayersUUIDS().forEach(UUID2 -> {
                class_3222 player = MAB.mainServer.method_3760().method_14602(UUID2);
                TitleUtil.sendTitle(player, "", class_124.field_1060, "You finished all of " + this.currentOpponentTeam.getTeamName() + " waves!", this.currentOpponentTeam.getTeamColor(), 10, 70, 20);
            });
            this.teamData.order.remove(0);
            this.currentOpponentTeam = this.teamData.order.get(0);
            this.teamData.current_wave = 1;
            this.teleportToArena();
        } else {
            ++this.teamData.current_wave;
            if (MAB.arenasPerWave) {
                this.teleportToArena();
            } else {
                this.spawnWave(this.teamData.current_wave);
            }
        }
    }
}

