/*
 * Decompiled with CFR 0.152.
 */
package de.piju.mab;

import de.piju.mab.Arenas;
import de.piju.mab.MAB;
import de.piju.mab.SavedEntity;
import de.piju.mab.Wave;
import de.piju.mab.WaveNamer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_269;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5425;

public class TeamData {
    public int arenaOffset;
    private int selected_wave = 1;
    private final String teamName;
    private boolean ready_or_not = false;
    private int[] arena_number = new int[]{1, 1, 1};
    public int current_wave = 1;
    public boolean killed_all_waves = false;
    public class_2338 teleportPos;
    public class_3213 bossBar;
    public class_124 formatting;
    static class_269 scoreboard;
    public ArrayList<TeamData> order = new ArrayList();
    private final List<UUID> playerUUIDs = new ArrayList<UUID>();
    public List<class_1657> players = new ArrayList<class_1657>();
    WaveNamer waveNamer;
    private final List<SavedEntity> unassigned = new ArrayList<SavedEntity>();
    private ArrayList<String> wave_names = new ArrayList();
    private final Map<Integer, Wave> waves = new HashMap<Integer, Wave>();
    private class_124 teamColor;
    public boolean finale = false;
    public static Map<String, TeamData> teams;
    public String current_selected_entity_by_tag = "no_tag";

    public TeamData(String teamName) {
        scoreboard = MAB.mainWorld.method_8428();
        this.teamName = teamName;
        this.bossBar = new class_3213((class_2561)class_2561.method_43470((String)""), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795);
        switch (teamName) {
            case "red": {
                this.bossBar.method_5416(class_1259.class_1260.field_5784);
                break;
            }
            case "green": {
                this.bossBar.method_5416(class_1259.class_1260.field_5785);
                break;
            }
            case "yellow": {
                this.bossBar.method_5416(class_1259.class_1260.field_5782);
                break;
            }
            case "blue": {
                this.bossBar.method_5416(class_1259.class_1260.field_5780);
            }
        }
        this.wave_names.add("");
        this.wave_names.add("");
        this.wave_names.add("");
        this.wave_names.add("");
    }

    public static void createTeam(String teamName) {
        teams.computeIfAbsent(teamName, TeamData::new);
    }

    public static TeamData getTeam(String teamName) {
        return teams.get(teamName);
    }

    public void addPlayer(class_1657 player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
        }
        if (!this.playerUUIDs.contains(player.method_5667())) {
            this.playerUUIDs.add(player.method_5667());
        }
        if (!player.method_5752().contains("died")) {
            this.playerJoinMessage(player);
        }
    }

    public boolean hasPlayerUUID(UUID uuid) {
        return this.playerUUIDs.contains(uuid);
    }

    public String getWaveName() {
        return this.wave_names.get(this.selected_wave - 1);
    }

    public String getWaveName(int wave) {
        return this.wave_names.get(wave - 1);
    }

    public void setWaveName(String name) {
        this.wave_names.set(this.selected_wave - 1, name);
    }

    public int getTotalEntityCount(String tag) {
        int[] count = new int[]{0};
        this.unassigned.forEach(savedEntity -> {
            if (tag == savedEntity.getType().toString()) {
                count[0] = count[0] + 1;
            }
        });
        this.getAllWaves().forEach((integer, wave) -> wave.getEntities().forEach(savedEntity -> {
            if (tag == savedEntity.getType().toString()) {
                count[0] = count[0] + 1;
            }
        }));
        int count_ = count[0];
        return count_;
    }

    public int getUsedEntityCount(String tag) {
        int[] count = new int[]{0};
        this.getAllWaves().forEach((integer, wave) -> wave.getEntities().forEach(savedEntity -> {
            if (tag == savedEntity.getType().toString()) {
                count[0] = count[0] + 1;
            }
        }));
        int count_ = count[0];
        return count_;
    }

    public int getTotalEntityCountForWave(int wave) {
        return this.getWave(wave).getEntities().size();
    }

    public void playerJoinMessage(class_1657 player) {
        class_5250 normal = class_2561.method_43470((String)(player.method_5477().getString() + " joined team ")).method_27692(this.teamColor);
        class_5250 team = class_2561.method_43470((String)(this.getTeamName() + "!")).method_27692(this.teamColor);
        class_5250 message = class_2561.method_43473().method_10852((class_2561)normal).method_10852((class_2561)team);
        MAB.mainServer.method_3760().method_14571().forEach(arg_0 -> TeamData.lambda$playerJoinMessage$5((class_2561)message, arg_0));
    }

    public void setTeamColor(class_124 color) {
        this.teamColor = color;
        this.formatting = color;
        if (scoreboard != null) {
            if (scoreboard.method_1153(this.teamName) == null) {
                scoreboard.method_1171(this.teamName);
            }
            scoreboard.method_1153(this.teamName).method_1141(color);
        }
    }

    public class_124 getTeamColor() {
        return this.formatting;
    }

    public void removePlayer(class_1657 player) {
        this.players.remove(player);
        this.playerUUIDs.remove(player.method_5667());
    }

    public List<UUID> getPlayersUUIDS() {
        return this.playerUUIDs;
    }

    public void setArenaOffset(int arenaOffset) {
        this.arenaOffset = arenaOffset;
    }

    public int getArenaOffset() {
        return this.arenaOffset;
    }

    public void setTeleportPos(class_2338 teleportPos) {
        this.teleportPos = teleportPos;
    }

    public class_2338 getTeleportPos() {
        return this.teleportPos;
    }

    public boolean getReadyOrNot() {
        return this.ready_or_not;
    }

    public int getArena_number(int wave) {
        return this.arena_number[MAB.arenasPerWave ? wave - 1 : 0];
    }

    public void nextArenaNumber() {
        if (this.arena_number[MAB.arenasPerWave ? this.selected_wave - 1 : 0] == Arenas.arenaCount) {
            this.arena_number[MAB.arenasPerWave ? this.selected_wave - 1 : 0] = 1;
        } else {
            int n = MAB.arenasPerWave ? this.selected_wave - 1 : 0;
            this.arena_number[n] = this.arena_number[n] + 1;
        }
    }

    public void previousArenaNumber() {
        if (this.arena_number[MAB.arenasPerWave ? this.selected_wave - 1 : 0] == 1) {
            this.arena_number[MAB.arenasPerWave ? this.selected_wave - 1 : 0] = Arenas.arenaCount;
        } else {
            int n = MAB.arenasPerWave ? this.selected_wave - 1 : 0;
            this.arena_number[n] = this.arena_number[n] - 1;
        }
    }

    public void switchReadyOrNot() {
        this.ready_or_not = !this.ready_or_not;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public int getSelected_Wave() {
        return this.selected_wave;
    }

    public void setSelectedWave(int wave) {
        this.selected_wave = wave;
    }

    public void nextSelectedWave() {
        this.selected_wave = this.selected_wave == MAB.maxWaves ? 1 : ++this.selected_wave;
    }

    public void previousSelectedWave() {
        this.selected_wave = this.selected_wave == 1 ? MAB.maxWaves : --this.selected_wave;
    }

    public void addUnassigned(SavedEntity entity) {
        this.unassigned.add(entity);
    }

    public List<SavedEntity> getUnassigned() {
        return this.unassigned;
    }

    public void addToWaveEvenThoughNotKilled(class_1299 type, int waveNumber) {
        class_1311 group = type.method_5891();
        if (group != class_1311.field_6302 && group != class_1311.field_6294) {
            return;
        }
        if (type == class_1299.field_6116) {
            return;
        }
        class_1297 entity = type.method_5883(MAB.mainWorld);
        if (entity == null) {
            return;
        }
        ((class_1308)entity).method_5943((class_5425)MAB.mainServer.method_30002(), MAB.mainWorld.method_8404(entity.method_24515()), class_3730.field_16462, (class_1315)null);
        SavedEntity savedEntity = new SavedEntity(entity);
        this.waves.computeIfAbsent(waveNumber, Wave::new).addEntity(savedEntity);
    }

    public int getEntityCountForWave(String type, int waveNumber) {
        int count = 0;
        for (SavedEntity entity : this.waves.get(waveNumber).getEntities()) {
            if (!Objects.equals(entity.getType().toString(), type)) continue;
            ++count;
        }
        return count;
    }

    public void setWaveNames(List<String> names) {
        this.wave_names.clear();
        this.wave_names.addAll(names);
    }

    public boolean addToWave(String type, int waveNumber) {
        for (SavedEntity entity : this.unassigned) {
            if (!Objects.equals(entity.getType().toString(), type)) continue;
            this.unassigned.remove(entity);
            this.waves.computeIfAbsent(waveNumber, Wave::new).addEntity(entity);
            return true;
        }
        return false;
    }

    public boolean removeFromWave(String type, int waveNumber) {
        for (SavedEntity entity : this.getWave(waveNumber).getEntities()) {
            if (!Objects.equals(entity.getType().toString(), type)) continue;
            this.unassigned.add(entity);
            this.waves.get(waveNumber).removeEntity(entity);
            return true;
        }
        return false;
    }

    public Wave getWave(int waveNumber) {
        return this.waves.computeIfAbsent(waveNumber, Wave::new);
    }

    public Map<Integer, Wave> getAllWaves() {
        return this.waves;
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10582("teamName", this.teamName);
        compound.method_10569("arenaOffset", this.arenaOffset);
        compound.method_10569("selectedWave", this.selected_wave);
        compound.method_10556("ready", this.ready_or_not);
        compound.method_10539("arenaNumbers", this.arena_number);
        compound.method_10556("finale", this.finale);
        class_2499 waveNameList = new class_2499();
        for (String string : this.wave_names) {
            waveNameList.add((Object)class_2519.method_23256((String)string));
        }
        compound.method_10566("waveNames", (class_2520)waveNameList);
        class_2499 uuidList = new class_2499();
        for (UUID uUID : this.playerUUIDs) {
            uuidList.add((Object)class_2519.method_23256((String)uUID.toString()));
        }
        compound.method_10566("playerUUIDs", (class_2520)uuidList);
        if (this.teleportPos != null) {
            compound.method_10569("teleportX", this.teleportPos.method_10263());
            compound.method_10569("teleportY", this.teleportPos.method_10264());
            compound.method_10569("teleportZ", this.teleportPos.method_10260());
        }
        if (this.teamColor != null) {
            compound.method_10582("teamColor", this.teamColor.method_537());
        }
        class_2487 class_24872 = new class_2487();
        for (Map.Entry<Integer, Wave> entry : this.waves.entrySet()) {
            class_2487 waveCompound = new class_2487();
            class_2499 entityList = new class_2499();
            for (SavedEntity entity : entry.getValue().getEntities()) {
                entityList.add((Object)entity.toNbt());
            }
            waveCompound.method_10566("entities", (class_2520)entityList);
            class_24872.method_10566(String.valueOf(entry.getKey()), (class_2520)waveCompound);
        }
        compound.method_10566("waves", (class_2520)class_24872);
        class_2499 class_24992 = new class_2499();
        for (SavedEntity entity : this.unassigned) {
            class_24992.add((Object)entity.toNbt());
        }
        compound.method_10566("unassigned", (class_2520)class_24992);
        return compound;
    }

    public static TeamData fromNbt(class_2487 compound) {
        String name = compound.method_10558("teamName");
        TeamData team = new TeamData(name);
        if (compound.method_10545("waveNames")) {
            class_2499 waveNameList = compound.method_10554("waveNames", 8);
            team.wave_names.clear();
            for (int i = 0; i < waveNameList.size(); ++i) {
                team.wave_names.add(waveNameList.method_10608(i));
            }
        }
        team.finale = compound.method_10577("finale");
        team.arenaOffset = compound.method_10550("arenaOffset");
        team.selected_wave = compound.method_10550("selectedWave");
        team.ready_or_not = compound.method_10577("ready");
        int[] arenaNumbers = compound.method_10561("arenaNumbers");
        System.arraycopy(arenaNumbers, 0, team.arena_number, 0, Math.min(arenaNumbers.length, team.arena_number.length));
        if (compound.method_10545("teleportX") && compound.method_10545("teleportY") && compound.method_10545("teleportZ")) {
            team.setTeleportPos(new class_2338(compound.method_10550("teleportX"), compound.method_10550("teleportY"), compound.method_10550("teleportZ")));
        }
        if (compound.method_10545("playerUUIDs")) {
            class_2499 uuidList = compound.method_10554("playerUUIDs", 8);
            for (int i = 0; i < uuidList.size(); ++i) {
                UUID uuid = UUID.fromString(uuidList.method_10608(i));
                team.playerUUIDs.add(uuid);
            }
        }
        if (compound.method_10545("teamColor")) {
            team.setTeamColor(class_124.method_533((String)compound.method_10558("teamColor")));
        }
        class_2487 wavesCompound = compound.method_10562("waves");
        for (String key : wavesCompound.method_10541()) {
            int waveNum = Integer.parseInt(key);
            class_2487 waveCompound = wavesCompound.method_10562(key);
            class_2499 entities = waveCompound.method_10554("entities", 10);
            for (int i = 0; i < entities.size(); ++i) {
                SavedEntity entity = SavedEntity.fromNbt(entities.method_10602(i));
                team.getWave(waveNum).addEntity(entity);
            }
        }
        class_2499 unassignedList = compound.method_10554("unassigned", 10);
        for (int i = 0; i < unassignedList.size(); ++i) {
            SavedEntity entity = SavedEntity.fromNbt(unassignedList.method_10602(i));
            team.addUnassigned(entity);
        }
        return team;
    }

    private static /* synthetic */ void lambda$playerJoinMessage$5(class_2561 message, class_3222 player1) {
        player1.method_7353(message, false);
    }

    static {
        teams = new ConcurrentHashMap<String, TeamData>();
    }
}

