/*
 * Decompiled with CFR 0.152.
 */
package de.piju.mab;

import de.piju.mab.InitFinale;
import de.piju.mab.MAB;
import de.piju.mab.save.TimerPersistence;
import de.piju.mab.save.TimerState;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7439;
import net.minecraft.server.MinecraftServer;

public class Timer {
    private static int tick = 0;
    public static TimerState state;
    public static int hours;
    public static int minutes;
    public static int seconds;

    public static void load(MinecraftServer server) {
        state = TimerPersistence.get(server);
        if (state.isRunning() && !MAB.timerTick) {
            ServerTickEvents.START_SERVER_TICK.register(s -> Timer.onTick(s));
        }
        MAB.timerTick = true;
    }

    public static void start(MinecraftServer server, int h, int m) {
        state = TimerPersistence.get(server);
        state.set(h, m, 0, false, true);
        TimerPersistence.save(server, state);
        if (!MAB.timerTick) {
            ServerTickEvents.START_SERVER_TICK.register(s -> Timer.onTick(s));
        }
        MAB.timerTick = true;
    }

    public static void pause(MinecraftServer server) {
        state.set(state.getHours(), state.getMinutes(), state.getSeconds(), true, true);
        TimerPersistence.save(server, state);
    }

    public static void resume(MinecraftServer server) {
        state.set(state.getHours(), state.getMinutes(), state.getSeconds(), false, true);
        TimerPersistence.save(server, state);
    }

    public static void stop(MinecraftServer server) {
        state.set(0, 0, 0, true, false);
        TimerPersistence.save(server, state);
    }

    private static void onTick(MinecraftServer server) {
        if (state == null || state.isPaused() || !state.isRunning()) {
            return;
        }
        if (tick % 20 == 0) {
            hours = state.getHours();
            minutes = state.getMinutes();
            seconds = state.getSeconds();
            if (seconds > 0) {
                --seconds;
            } else if (minutes > 0) {
                --minutes;
                seconds = 59;
            } else if (hours > 0) {
                --hours;
                minutes = 59;
                seconds = 59;
            } else {
                Timer.stop(server);
                InitFinale.teleportAllTeamsToDimension(server);
                return;
            }
            state.set(hours, minutes, seconds, false, true);
            TimerPersistence.save(server, state);
            String text = String.format("%02d:%02d:%02d", hours, minutes, seconds);
            class_5250 msg = class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1077));
            class_7439 packet = new class_7439((class_2561)msg, true);
            for (class_3222 p : server.method_3760().method_14571()) {
                p.field_13987.method_14364((class_2596)packet);
            }
        }
        ++tick;
    }

    static {
        hours = 0;
        minutes = 1;
        seconds = 0;
    }
}

