/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.model.chess;

import java.util.ArrayList;
import java.util.Iterator;
import mc.ajneb97.model.PlayerColor;
import mc.ajneb97.model.chess.Movement;
import mc.ajneb97.model.chess.MovementType;
import mc.ajneb97.model.chess.Piece;
import mc.ajneb97.model.chess.PieceType;
import mc.ajneb97.model.internal.CoordinateMovement;
import mc.ajneb97.model.internal.MovePieceResult;
import mc.ajneb97.model.internal.PieceToUpdate;
import org.bukkit.command.CommandSender;

public class Board {
    private Piece[][] board = new Piece[8][8];

    public Piece[][] getBoard() {
        return this.board;
    }

    public void setBoard(Piece[][] board) {
        this.board = board;
    }

    public void createInitialBoard() {
        this.board = new Piece[8][8];
        for (int i = 0; i < 8; ++i) {
            this.board[i][1] = new Piece(PieceType.PAWN, PlayerColor.BLACK);
            this.board[i][6] = new Piece(PieceType.PAWN, PlayerColor.WHITE);
        }
        this.board[0][0] = new Piece(PieceType.ROOK, PlayerColor.BLACK);
        this.board[7][0] = new Piece(PieceType.ROOK, PlayerColor.BLACK);
        this.board[1][0] = new Piece(PieceType.KNIGHT, PlayerColor.BLACK);
        this.board[6][0] = new Piece(PieceType.KNIGHT, PlayerColor.BLACK);
        this.board[2][0] = new Piece(PieceType.BISHOP, PlayerColor.BLACK);
        this.board[5][0] = new Piece(PieceType.BISHOP, PlayerColor.BLACK);
        this.board[3][0] = new Piece(PieceType.QUEEN, PlayerColor.BLACK);
        this.board[4][0] = new Piece(PieceType.KING, PlayerColor.BLACK);
        this.board[0][7] = new Piece(PieceType.ROOK, PlayerColor.WHITE);
        this.board[7][7] = new Piece(PieceType.ROOK, PlayerColor.WHITE);
        this.board[1][7] = new Piece(PieceType.KNIGHT, PlayerColor.WHITE);
        this.board[6][7] = new Piece(PieceType.KNIGHT, PlayerColor.WHITE);
        this.board[2][7] = new Piece(PieceType.BISHOP, PlayerColor.WHITE);
        this.board[5][7] = new Piece(PieceType.BISHOP, PlayerColor.WHITE);
        this.board[3][7] = new Piece(PieceType.QUEEN, PlayerColor.WHITE);
        this.board[4][7] = new Piece(PieceType.KING, PlayerColor.WHITE);
    }

    public Piece getPiece(int x, int y) {
        return this.board[x][y];
    }

    public MovePieceResult move(int xStart, int yStart, Movement movement) {
        int xEnd = movement.getX();
        int yEnd = movement.getY();
        ArrayList<PieceToUpdate> piecesToUpdate = new ArrayList<PieceToUpdate>();
        int[] capturedPiecePosition = null;
        PieceType capturedPieceType = null;
        Piece piece = this.board[xStart][yStart];
        piece.setHasMoved(true);
        piecesToUpdate.add(new PieceToUpdate(xStart, yStart, this.board[xStart][yStart]));
        this.board[xStart][yStart] = null;
        if (this.board[xEnd][yEnd] != null && !movement.getType().name().startsWith("CASTLING")) {
            capturedPiecePosition = new int[]{xEnd, yEnd};
            capturedPieceType = this.board[xEnd][yEnd].getType();
        }
        if (!movement.getType().name().startsWith("CASTLING")) {
            piecesToUpdate.add(new PieceToUpdate(xEnd, yEnd, this.board[xEnd][yEnd]));
            this.board[xEnd][yEnd] = piece;
        }
        if (movement.getType().equals((Object)MovementType.PAWN_TWO)) {
            if (this.isInsideBoard(xEnd + 1, yEnd) && !this.isEmptyPosition(xEnd + 1, yEnd) && !this.isSameColor(xEnd + 1, yEnd, piece.getColor()) && this.board[xEnd + 1][yEnd].getType().equals((Object)PieceType.PAWN)) {
                piece.setEnPassant(true);
            }
            if (this.isInsideBoard(xEnd - 1, yEnd) && !this.isEmptyPosition(xEnd - 1, yEnd) && !this.isSameColor(xEnd - 1, yEnd, piece.getColor()) && this.board[xEnd - 1][yEnd].getType().equals((Object)PieceType.PAWN)) {
                piece.setEnPassant(true);
            }
        } else if (movement.getType().equals((Object)MovementType.EN_PASSANT)) {
            int direction = piece.getColor() == PlayerColor.WHITE ? 1 : -1;
            capturedPiecePosition = new int[]{xEnd, yEnd + direction};
            capturedPieceType = this.board[xEnd][yEnd + direction].getType();
            piecesToUpdate.add(new PieceToUpdate(xEnd, yEnd + direction, this.board[xEnd][yEnd + direction]));
            this.board[xEnd][yEnd + direction] = null;
        }
        if (movement.getType().equals((Object)MovementType.CASTLING_SHORT)) {
            piecesToUpdate.add(new PieceToUpdate(xEnd, yEnd, this.board[xEnd][yEnd]));
            piecesToUpdate.add(new PieceToUpdate(6, yStart, this.board[6][yStart]));
            piecesToUpdate.add(new PieceToUpdate(5, yStart, this.board[5][yStart]));
            this.board[6][yStart] = piece;
            this.board[5][yStart] = this.board[xEnd][yEnd];
            this.board[xEnd][yEnd] = null;
        } else if (movement.getType().equals((Object)MovementType.CASTLING_LONG)) {
            piecesToUpdate.add(new PieceToUpdate(xEnd, yEnd, this.board[xEnd][yEnd]));
            piecesToUpdate.add(new PieceToUpdate(2, yStart, this.board[2][yStart]));
            piecesToUpdate.add(new PieceToUpdate(3, yStart, this.board[3][yStart]));
            this.board[2][yStart] = piece;
            this.board[3][yStart] = this.board[xEnd][yEnd];
            this.board[xEnd][yEnd] = null;
        }
        PlayerColor opponentColor = piece.getColor().equals((Object)PlayerColor.WHITE) ? PlayerColor.BLACK : PlayerColor.WHITE;
        this.resetEnPassant(opponentColor);
        return new MovePieceResult(piecesToUpdate, capturedPieceType);
    }

    public PieceToUpdate promotePawn(int x, int y, PieceType pieceType, PlayerColor playerColor) {
        Piece newPiece = new Piece(pieceType, playerColor);
        PieceToUpdate pieceToUpdate = new PieceToUpdate(x, y, this.board[x][y]);
        newPiece.setHasMoved(true);
        this.board[x][y] = newPiece;
        return pieceToUpdate;
    }

    public boolean verifyInCheck(PlayerColor playerColor) {
        int[] kingPosition = this.getKingPosition(playerColor);
        boolean kingInCheck = false;
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[i].length; ++j) {
                Piece opponentPiece = this.board[i][j];
                if (opponentPiece == null || opponentPiece.getColor().equals((Object)playerColor)) continue;
                ArrayList<Movement> movementsOpponentPiece = this.getPossibleMovements(i, j, false);
                for (Movement m : movementsOpponentPiece) {
                    if (m.getX() != kingPosition[0] || m.getY() != kingPosition[1]) continue;
                    kingInCheck = true;
                    break;
                }
                if (kingInCheck) break;
            }
            if (kingInCheck) break;
        }
        return kingInCheck;
    }

    public ArrayList<Movement> getPossibleMovements(int x, int y, boolean checkKing) {
        Piece piece = this.board[x][y];
        ArrayList<Movement> movements = null;
        switch (piece.getType()) {
            case PAWN: {
                movements = this.getPossibleMovementsPawn(piece, x, y);
                break;
            }
            case ROOK: {
                movements = this.getPossibleMovementsRook(piece, x, y);
                break;
            }
            case KNIGHT: {
                movements = this.getPossibleMovementsKnight(piece, x, y);
                break;
            }
            case BISHOP: {
                movements = this.getPossibleMovementsBishop(piece, x, y);
                break;
            }
            case QUEEN: {
                movements = this.getPossibleMovementsQueen(piece, x, y);
                break;
            }
            case KING: {
                movements = this.getPossibleMovementsKing(piece, x, y);
            }
        }
        if (checkKing) {
            Piece[][] boardBackup = this.deepCopyBoard(this.board);
            PlayerColor pieceColor = piece.getColor();
            Iterator<Movement> iterator = movements.iterator();
            while (iterator.hasNext()) {
                Movement movement = iterator.next();
                this.move(x, y, movement);
                boolean kingInCheck = this.verifyInCheck(pieceColor);
                if (kingInCheck) {
                    iterator.remove();
                }
                this.board = this.deepCopyBoard(boardBackup);
            }
        }
        return movements;
    }

    private ArrayList<Movement> getPossibleMovementsRook(Piece piece, int x, int y) {
        int i;
        ArrayList<Movement> movements = new ArrayList<Movement>();
        for (i = 1; i <= 8 && !this.addMovementAndMustStop(movements, x - i, y, piece); ++i) {
        }
        for (i = 1; i <= 8 && !this.addMovementAndMustStop(movements, x + i, y, piece); ++i) {
        }
        for (i = 1; i <= 8 && !this.addMovementAndMustStop(movements, x, y - i, piece); ++i) {
        }
        for (i = 1; i <= 8 && !this.addMovementAndMustStop(movements, x, y + i, piece); ++i) {
        }
        return movements;
    }

    private ArrayList<Movement> getPossibleMovementsBishop(Piece piece, int x, int y) {
        int i;
        ArrayList<Movement> movements = new ArrayList<Movement>();
        for (i = 1; i <= 8 && !this.addMovementAndMustStop(movements, x - i, y - i, piece); ++i) {
        }
        for (i = 1; i <= 8 && !this.addMovementAndMustStop(movements, x + i, y - i, piece); ++i) {
        }
        for (i = 1; i <= 8 && !this.addMovementAndMustStop(movements, x - i, y + i, piece); ++i) {
        }
        for (i = 1; i <= 8 && !this.addMovementAndMustStop(movements, x + i, y + i, piece); ++i) {
        }
        return movements;
    }

    private ArrayList<Movement> getPossibleMovementsKnight(Piece piece, int x, int y) {
        ArrayList<Movement> movements = new ArrayList<Movement>();
        this.addMovementAndMustStop(movements, x - 2, y - 1, piece);
        this.addMovementAndMustStop(movements, x - 1, y - 2, piece);
        this.addMovementAndMustStop(movements, x + 1, y - 2, piece);
        this.addMovementAndMustStop(movements, x + 2, y - 1, piece);
        this.addMovementAndMustStop(movements, x + 2, y + 1, piece);
        this.addMovementAndMustStop(movements, x + 1, y + 2, piece);
        this.addMovementAndMustStop(movements, x - 1, y + 2, piece);
        this.addMovementAndMustStop(movements, x - 2, y + 1, piece);
        return movements;
    }

    private ArrayList<Movement> getPossibleMovementsKing(Piece piece, int x, int y) {
        ArrayList<Movement> movements = new ArrayList<Movement>();
        this.addMovementAndMustStop(movements, x - 1, y - 1, piece);
        this.addMovementAndMustStop(movements, x, y - 1, piece);
        this.addMovementAndMustStop(movements, x + 1, y - 1, piece);
        this.addMovementAndMustStop(movements, x + 1, y, piece);
        this.addMovementAndMustStop(movements, x + 1, y + 1, piece);
        this.addMovementAndMustStop(movements, x, y + 1, piece);
        this.addMovementAndMustStop(movements, x - 1, y + 1, piece);
        this.addMovementAndMustStop(movements, x - 1, y, piece);
        if (!piece.isHasMoved()) {
            Piece rookLong;
            Piece rookShort = this.board[7][y];
            if (rookShort != null && !rookShort.isHasMoved()) {
                boolean pieceBetween = false;
                for (int i = x + 1; i < 7; ++i) {
                    if (this.board[i][y] == null) continue;
                    pieceBetween = true;
                    break;
                }
                if (!pieceBetween) {
                    movements.add(new Movement(7, y, MovementType.CASTLING_SHORT));
                }
            }
            if ((rookLong = this.board[0][y]) != null && !rookLong.isHasMoved()) {
                boolean pieceBetween = false;
                for (int i = x - 1; i > 0; --i) {
                    if (this.board[i][y] == null) continue;
                    pieceBetween = true;
                    break;
                }
                if (!pieceBetween) {
                    movements.add(new Movement(0, y, MovementType.CASTLING_LONG));
                }
            }
        }
        return movements;
    }

    private ArrayList<Movement> getPossibleMovementsQueen(Piece piece, int x, int y) {
        ArrayList<Movement> movements = new ArrayList<Movement>();
        movements.addAll(this.getPossibleMovementsBishop(piece, x, y));
        movements.addAll(this.getPossibleMovementsRook(piece, x, y));
        return movements;
    }

    private ArrayList<Movement> getPossibleMovementsPawn(Piece piece, int x, int y) {
        int newX;
        ArrayList<Movement> movements = new ArrayList<Movement>();
        int direction = piece.getColor() == PlayerColor.WHITE ? -1 : 1;
        int newY = y + direction;
        if (this.isInsideBoard(x, newY) && this.isEmptyPosition(x, newY)) {
            if (piece.getColor().equals((Object)PlayerColor.WHITE) && newY == 0 || piece.getColor().equals((Object)PlayerColor.BLACK) && newY == 7) {
                movements.add(new Movement(x, newY, MovementType.PROMOTION_NORMAL));
            } else {
                movements.add(new Movement(x, newY));
            }
            if (!piece.isHasMoved() && this.isInsideBoard(x, newY + direction) && this.isEmptyPosition(x, newY + direction)) {
                movements.add(new Movement(x, newY + direction, MovementType.PAWN_TWO));
            }
        }
        if (this.isInsideBoard(newX = x - 1, newY = y + direction) && !this.isEmptyPosition(newX, newY) && !this.isSameColor(newX, newY, piece.getColor())) {
            if (piece.getColor().equals((Object)PlayerColor.WHITE) && newY == 0 || piece.getColor().equals((Object)PlayerColor.BLACK) && newY == 7) {
                movements.add(new Movement(newX, newY, MovementType.PROMOTION_CAPTURE));
            } else {
                movements.add(new Movement(newX, newY, MovementType.CAPTURE));
            }
        }
        if (this.isInsideBoard(newX = x + 1, newY = y + direction) && !this.isEmptyPosition(newX, newY) && !this.isSameColor(newX, newY, piece.getColor())) {
            if (piece.getColor().equals((Object)PlayerColor.WHITE) && newY == 0 || piece.getColor().equals((Object)PlayerColor.BLACK) && newY == 7) {
                movements.add(new Movement(newX, newY, MovementType.PROMOTION_CAPTURE));
            } else {
                movements.add(new Movement(newX, newY, MovementType.CAPTURE));
            }
        }
        if (this.isInsideBoard(x + 1, y) && !this.isEmptyPosition(x + 1, y) && !this.isSameColor(x + 1, y, piece.getColor()) && this.board[x + 1][y].isEnPassant()) {
            movements.add(new Movement(x + 1, y + direction, MovementType.EN_PASSANT));
        }
        if (this.isInsideBoard(x - 1, y) && !this.isEmptyPosition(x - 1, y) && !this.isSameColor(x - 1, y, piece.getColor()) && this.board[x - 1][y].isEnPassant()) {
            movements.add(new Movement(x - 1, y + direction, MovementType.EN_PASSANT));
        }
        return movements;
    }

    private boolean isInsideBoard(int x, int y) {
        return x >= 0 && y >= 0 && x < this.board.length && y < this.board.length;
    }

    private boolean isEmptyPosition(int x, int y) {
        return this.board[x][y] == null;
    }

    private boolean isSameColor(int x, int y, PlayerColor color) {
        Piece piece = this.board[x][y];
        if (piece != null) {
            return piece.getColor().equals((Object)color);
        }
        return false;
    }

    private boolean addMovementAndMustStop(ArrayList<Movement> movements, int newX, int newY, Piece piece) {
        if (this.isInsideBoard(newX, newY)) {
            if (this.isEmptyPosition(newX, newY)) {
                movements.add(new Movement(newX, newY));
                return false;
            }
            if (this.isSameColor(newX, newY, piece.getColor())) {
                return true;
            }
            movements.add(new Movement(newX, newY, MovementType.CAPTURE));
            return true;
        }
        return true;
    }

    private void resetEnPassant(PlayerColor color) {
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[i].length; ++j) {
                Piece piece = this.board[i][j];
                if (piece == null || !piece.getType().equals((Object)PieceType.PAWN) || !piece.getColor().equals((Object)color)) continue;
                piece.setEnPassant(false);
            }
        }
    }

    private int[] getKingPosition(PlayerColor playerColor) {
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[i].length; ++j) {
                Piece piece = this.board[i][j];
                if (piece == null || !piece.getType().equals((Object)PieceType.KING) || !piece.getColor().equals((Object)playerColor)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    public Piece[][] deepCopyBoard(Piece[][] originalBoard) {
        Piece[][] copy = new Piece[originalBoard.length][originalBoard[0].length];
        for (int i = 0; i < originalBoard.length; ++i) {
            for (int j = 0; j < originalBoard[i].length; ++j) {
                copy[i][j] = originalBoard[i][j] == null ? null : originalBoard[i][j].clone();
            }
        }
        return copy;
    }

    public ArrayList<CoordinateMovement> getAllPossibleMovements(PlayerColor playerColor) {
        ArrayList<CoordinateMovement> movements = new ArrayList<CoordinateMovement>();
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[i].length; ++j) {
                Piece piece = this.board[i][j];
                if (piece == null || !piece.getColor().equals((Object)playerColor)) continue;
                ArrayList<Movement> movementsPiece = this.getPossibleMovements(i, j, true);
                for (Movement m : movementsPiece) {
                    movements.add(new CoordinateMovement(i, j, m));
                }
            }
        }
        return movements;
    }

    public void showBoardStatus(CommandSender sender) {
        sender.sendMessage("Board Status:");
        for (int i = 0; i < this.board.length; ++i) {
            StringBuilder row = new StringBuilder();
            for (int j = 0; j < this.board[i].length; ++j) {
                Piece piece = this.board[i][j];
                if (piece == null) {
                    row.append("X ");
                    continue;
                }
                row.append(piece.getType().toString().charAt(0)).append(" ");
            }
            sender.sendMessage(row.toString().trim());
        }
    }
}

