/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.command;

import java.util.ArrayList;
import java.util.List;
import mc.ajneb97.MineChess;
import mc.ajneb97.manager.ArenaManager;
import mc.ajneb97.manager.BoardManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.game.GameLeaveReason;
import mc.ajneb97.utils.PlayerUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private MineChess plugin;

    public MainCommand(MineChess plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        if (!(sender instanceof Player)) {
            if (args.length >= 1) {
                String arg;
                switch (arg = args[0].toLowerCase()) {
                    case "reload": {
                        this.reload(sender, msgManager, messagesConfig);
                        break;
                    }
                    case "enable": {
                        this.enable(sender, args, msgManager, messagesConfig);
                        break;
                    }
                    case "disable": {
                        this.disable(sender, args, msgManager, messagesConfig);
                    }
                }
            }
            return true;
        }
        Player player = (Player)sender;
        if (args.length >= 1) {
            String arg;
            switch (arg = args[0].toLowerCase()) {
                case "reload": {
                    this.reload(sender, msgManager, messagesConfig);
                    break;
                }
                case "create": {
                    this.create(player, args, msgManager, messagesConfig);
                    break;
                }
                case "build": {
                    this.build(player, args, msgManager, messagesConfig);
                    break;
                }
                case "delete": {
                    this.delete(player, args, msgManager, messagesConfig);
                    break;
                }
                case "setmainlobby": {
                    this.setMainLobby(player, msgManager, messagesConfig);
                    break;
                }
                case "enable": {
                    this.enable((CommandSender)player, args, msgManager, messagesConfig);
                    break;
                }
                case "disable": {
                    this.disable((CommandSender)player, args, msgManager, messagesConfig);
                    break;
                }
                case "join": {
                    this.join(player, args, msgManager, messagesConfig);
                    break;
                }
                case "joinrandom": {
                    this.joinrandom(player, msgManager, messagesConfig);
                    break;
                }
                case "leave": {
                    this.leave(player, msgManager, messagesConfig);
                    break;
                }
                case "edit": {
                    this.edit(player, args, msgManager, messagesConfig);
                    break;
                }
                case "spectate": {
                    this.spectate(player, args, msgManager, messagesConfig);
                    break;
                }
                case "verify": {
                    this.verify(player, msgManager, messagesConfig);
                    break;
                }
                default: {
                    this.help(sender);
                    break;
                }
            }
        } else {
            this.help(sender);
        }
        return true;
    }

    public void help(CommandSender sender) {
        if (PlayerUtils.isMineChessAdmin(sender)) {
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&7[ [ &6[&fMineChess&6] &7] ]"));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage(""));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess create <name> &8Creates a new arena."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess build <name> &8Builds an arena on your current position."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess edit <name> &8Opens the editing GUI for an arena."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess delete <name> &8Deletes an arena."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess join <name> &8Joins an arena."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess joinrandom &8Joins a random arena."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess leave &8Leaves the Arena."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess spectate <arena/player> &8Spectates an arena or a player."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess setmainlobby &8Sets the Main Lobby."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess enable <name> &8Enables an arena."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess disable <name> &8Disables an arena."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess verify &8Checks the plugin for errors."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/minechess reload &8Reloads the config."));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage(""));
            sender.sendMessage(MessagesManager.getLegacyColoredMessage("&7[ [ &6[&fMineChess&6] &7] ]"));
        }
    }

    public void reload(CommandSender sender, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (!this.plugin.getConfigsManager().reload()) {
            sender.sendMessage(MineChess.prefix + MessagesManager.getLegacyColoredMessage("&cThere was an error reloading the config, check the console."));
            return;
        }
        msgManager.sendMessage(sender, messagesConfig.getString("configReloaded"), true);
    }

    public void create(Player player, String[] args, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length <= 1) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandCreateError"), true);
            return;
        }
        String name = args[1];
        ArenaManager arenaManager = this.plugin.getArenaManager();
        if (arenaManager.getArenaByName(name) != null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaAlreadyExist").replace("%arena%", name), true);
            return;
        }
        arenaManager.addArena(name);
        msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaCreated").replace("%arena%", name), true);
    }

    public void build(Player player, String[] args, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (this.plugin.getVerifyManager().isCriticalErrors()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("pluginCriticalErrors"), true);
            return;
        }
        if (args.length <= 1) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandBuildError"), true);
            return;
        }
        String name = args[1];
        ArenaManager arenaManager = this.plugin.getArenaManager();
        Arena arena = arenaManager.getArenaByName(name);
        if (arena == null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaDoesNotExist").replace("%arena%", name), true);
            return;
        }
        BoardManager boardManager = this.plugin.getBoardManager();
        boardManager.removeBoardFloor(arena);
        boardManager.buildBoardFloor(arena, player.getLocation());
        msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaBuilt").replace("%arena%", name), true);
    }

    public void delete(Player player, String[] args, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length <= 1) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandDeleteError"), true);
            return;
        }
        ArenaManager arenaManager = this.plugin.getArenaManager();
        Arena arena = arenaManager.getArenaByName(args[1]);
        if (arena == null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaDoesNotExist").replace("%arena%", args[1]), true);
            return;
        }
        if (!arena.isDisabled()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaMustBeDisabled"), true);
            return;
        }
        arenaManager.removeArena(args[1]);
        msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaDeleted").replace("%arena%", args[1]), true);
    }

    public void setMainLobby(Player player, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        Location l = player.getLocation().clone();
        this.plugin.getArenaManager().setMainLobbyLocation(l);
        this.plugin.getConfigsManager().getArenasConfigManager().saveMainLobby(l);
        msgManager.sendMessage((CommandSender)player, messagesConfig.getString("mainLobbySet"), true);
    }

    public void enable(CommandSender sender, String[] args, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length <= 1) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandEnableError"), true);
            return;
        }
        ArenaManager arenasManager = this.plugin.getArenaManager();
        Arena arena = arenasManager.getArenaByName(args[1]);
        if (arena == null) {
            msgManager.sendMessage(sender, messagesConfig.getString("arenaDoesNotExist").replace("%arena%", args[1]), true);
            return;
        }
        if (!arena.isDisabled()) {
            msgManager.sendMessage(sender, messagesConfig.getString("arenaAlreadyEnabled").replace("%arena%", args[1]), true);
            return;
        }
        String message = arenasManager.arenaIsValid(arena, messagesConfig);
        if (message != null) {
            msgManager.sendMessage(sender, message, true);
            return;
        }
        arena.enable();
        this.plugin.getConfigsManager().getArenasConfigManager().saveArena(arena);
        msgManager.sendMessage(sender, messagesConfig.getString("arenaEnabled").replace("%arena%", args[1]), true);
    }

    public void disable(CommandSender sender, String[] args, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin(sender)) {
            msgManager.sendMessage(sender, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length <= 1) {
            msgManager.sendMessage(sender, messagesConfig.getString("commandDisableError"), true);
            return;
        }
        ArenaManager arenasManager = this.plugin.getArenaManager();
        Arena arena = arenasManager.getArenaByName(args[1]);
        if (arena == null) {
            msgManager.sendMessage(sender, messagesConfig.getString("arenaDoesNotExist").replace("%arena%", args[1]), true);
            return;
        }
        if (arena.isDisabled()) {
            msgManager.sendMessage(sender, messagesConfig.getString("arenaAlreadyDisabled").replace("%arena%", args[1]), true);
            return;
        }
        arenasManager.disableArena(arena);
        this.plugin.getConfigsManager().getArenasConfigManager().saveArena(arena);
        msgManager.sendMessage(sender, messagesConfig.getString("arenaDisabled").replace("%arena%", args[1]), true);
    }

    public void join(Player player, String[] args, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player) && !player.hasPermission("minechess.join")) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length <= 1) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandJoinError"), true);
            return;
        }
        ArenaManager arenasManager = this.plugin.getArenaManager();
        Arena arena = arenasManager.getArenaByName(args[1]);
        if (arena == null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaDoesNotExist").replace("%arena%", args[1]), true);
            return;
        }
        arenasManager.joinArena(player, arena);
    }

    public void joinrandom(Player player, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player) && !player.hasPermission("minechess.join")) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        ArenaManager arenasManager = this.plugin.getArenaManager();
        arenasManager.joinRandomArena(player);
    }

    public void leave(Player player, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player) && !player.hasPermission("minechess.leave")) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        Arena arena = this.plugin.getArenaManager().getGamePlayerManager().getArenaByPlayer(player, true);
        if (arena == null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("playerNotPlaying"), true);
            return;
        }
        this.plugin.getArenaManager().leaveArena(player, arena, GameLeaveReason.COMMAND);
    }

    public void edit(Player player, String[] args, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length <= 1) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandEditError"), true);
            return;
        }
        ArenaManager arenaManager = this.plugin.getArenaManager();
        Arena arena = arenaManager.getArenaByName(args[1]);
        if (arena == null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaDoesNotExist").replace("%arena%", args[1]), true);
            return;
        }
        if (!arena.isDisabled()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaMustBeDisabled"), true);
            return;
        }
        String message = this.plugin.getArenaManager().arenaIsValid(arena, messagesConfig);
        if (message != null) {
            msgManager.sendMessage((CommandSender)player, message, true);
            return;
        }
        this.plugin.getEditInventoryManager().openArenaInventory(player, arena);
    }

    public void spectate(Player player, String[] args, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player) && !player.hasPermission("minechess.spectate")) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        if (args.length <= 1) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandSpectateError"), true);
            return;
        }
        ArenaManager arenasManager = this.plugin.getArenaManager();
        Arena arena = arenasManager.getArenaByName(args[1]);
        if (arena == null) {
            Player p = Bukkit.getPlayer((String)args[1]);
            if (p != null) {
                arena = arenasManager.getGamePlayerManager().getArenaByPlayer(p);
                if (arena != null) {
                    arenasManager.getGameSpectatorManager().joinArena(player, arena);
                } else {
                    msgManager.sendMessage((CommandSender)player, messagesConfig.getString("playerSpectateNotPlaying"), true);
                }
                return;
            }
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaDoesNotExist").replace("%arena%", args[1]), true);
            return;
        }
        arenasManager.getGameSpectatorManager().joinArena(player, arena);
    }

    public void verify(Player player, MessagesManager msgManager, FileConfiguration messagesConfig) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noPermissions"), true);
            return;
        }
        this.plugin.getVerifyManager().sendVerification(player);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<String> commands = this.getArgCommands(sender, args.length);
        if (args.length == 1) {
            for (String c : commands) {
                if (!args[0].isEmpty() && !c.startsWith(args[0].toLowerCase())) continue;
                completions.add(c);
            }
            return completions;
        }
        if (args.length == 2) {
            for (String c : commands) {
                if (!args[0].equalsIgnoreCase(c)) continue;
                if (c.equals("spectate")) {
                    List<String> playerCompletions;
                    List<String> arenaCompletions = this.getArenaCompletions(args);
                    if (arenaCompletions != null) {
                        completions.addAll(arenaCompletions);
                    }
                    if ((playerCompletions = this.getPlayerCompletions(args)) != null) {
                        completions.addAll(playerCompletions);
                    }
                    return completions;
                }
                return this.getArenaCompletions(args);
            }
        }
        return null;
    }

    private List<String> getArgCommands(CommandSender sender, int args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (sender.hasPermission("minechess.leave") && --args == 0) {
            commands.add("leave");
        }
        if (sender.hasPermission("minechess.join") && args == 0) {
            commands.add("joinrandom");
        }
        if (sender.hasPermission("minechess.join") && args <= 1) {
            commands.add("join");
        }
        if (sender.hasPermission("minechess.spectate") && args <= 1) {
            commands.add("spectate");
        }
        if (PlayerUtils.isMineChessAdmin(sender)) {
            if (args == 0) {
                commands.add("reload");
                commands.add("create");
                commands.add("setmainlobby");
                commands.add("verify");
            }
            if (args <= 1) {
                commands.add("delete");
                commands.add("build");
                commands.add("edit");
                commands.add("enable");
                commands.add("disable");
            }
        }
        return commands;
    }

    private List<String> getArenaCompletions(String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String argArena = args[1];
        ArrayList<Arena> arenas = this.plugin.getArenaManager().getArenas();
        for (Arena arena : arenas) {
            if (!argArena.isEmpty() && !arena.getName().toLowerCase().startsWith(argArena.toLowerCase())) continue;
            completions.add(arena.getName());
        }
        if (completions.isEmpty()) {
            return null;
        }
        return completions;
    }

    private List<String> getPlayerCompletions(String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String argPlayer = args[1];
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!argPlayer.isEmpty() && !player.getName().toLowerCase().startsWith(argPlayer.toLowerCase())) continue;
            completions.add(player.getName());
        }
        if (completions.isEmpty()) {
            return null;
        }
        return completions;
    }
}

