/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.config;

import java.util.ArrayList;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.model.CommonConfig;
import mc.ajneb97.manager.ArenaManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.ArenaEndTimeMode;
import mc.ajneb97.model.game.GameStatus;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class ArenasConfigManager {
    private MineChess plugin;
    private CommonConfig configFile;

    public ArenasConfigManager(MineChess plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("arenas.yml", plugin, null, false);
        this.configFile.registerConfig();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        Location mainLobbyLocation = null;
        if (config.contains("main_lobby")) {
            mainLobbyLocation = this.getExactLocationFromPath(config, "main_lobby");
        }
        ArrayList<Arena> arenas = new ArrayList<Arena>();
        if (config.contains("arenas")) {
            for (String key : config.getConfigurationSection("arenas").getKeys(false)) {
                Arena arena = new Arena(key);
                String path = "arenas." + key;
                arena.setLobbyLocation(this.getExactLocationFromPath(config, path + ".lobby"));
                arena.setBoardStartLocation(this.getExactLocationFromPath(config, path + ".board_start_location"));
                arena.setSpawnPlayer1Location(this.getExactLocationFromPath(config, path + ".spawn_1"));
                arena.setSpawnPlayer2Location(this.getExactLocationFromPath(config, path + ".spawn_2"));
                arena.setStatus(!config.getBoolean(path + ".enabled") ? GameStatus.DISABLED : GameStatus.WAITING);
                arena.setMaxTime(config.getInt(path + ".gamemode_values.max_time"));
                arena.setTurnTime(config.getInt(path + ".gamemode_values.turn_time"));
                if (config.contains(path + ".end_time")) {
                    arena.setEndTimeMode(ArenaEndTimeMode.valueOf(config.getString(path + ".end_time")));
                }
                arena.setBoardBlackCellBlock(Material.valueOf((String)config.getString(path + ".board_black_cell_block")));
                arena.setBoardWhiteCellBlock(Material.valueOf((String)config.getString(path + ".board_white_cell_block")));
                arenas.add(arena);
            }
        }
        ArenaManager arenasManager = this.plugin.getArenaManager();
        arenasManager.setArenas(arenas);
        arenasManager.setMainLobbyLocation(mainLobbyLocation);
    }

    public void saveMainLobby(Location location) {
        FileConfiguration config = this.configFile.getConfig();
        this.setConfigFromExactLocation(config, "main_lobby", location);
        this.saveConfig();
    }

    public void saveArena(Arena arena) {
        FileConfiguration config = this.configFile.getConfig();
        String path = "arenas." + arena.getName();
        config.set(path, null);
        this.setConfigFromExactLocation(config, path + ".lobby", arena.getLobbyLocation());
        this.setConfigFromExactLocation(config, path + ".board_start_location", arena.getBoardStartLocation());
        this.setConfigFromExactLocation(config, path + ".spawn_1", arena.getSpawnPlayer1Location());
        this.setConfigFromExactLocation(config, path + ".spawn_2", arena.getSpawnPlayer2Location());
        config.set(path + ".enabled", (Object)(!arena.getStatus().equals((Object)GameStatus.DISABLED) ? 1 : 0));
        config.set(path + ".gamemode", (Object)"ARENA_TIME");
        config.set(path + ".gamemode_values.max_time", (Object)arena.getMaxTime());
        config.set(path + ".gamemode_values.turn_time", (Object)arena.getTurnTime());
        if (arena.getEndTimeMode() != null) {
            config.set(path + ".end_time", (Object)arena.getEndTimeMode().name());
        }
        config.set(path + ".cell_size", (Object)"LARGE");
        config.set(path + ".pieces_type", (Object)"MODEL");
        config.set(path + ".board_black_cell_block", (Object)arena.getBoardBlackCellBlock().name());
        config.set(path + ".board_white_cell_block", (Object)arena.getBoardWhiteCellBlock().name());
        this.saveConfig();
    }

    public void deleteArena(String name) {
        FileConfiguration config = this.configFile.getConfig();
        config.set("arenas." + name, null);
        this.saveConfig();
    }

    private Location getExactLocationFromPath(FileConfiguration config, String path) {
        if (!config.contains(path)) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)config.getString(path + ".world")), config.getDouble(path + ".x"), config.getDouble(path + ".y"), config.getDouble(path + ".z"), (float)config.getDouble(path + ".yaw"), (float)config.getDouble(path + ".pitch"));
    }

    private Location getBlockLocationFromPath(FileConfiguration config, String path) {
        if (!config.contains(path)) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)config.getString(path + ".world")), (double)config.getInt(path + ".x"), (double)config.getInt(path + ".y"), (double)config.getInt(path + ".z"));
    }

    private void setConfigFromExactLocation(FileConfiguration config, String path, Location location) {
        if (location == null) {
            return;
        }
        config.set(path + ".world", (Object)location.getWorld().getName());
        config.set(path + ".x", (Object)location.getX());
        config.set(path + ".y", (Object)location.getY());
        config.set(path + ".z", (Object)location.getZ());
        config.set(path + ".yaw", (Object)Float.valueOf(location.getYaw()));
        config.set(path + ".pitch", (Object)Float.valueOf(location.getPitch()));
    }

    private void setConfigFromBlockLocation(FileConfiguration config, String path, Location location) {
        if (location == null) {
            return;
        }
        config.set(path + ".world", (Object)location.getWorld().getName());
        config.set(path + ".x", (Object)location.getBlockX());
        config.set(path + ".y", (Object)location.getBlockY());
        config.set(path + ".z", (Object)location.getBlockZ());
    }

    public void saveConfig() {
        this.configFile.saveConfig();
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }
}

