/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.MainConfigManager;
import mc.ajneb97.config.model.PieceColorStructure;
import mc.ajneb97.config.model.PieceHologramsValues;
import mc.ajneb97.config.model.PieceStructure;
import mc.ajneb97.config.model.PiecesHologramsConfig;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.PlayerColor;
import mc.ajneb97.model.chess.Board;
import mc.ajneb97.model.chess.Piece;
import mc.ajneb97.model.internal.CoordinatePiece;
import mc.ajneb97.utils.BlockUtils;
import mc.ajneb97.utils.GameUtils;
import mc.ajneb97.utils.ServerVersion;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;

public class BoardManager {
    private MineChess plugin;
    public static final int CELL_SIZE = 3;

    public BoardManager(MineChess plugin) {
        this.plugin = plugin;
    }

    public void buildBoardFloor(Arena arena, Location location) {
        Material whiteCellMaterial = arena.getBoardWhiteCellBlock();
        Material blackCellMaterial = arena.getBoardBlackCellBlock();
        Location startLocation = new Location(location.getWorld(), (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ()).add(0.0, -1.0, 0.0);
        arena.configureLocations(startLocation, 3);
        Location currentLocation = startLocation.clone();
        boolean buildWhite = true;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (buildWhite) {
                    this.buildCell(currentLocation.clone().add((double)(j * 3), 0.0, 0.0), whiteCellMaterial);
                } else {
                    this.buildCell(currentLocation.clone().add((double)(j * 3), 0.0, 0.0), blackCellMaterial);
                }
                buildWhite = !buildWhite;
            }
            buildWhite = !buildWhite;
            currentLocation.add(0.0, 0.0, 3.0);
        }
        this.plugin.getConfigsManager().getArenasConfigManager().saveArena(arena);
    }

    public void removeBoardFloor(Arena arena) {
        if (arena.getBoardStartLocation() == null) {
            return;
        }
        Location currentLocation = arena.getBoardStartLocation().clone();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.removeCell(currentLocation.clone().add((double)(j * 3), 0.0, 0.0));
            }
            currentLocation.add(0.0, 0.0, 3.0);
        }
    }

    private void buildCell(Location currentLocation, Material material) {
        World world = currentLocation.getWorld();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                world.getBlockAt(currentLocation.clone().add((double)j, 0.0, 0.0)).setType(material);
            }
            currentLocation.add(0.0, 0.0, 1.0);
        }
    }

    private void removeCell(Location currentLocation) {
        World world = currentLocation.getWorld();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                world.getBlockAt(currentLocation.clone().add((double)j, 0.0, 0.0)).setType(Material.AIR);
            }
            currentLocation.add(0.0, 0.0, 1.0);
        }
    }

    public void buildBoardPieces(Arena arena) {
        Board board = arena.getBoard();
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                Piece piece = board.getPiece(x, y);
                if (piece == null) continue;
                this.buildPiece(piece, x, y, arena, mainConfigManager);
            }
        }
    }

    public void removeBoardPieces(Arena arena) {
        Board board = arena.getBoard();
        if (arena.getBoardStartLocation() == null) {
            return;
        }
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                Piece piece = board.getPiece(x, y);
                this.removePiece(piece, x, y, arena);
            }
        }
    }

    public void cleanArenas() {
        for (Arena arena : this.plugin.getArenaManager().getArenas()) {
            this.removeBoardPieces(arena);
        }
    }

    public void buildPiece(Piece piece, int x, int y, Arena arena, MainConfigManager mainConfigManager) {
        Location startingLocation = arena.getBoardStartLocation();
        double locIncreaseX = 1.5 + (double)(3 * x);
        double locIncreaseZ = 1.5 + (double)(3 * y);
        PieceStructure pieceStructure = mainConfigManager.getPieceStructure(piece.getType());
        Location currentLocation = startingLocation.clone().add(locIncreaseX, 0.0, locIncreaseZ);
        World world = currentLocation.getWorld();
        this.buildPieceBlock(piece, pieceStructure, currentLocation.clone(), world);
        this.buildPieceHologram(piece, pieceStructure, currentLocation.clone(), world, mainConfigManager);
    }

    private void buildPieceBlock(Piece piece, PieceStructure pieceStructure, Location currentLocation, World world) {
        List<String> structure = piece.getColor().equals((Object)PlayerColor.BLACK) ? pieceStructure.getBlackPiece().getBlocks() : pieceStructure.getWhitePiece().getBlocks();
        for (int i = structure.size() - 1; i >= 0; --i) {
            String blockStructure = structure.get(i);
            currentLocation = currentLocation.add(0.0, 1.0, 0.0);
            Block block = world.getBlockAt(currentLocation);
            if (blockStructure.startsWith("PLAYER_HEAD") && blockStructure.contains(";")) {
                block.setType(Material.PLAYER_HEAD);
                BlockUtils.setHeadTextureData(block, blockStructure.split(";")[1], null);
                Rotatable rotatable = (Rotatable)block.getBlockData();
                if (piece.getColor().equals((Object)PlayerColor.BLACK)) {
                    rotatable.setRotation(BlockFace.NORTH);
                } else {
                    rotatable.setRotation(BlockFace.SOUTH);
                }
                block.setBlockData((BlockData)rotatable);
                block.getState().update(true);
                continue;
            }
            block.setType(Material.valueOf((String)blockStructure));
            BlockData blockData = block.getBlockData();
            if (!(blockData instanceof Directional)) continue;
            Directional directional = (Directional)blockData;
            if (piece.getColor().equals((Object)PlayerColor.BLACK)) {
                directional.setFacing(BlockFace.SOUTH);
            } else {
                directional.setFacing(BlockFace.NORTH);
            }
            block.setBlockData((BlockData)directional);
            block.getState().update(true);
        }
    }

    private void buildPieceHologram(Piece piece, PieceStructure pieceStructure, Location currentLocation, World world, MainConfigManager mainConfigManager) {
        ArmorStand a;
        PieceColorStructure pieceColorStructure;
        PiecesHologramsConfig piecesHologramsConfig = mainConfigManager.getPiecesHologramsConfig();
        if (!piecesHologramsConfig.isEnabled()) {
            return;
        }
        PieceHologramsValues pieceHologramsValues = piecesHologramsConfig.getValues();
        PieceColorStructure pieceColorStructure2 = pieceColorStructure = piece.getColor().equals((Object)PlayerColor.BLACK) ? pieceStructure.getBlackPiece() : pieceStructure.getWhitePiece();
        if (pieceColorStructure.getHologramsValues() != null) {
            pieceHologramsValues = pieceColorStructure.getHologramsValues();
        }
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        String text = pieceHologramsValues.getText();
        String pieceName = GameUtils.getPieceNameFromConfig(piece.getType(), messagesConfig);
        String pieceColor = GameUtils.getColorFromConfig(piece.getColor(), messagesConfig);
        currentLocation = currentLocation.add(0.0, pieceHologramsValues.getOffsetY(), 0.0);
        ServerVersion serverVersion = MineChess.serverVersion;
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_17_R1)) {
            if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_20_R3)) {
                a = (ArmorStand)world.spawn(currentLocation, ArmorStand.class, armorStand -> this.setHologramProperties((ArmorStand)armorStand, text, pieceName, pieceColor));
            } else {
                try {
                    a = (ArmorStand)world.getClass().getMethod("spawn", Location.class, Class.class, Consumer.class).invoke((Object)world, currentLocation, ArmorStand.class, armorStand -> this.setHologramProperties((ArmorStand)armorStand, text, pieceName, pieceColor));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            a = (ArmorStand)world.spawn(currentLocation, ArmorStand.class);
            this.setHologramProperties(a, text, pieceName, pieceColor);
        }
        if (piece.getHologram() != null) {
            piece.getHologram().remove();
        }
        piece.setHologram(a);
    }

    private void setHologramProperties(ArmorStand armorStand, String text, String pieceName, String pieceColor) {
        armorStand.setGravity(false);
        armorStand.setAI(false);
        armorStand.setInvulnerable(true);
        armorStand.setInvisible(true);
        armorStand.setMarker(true);
        armorStand.setPersistent(false);
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        text = text.replace("%piece%", pieceName).replace("%color%", pieceColor);
        if (mainConfigManager.isUseMiniMessage()) {
            armorStand.customName(MiniMessage.miniMessage().deserialize((Object)text));
        } else {
            armorStand.setCustomName(MessagesManager.getLegacyColoredMessage(text));
        }
        armorStand.setCustomNameVisible(true);
        armorStand.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "minechess"), PersistentDataType.STRING, (Object)"piece_hologram");
    }

    public void updateCell(CoordinatePiece pieceToUpdate, Arena arena) {
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        Piece piece = arena.getBoard().getPiece(pieceToUpdate.getX(), pieceToUpdate.getY());
        this.removePiece(pieceToUpdate.getPiece(), pieceToUpdate.getX(), pieceToUpdate.getY(), arena);
        if (piece != null) {
            this.buildPiece(piece, pieceToUpdate.getX(), pieceToUpdate.getY(), arena, mainConfigManager);
        }
    }

    public void removePiece(Piece piece, int x, int y, Arena arena) {
        int maxHeight = 5;
        Location startingLocation = arena.getBoardStartLocation();
        double locIncreaseX = 1.5 + (double)(3 * x);
        double locIncreaseZ = 1.5 + (double)(3 * y);
        Location currentLocation = startingLocation.clone().add(locIncreaseX, 0.0, locIncreaseZ);
        World world = currentLocation.getWorld();
        for (int i = maxHeight - 1; i >= 0; --i) {
            currentLocation = currentLocation.add(0.0, 1.0, 0.0);
            world.getBlockAt(currentLocation).setType(Material.AIR);
        }
        PiecesHologramsConfig piecesHologramsConfig = this.plugin.getConfigsManager().getMainConfigManager().getPiecesHologramsConfig();
        if (piecesHologramsConfig.isEnabled() && piece != null && piece.getHologram() != null) {
            piece.getHologram().remove();
        }
    }

    public int[] getPiecePositionFromLocation(Location l, Arena arena) {
        int blockX = l.getBlockX();
        int blockZ = l.getBlockZ();
        int newPointX = (blockX - arena.getBoardStartLocation().getBlockX()) / 3;
        int newPointZ = (blockZ - arena.getBoardStartLocation().getBlockZ()) / 3;
        if (newPointX < 0 || newPointX > 7) {
            return null;
        }
        if (newPointZ < 0 || newPointZ > 7) {
            return null;
        }
        return new int[]{newPointX, newPointZ};
    }

    public Location getCellLocationFromPosition(int[] position, Arena arena) {
        int boardStartX = arena.getBoardStartLocation().getBlockX();
        int boardStartZ = arena.getBoardStartLocation().getBlockZ();
        int x = boardStartX + position[0] * 3 + 1;
        int z = boardStartZ + position[1] * 3 + 1;
        return new Location(arena.getBoardStartLocation().getWorld(), (double)x, arena.getBoardStartLocation().getY(), (double)z);
    }

    public Location getCellLocationFromPositionCentered(int[] position, Arena arena) {
        Location l = this.getCellLocationFromPosition(position, arena);
        l.add(0.5, 0.0, 0.5);
        return l;
    }

    public ArrayList<Location> getCellBlockLocationsFromPosition(int[] position, Arena arena) {
        ArrayList<Location> locations = new ArrayList<Location>();
        Location startLocation = this.getCellLocationFromPosition(position, arena).add(-1.0, 0.0, -1.0);
        locations.add(startLocation);
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                if (x == 0 && z == 0) continue;
                locations.add(startLocation.clone().add((double)x, 0.0, (double)z));
            }
        }
        return locations;
    }

    public PlayerColor getCellColor(int[] position) {
        return (position[0] + position[1]) % 2 == 0 ? PlayerColor.WHITE : PlayerColor.BLACK;
    }
}

