/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import java.util.Map;
import java.util.UUID;
import mc.ajneb97.MineChess;
import mc.ajneb97.model.data.PlayerDataBackup;
import mc.ajneb97.utils.ItemUtils;
import mc.ajneb97.utils.ServerVersion;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerDataBackupManager {
    private MineChess plugin;
    private Map<UUID, PlayerDataBackup> players;

    public PlayerDataBackupManager(MineChess plugin) {
        this.plugin = plugin;
    }

    public Map<UUID, PlayerDataBackup> getPlayers() {
        return this.players;
    }

    public void setPlayers(Map<UUID, PlayerDataBackup> players) {
        this.players = players;
    }

    public PlayerDataBackup getPlayer(Player player) {
        return this.players.get(player.getUniqueId());
    }

    public void restorePlayerDataBackup(final Player player, boolean teleportToLobby, boolean async) {
        PlayerDataBackup playerDataBackup = this.getPlayer(player);
        if (playerDataBackup == null) {
            return;
        }
        player.getInventory().setContents(playerDataBackup.getInventory());
        player.setGameMode(playerDataBackup.getGamemode());
        player.setLevel(playerDataBackup.getLevel());
        player.setExp(playerDataBackup.getXp());
        player.setFoodLevel(playerDataBackup.getFood());
        ServerVersion serverVersion = MineChess.serverVersion;
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R2)) {
            player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(playerDataBackup.getMaxHealth());
        } else {
            player.getAttribute(ItemUtils.getAttributeByName("GENERIC_MAX_HEALTH")).setBaseValue(playerDataBackup.getMaxHealth());
        }
        player.setHealth(playerDataBackup.getHealth());
        for (PotionEffect p : player.getActivePotionEffects()) {
            player.removePotionEffect(p.getType());
        }
        player.setAllowFlight(playerDataBackup.isAllowFlight());
        player.setFlying(playerDataBackup.isFlying());
        if (teleportToLobby) {
            Location location = this.plugin.getArenaManager().getMainLobbyLocation();
            player.teleport(location);
        }
        this.players.remove(player.getUniqueId());
        if (async) {
            new BukkitRunnable(){

                public void run() {
                    PlayerDataBackupManager.this.plugin.getConfigsManager().getPlayersConfigManager().saveBackupConfig(player.getUniqueId().toString(), null);
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        } else {
            this.plugin.getConfigsManager().getPlayersConfigManager().saveBackupConfig(player.getUniqueId().toString(), null);
        }
    }

    public void createPlayerDataBackup(final Player player) {
        ServerVersion serverVersion = MineChess.serverVersion;
        double maxHealth = serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R2) ? player.getAttribute(Attribute.MAX_HEALTH).getBaseValue() : player.getAttribute(ItemUtils.getAttributeByName("GENERIC_MAX_HEALTH")).getBaseValue();
        final PlayerDataBackup playerDataBackup = new PlayerDataBackup((ItemStack[])player.getInventory().getContents().clone(), player.getGameMode(), player.getExp(), player.getLevel(), player.getFoodLevel(), player.getHealth(), maxHealth, player.getAllowFlight(), player.isFlying());
        this.players.put(player.getUniqueId(), playerDataBackup);
        new BukkitRunnable(){

            public void run() {
                PlayerDataBackupManager.this.plugin.getConfigsManager().getPlayersConfigManager().saveBackupConfig(player.getUniqueId().toString(), playerDataBackup);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }
}

