/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import java.util.ArrayList;
import java.util.List;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.MainConfigManager;
import mc.ajneb97.config.model.GameActionsEndGame;
import mc.ajneb97.config.model.GameActionsGame;
import mc.ajneb97.config.model.GameActionsRewards;
import mc.ajneb97.config.model.PieceColorStructure;
import mc.ajneb97.config.model.PieceInteractions;
import mc.ajneb97.config.model.PieceStructure;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.manager.inventory.InventoryManager;
import mc.ajneb97.model.chess.PieceType;
import mc.ajneb97.model.inventory.CommonInventory;
import mc.ajneb97.model.inventory.CommonInventoryItem;
import mc.ajneb97.model.items.CommonItem;
import mc.ajneb97.model.verify.MineChessActionError;
import mc.ajneb97.model.verify.MineChessBaseError;
import mc.ajneb97.model.verify.MineChessInvalidItem;
import mc.ajneb97.model.verify.MineChessInvalidParticle;
import mc.ajneb97.model.verify.MineChessInvalidPieceType;
import mc.ajneb97.model.verify.MineChessInventoryInvalidSlotError;
import mc.ajneb97.model.verify.MineChessNoPieceBlocks;
import mc.ajneb97.utils.ItemUtils;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public class VerifyManager {
    private MineChess plugin;
    private ArrayList<MineChessBaseError> errors;
    private boolean criticalErrors;

    public VerifyManager(MineChess plugin) {
        this.plugin = plugin;
        this.errors = new ArrayList();
        this.criticalErrors = false;
    }

    public void sendVerification(Player player) {
        player.sendMessage(MessagesManager.getLegacyColoredMessage("&f&l- - - - - - - - &6&lMINECHESS VERIFY &f&l- - - - - - - -"));
        player.sendMessage(MessagesManager.getLegacyColoredMessage(""));
        if (this.errors.isEmpty()) {
            player.sendMessage(MessagesManager.getLegacyColoredMessage("&aThere are no errors in the plugin ;)"));
        } else {
            player.sendMessage(MessagesManager.getLegacyColoredMessage("&e&oHover on the errors to see more information."));
            for (MineChessBaseError error : this.errors) {
                error.sendMessage(player);
            }
        }
        player.sendMessage(MessagesManager.getLegacyColoredMessage(""));
        player.sendMessage(MessagesManager.getLegacyColoredMessage("&f&l- - - - - - - - &6&lMINECHESS VERIFY &f&l- - - - - - - -"));
    }

    public void verify() {
        this.errors = new ArrayList();
        this.criticalErrors = false;
        this.verifyConfigOptions();
        this.verifyArenas();
        InventoryManager inventoryManager = this.plugin.getInventoryManager();
        ArrayList<CommonInventory> inventories = inventoryManager.getInventories();
        for (CommonInventory inventory : inventories) {
            this.verifyInventory(inventory);
        }
    }

    public void verifyArenas() {
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        ArrayList<PieceStructure> pieceStructure = mainConfigManager.getPieceStructures();
        for (PieceStructure piece : pieceStructure) {
            PieceColorStructure pieceColorBlack = piece.getBlackPiece();
            PieceColorStructure pieceColorWhite = piece.getWhitePiece();
            if (pieceColorBlack.getBlocks() != null && pieceColorWhite.getBlocks() != null) continue;
            this.errors.add(new MineChessNoPieceBlocks("config.yml", null, true, piece.getPieceType().name().toLowerCase()));
            this.criticalErrors = true;
        }
    }

    public void verifyConfigOptions() {
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        PieceInteractions pieceInteractions = mainConfigManager.getPieceInteractions();
        this.verifyParticleAndAddError("config.yml", pieceInteractions.getSeeCell().getValue());
        this.verifyParticleAndAddError("config.yml", pieceInteractions.getSelectedPiece().getValue());
        this.verifyParticleAndAddError("config.yml", pieceInteractions.getValidMovements().getValue());
        this.verifyParticleAndAddError("config.yml", pieceInteractions.getSeeValidMovementCell().getValue());
        GameActionsGame gameActionsGame = mainConfigManager.getGameActions().getGameActionsGame();
        this.verifyActions(gameActionsGame.getSelectPiece(), "game.select_piece", "config.yml");
        this.verifyActions(gameActionsGame.getDeselectPiece(), "game.deselect_piece", "config.yml");
        this.verifyActions(gameActionsGame.getChangeTurn(), "game.change_turn", "config.yml");
        this.verifyActions(gameActionsGame.getMovePiece(), "game.move_piece", "config.yml");
        this.verifyActions(gameActionsGame.getCapturePiece(), "game.capture_piece", "config.yml");
        this.verifyActions(gameActionsGame.getCapturePieceEnPassant(), "game.capture_piece_enpassant", "config.yml");
        this.verifyActions(gameActionsGame.getKingInCheck(), "game.king_in_check", "config.yml");
        this.verifyActions(gameActionsGame.getCastling(), "game.castling", "config.yml");
        this.verifyActions(gameActionsGame.getPromotion(), "game.promotion", "config.yml");
        GameActionsRewards gameActionsRewards = mainConfigManager.getGameActions().getGameActionsRewards();
        this.verifyActions(gameActionsRewards.getEndByTimeActions(), "rewards.end_by_time", "config.yml");
        this.verifyActions(gameActionsRewards.getEndByPlayerTimeActions(), "rewards.end_by_player_time", "config.yml");
        this.verifyActions(gameActionsRewards.getEndByTimeTieActions(), "rewards.end_by_time_tie", "config.yml");
        this.verifyActions(gameActionsRewards.getEndByStalemateTieActions(), "rewards.end_by_stalemate_tie", "config.yml");
        this.verifyActions(gameActionsRewards.getEndByCheckmateActions(), "rewards.end_by_checkmate", "config.yml");
        this.verifyActions(gameActionsRewards.getEndByLeaveActions(), "rewards.end_by_leave", "config.yml");
        GameActionsEndGame gameActionsEndGame = mainConfigManager.getGameActions().getGameActionsEndGame();
        this.verifyActions(gameActionsEndGame.getEndByTimeActions(), "end_game.end_by_time", "config.yml");
        this.verifyActions(gameActionsEndGame.getEndByPlayerTimeActions(), "end_game.end_by_player_time", "config.yml");
        this.verifyActions(gameActionsEndGame.getEndByTimeTieActions(), "end_game.end_by_time_tie", "config.yml");
        this.verifyActions(gameActionsEndGame.getEndByStalemateTieActions(), "end_game.end_by_stalemate_tie", "config.yml");
        this.verifyActions(gameActionsEndGame.getEndByCheckmateActions(), "end_game.end_by_checkmate", "config.yml");
        this.verifyActions(gameActionsEndGame.getEndByLeaveActions(), "end_game.end_by_leave", "config.yml");
    }

    public void verifyActions(List<String> actions, String actionGroup, String fileName) {
        if (actions == null) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            String actionOriginal = actions.get(i);
            String action = actionOriginal.replace("to_all: ", "").replace("to_opponent: ", "").replace("to_winner: ", "");
            String[] actionText = action.split(" ");
            String actionName = actionText[0];
            if (actionName.equals("console_command:") || actionName.equals("player_command:") || actionName.equals("playsound:") || actionName.equals("message:") || actionName.equals("centered_message:") || actionName.equals("title:")) continue;
            this.errors.add(new MineChessActionError(fileName, actions.get(i), false, actionGroup, "" + (i + 1)));
        }
    }

    public void verifyInventory(CommonInventory inventory) {
        List<CommonInventoryItem> items = inventory.getItems();
        int maxSlots = inventory.getSlots();
        for (CommonInventoryItem item : items) {
            CommonItem commonItem;
            String type = item.getType();
            if (type != null && type.startsWith("piece: ")) {
                String pieceName = type.replace("piece: ", "").toUpperCase();
                try {
                    PieceType.valueOf(pieceName);
                }
                catch (Exception e) {
                    this.errors.add(new MineChessInvalidPieceType("inventory.yml", null, true, pieceName));
                    this.criticalErrors = true;
                }
            }
            if ((commonItem = item.getItem()) != null) {
                this.verifyItemAndAddError("inventory.yml", commonItem.getId());
            }
            for (int slot : item.getSlots()) {
                if (slot < maxSlots) continue;
                this.errors.add(new MineChessInventoryInvalidSlotError("inventory.yml", null, true, slot, inventory.getName(), maxSlots));
                this.criticalErrors = true;
            }
        }
    }

    public boolean isCriticalErrors() {
        return this.criticalErrors;
    }

    public void verifyItemAndAddError(String file, String material) {
        try {
            ItemUtils.createItemFromID(material);
        }
        catch (Exception e) {
            this.errors.add(new MineChessInvalidItem(file, null, true, material));
            this.criticalErrors = true;
        }
    }

    public void verifyParticleAndAddError(String file, String particle) {
        particle = particle.split(";")[0];
        try {
            Particle.valueOf((String)particle);
        }
        catch (Exception e) {
            this.errors.add(new MineChessInvalidParticle(file, null, false, particle));
        }
    }
}

