/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager.interactions;

import java.util.ArrayList;
import java.util.Arrays;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.MainConfigManager;
import mc.ajneb97.manager.BoardManager;
import mc.ajneb97.manager.inventory.InventoryType;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.PlayerColor;
import mc.ajneb97.model.chess.Movement;
import mc.ajneb97.model.chess.MovementType;
import mc.ajneb97.model.chess.Piece;
import mc.ajneb97.model.chess.PieceType;
import mc.ajneb97.model.game.GameEndsReason;
import mc.ajneb97.model.game.GamePlayer;
import mc.ajneb97.model.internal.CheckValidationResult;
import mc.ajneb97.model.internal.CommonVariable;
import mc.ajneb97.model.internal.CoordinatePiece;
import mc.ajneb97.model.internal.MovePieceResult;
import mc.ajneb97.model.inventory.InventoryPlayer;
import mc.ajneb97.utils.ActionUtils;
import mc.ajneb97.utils.GameUtils;
import org.bukkit.configuration.file.FileConfiguration;

public class GamePieceInteractionManager {
    private MineChess plugin;

    public GamePieceInteractionManager(MineChess plugin) {
        this.plugin = plugin;
    }

    public void selectPiece(GamePlayer gamePlayer, Arena arena, Piece piece) {
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        int[] seeingPos = gamePlayer.getSeeingPos();
        int[] selectedPos = gamePlayer.getSelectedPos();
        PieceType pieceType = piece.getType();
        String pieceName = GameUtils.getPieceNameFromConfig(pieceType, messagesConfig);
        String coords = GameUtils.getRealCoords(seeingPos[0], seeingPos[1]);
        ArrayList<CommonVariable> variables = new ArrayList<CommonVariable>();
        variables.add(new CommonVariable("%player%", gamePlayer.getName()));
        variables.add(new CommonVariable("%piece%", pieceName));
        variables.add(new CommonVariable("%coords%", coords));
        if (selectedPos != null && Arrays.equals(selectedPos, seeingPos)) {
            gamePlayer.setSelectedPos(null);
            gamePlayer.setSelectedPieceAvailableMovements(null);
            ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getDeselectPiece(), this.plugin, variables, false);
        } else {
            gamePlayer.setSelectedPos(seeingPos);
            gamePlayer.setSelectedPieceAvailableMovements(arena.getBoard().getPossibleMovements(seeingPos[0], seeingPos[1], true));
            ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getSelectPiece(), this.plugin, variables, false);
        }
        gamePlayer.setDelaySelectPieceNextMillis(System.currentTimeMillis() + 200L);
    }

    public void movePieceAutomatically(GamePlayer gamePlayerTurn, Arena arena, int xFrom, int yFrom, Movement movement) {
        int[] seeingPos = new int[]{movement.getX(), movement.getY()};
        int[] selectedPos = new int[]{xFrom, yFrom};
        this.movePiece(gamePlayerTurn, arena, seeingPos, selectedPos, movement);
    }

    public void movePieceManually(GamePlayer gamePlayer, Arena arena, Movement movement) {
        int[] seeingPos = gamePlayer.getSeeingPos();
        int[] selectedPos = gamePlayer.getSelectedPos();
        this.movePiece(gamePlayer, arena, seeingPos, selectedPos, movement);
    }

    private void movePiece(GamePlayer gamePlayer, Arena arena, int[] seeingPos, int[] selectedPos, Movement movement) {
        boolean isCapture;
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        Piece selectedPiece = arena.getBoard().getPiece(selectedPos[0], selectedPos[1]);
        BoardManager boardManager = this.plugin.getBoardManager();
        MovePieceResult movePieceResult = arena.getBoard().move(selectedPos[0], selectedPos[1], movement);
        for (CoordinatePiece p : movePieceResult.getPiecesToUpdate()) {
            boardManager.updateCell(p, arena);
        }
        String movedPieceName = GameUtils.getPieceNameFromConfig(selectedPiece.getType(), messagesConfig);
        String coordsString = GameUtils.getRealCoords(seeingPos[0], seeingPos[1]);
        GamePlayer opponentPlayer = arena.getOpponentPlayer(gamePlayer);
        ArrayList<CommonVariable> variables = new ArrayList<CommonVariable>();
        variables.add(new CommonVariable("%player%", gamePlayer.getName()));
        variables.add(new CommonVariable("%opponent_player%", opponentPlayer.getName()));
        boolean bl = isCapture = movement.getType().equals((Object)MovementType.CAPTURE) || movement.getType().equals((Object)MovementType.EN_PASSANT) || movement.getType().equals((Object)MovementType.PROMOTION_CAPTURE);
        if (isCapture) {
            String capturedPieceName = GameUtils.getPieceNameFromConfig(movePieceResult.getCapturedPieceType(), messagesConfig);
            variables.add(new CommonVariable("%piece%", movedPieceName));
            variables.add(new CommonVariable("%coords%", coordsString));
            variables.add(new CommonVariable("%opponent_player_piece%", capturedPieceName));
            if (movement.getType().equals((Object)MovementType.EN_PASSANT)) {
                ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getCapturePieceEnPassant(), this.plugin, variables, true);
            } else {
                ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getCapturePiece(), this.plugin, variables, true);
            }
            this.capturePoints(gamePlayer, movePieceResult.getCapturedPieceType(), mainConfigManager);
        } else if (movement.getType().name().startsWith("CASTLING")) {
            String castlingCoords = null;
            castlingCoords = movement.getType().equals((Object)MovementType.CASTLING_LONG) ? GameUtils.getRealCoords(2, selectedPos[1]) : GameUtils.getRealCoords(6, selectedPos[1]);
            variables.add(new CommonVariable("%coords%", castlingCoords));
            ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getCastling(), this.plugin, variables, true);
        } else {
            variables.add(new CommonVariable("%piece%", movedPieceName));
            variables.add(new CommonVariable("%coords%", coordsString));
            ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getMovePiece(), this.plugin, variables, true);
        }
        CheckValidationResult result = this.check(arena, gamePlayer, opponentPlayer, mainConfigManager, variables);
        if (result.equals((Object)CheckValidationResult.CHECKMATE) || result.equals((Object)CheckValidationResult.STALEMATE)) {
            return;
        }
        if (movement.getType().name().startsWith("PROMOTION")) {
            gamePlayer.setPromotionPos(new int[]{seeingPos[0], seeingPos[1]});
            this.plugin.getInventoryManager().openInventory(new InventoryPlayer(gamePlayer.getPlayer(), InventoryType.PROMOTION));
            return;
        }
        if (this.consecutiveMovementsWithoutProgressReached(arena, isCapture, selectedPiece.getType().equals((Object)PieceType.PAWN), mainConfigManager)) {
            return;
        }
        if (this.insufficientMaterialReached(arena)) {
            return;
        }
        this.plugin.getArenaManager().changeTurn(arena, !result.equals((Object)CheckValidationResult.CHECK));
    }

    public void promotePawn(Arena arena, GamePlayer gamePlayer, PieceType pieceType) {
        int[] promotionPos = gamePlayer.getPromotionPos();
        CoordinatePiece pieceToUpdate = arena.getBoard().promotePawn(promotionPos[0], promotionPos[1], pieceType, arena.getColor(gamePlayer));
        gamePlayer.setPromotionPos(null);
        gamePlayer.getPlayer().closeInventory();
        BoardManager boardManager = this.plugin.getBoardManager();
        boardManager.updateCell(pieceToUpdate, arena);
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        String movedPieceName = GameUtils.getPieceNameFromConfig(pieceType, messagesConfig);
        ArrayList<CommonVariable> variables = new ArrayList<CommonVariable>();
        GamePlayer opponentPlayer = arena.getOpponentPlayer(gamePlayer);
        variables.add(new CommonVariable("%player%", gamePlayer.getName()));
        variables.add(new CommonVariable("%piece%", movedPieceName));
        variables.add(new CommonVariable("%opponent_player%", opponentPlayer.getName()));
        ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getPromotion(), this.plugin, variables, true);
        CheckValidationResult result = this.check(arena, gamePlayer, opponentPlayer, mainConfigManager, variables);
        if (result.equals((Object)CheckValidationResult.CHECKMATE) || result.equals((Object)CheckValidationResult.STALEMATE)) {
            return;
        }
        this.plugin.getArenaManager().changeTurn(arena, !result.equals((Object)CheckValidationResult.CHECK));
    }

    private CheckValidationResult check(Arena arena, GamePlayer gamePlayer, GamePlayer opponentPlayer, MainConfigManager mainConfigManager, ArrayList<CommonVariable> variables) {
        PlayerColor opponentColor = arena.getColor(opponentPlayer);
        int amountOfMovements = arena.getBoard().getAllPossibleMovements(opponentColor).size();
        if (arena.getBoard().verifyInCheck(opponentColor)) {
            if (amountOfMovements == 0) {
                arena.setWinner(gamePlayer);
                this.plugin.getArenaManager().getGameEndManager().startEndingStage(arena, GameEndsReason.CHECKMATE);
                return CheckValidationResult.CHECKMATE;
            }
            ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getKingInCheck(), this.plugin, variables, true);
            return CheckValidationResult.CHECK;
        }
        if (amountOfMovements == 0) {
            this.plugin.getArenaManager().getGameEndManager().startEndingStage(arena, GameEndsReason.STALEMATE);
            return CheckValidationResult.STALEMATE;
        }
        return CheckValidationResult.NONE;
    }

    private boolean consecutiveMovementsWithoutProgressReached(Arena arena, boolean isCapture, boolean isPawnMovement, MainConfigManager mainConfigManager) {
        if (isCapture || isPawnMovement) {
            arena.setMovementsWithoutProgress(0);
            return false;
        }
        arena.setMovementsWithoutProgress(arena.getMovementsWithoutProgress() + 1);
        int maxMovements = mainConfigManager.getMaxConsecutiveMovementsWithoutProgress();
        if (arena.getMovementsWithoutProgress() >= maxMovements) {
            this.plugin.getArenaManager().getGameEndManager().startEndingStage(arena, GameEndsReason.MOVEMENTS_WITHOUT_PROGRESS);
            return true;
        }
        return false;
    }

    private boolean insufficientMaterialReached(Arena arena) {
        if (arena.getBoard().isInsufficientMaterial()) {
            this.plugin.getArenaManager().getGameEndManager().startEndingStage(arena, GameEndsReason.INSUFFICIENT_MATERIAL);
            return true;
        }
        return false;
    }

    private void capturePoints(GamePlayer gamePlayer, PieceType pieceType, MainConfigManager mainConfigManager) {
        int points = mainConfigManager.getPieceStructure(pieceType).getPoints();
        gamePlayer.addPoints(points);
    }

    public void updateInteractions(GamePlayer gamePlayer) {
        gamePlayer.setSeeingPos(null);
        gamePlayer.setSelectedPos(null);
        gamePlayer.setSelectedPieceAvailableMovements(null);
    }
}

