/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.ajneb97.model.internal.CommonVariable;
import mc.ajneb97.model.internal.VariablesProperties;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class VariablesUtils {
    private static final Pattern subVariablesPattern = Pattern.compile("\\{([^{}]+)}");

    public static String replaceAllVariablesInLine(String textLine, VariablesProperties variablesProperties) {
        StringBuilder newText = new StringBuilder();
        int pos = 0;
        while (pos < textLine.length()) {
            int indexLast;
            char posChar = textLine.charAt(pos);
            if (posChar == '%' && (indexLast = textLine.indexOf(37, pos + 1)) != -1) {
                String variable = textLine.substring(pos, indexLast + 1);
                String replacedSubVariables = VariablesUtils.replaceSubVariables(variable, variablesProperties);
                String finalReplaced = VariablesUtils.manageVariableReplacement(replacedSubVariables.substring(1, replacedSubVariables.length() - 1), variablesProperties, false);
                pos = indexLast;
                if (variable.equals(finalReplaced)) {
                    --pos;
                    finalReplaced = finalReplaced.substring(0, finalReplaced.length() - 1);
                }
                ++pos;
                newText.append(finalReplaced);
                continue;
            }
            newText.append(posChar);
            ++pos;
        }
        return newText.toString();
    }

    private static String replaceSubVariables(String input, VariablesProperties variablesProperties) {
        boolean parseOther = input.contains("parseother_");
        Matcher matcher = subVariablesPattern.matcher(input);
        StringBuffer buffer = new StringBuffer();
        for (int finds = 0; matcher.find() && (!parseOther || finds < 1); ++finds) {
            String variable = matcher.group(1);
            String replacement = VariablesUtils.manageVariableReplacement(variable, variablesProperties, true);
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(buffer);
        String replaced = buffer.toString();
        if (!parseOther && !replaced.equals(input)) {
            return VariablesUtils.replaceSubVariables(replaced, variablesProperties);
        }
        return replaced;
    }

    private static String manageVariableReplacement(String variable, VariablesProperties variablesProperties, boolean smallVariable) {
        ArrayList<CommonVariable> storedVariables = variablesProperties.getSavedVariables();
        for (CommonVariable storedVariable : storedVariables) {
            if (storedVariable.getValue() == null || !variable.equals(storedVariable.getVariable().replace("%", ""))) continue;
            return storedVariable.getValue();
        }
        if (variable.equals("player")) {
            return variablesProperties.getPlayer().getName();
        }
        if (variablesProperties.isPlaceholderAPI()) {
            String variableBefore = variable;
            variable = PlaceholderAPI.setPlaceholders((Player)variablesProperties.getPlayer(), (String)("%" + variable + "%"));
            if (!("%" + variableBefore + "%").equals(variable)) {
                return variable;
            }
            variable = variableBefore;
        }
        if (smallVariable) {
            return "{" + variable + "}";
        }
        return "%" + variable + "%";
    }
}

