/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mc.ajneb97.MineChess;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.internal.CommonVariable;
import mc.ajneb97.model.items.CommonItem;
import mc.ajneb97.model.items.CommonItemBannerData;
import mc.ajneb97.model.items.CommonItemBookData;
import mc.ajneb97.model.items.CommonItemCustomModelComponentData;
import mc.ajneb97.model.items.CommonItemFireworkData;
import mc.ajneb97.model.items.CommonItemPotionData;
import mc.ajneb97.model.items.CommonItemSkullData;
import mc.ajneb97.model.items.CommonItemTrimData;
import mc.ajneb97.utils.ItemUtils;
import mc.ajneb97.utils.OtherUtils;
import mc.ajneb97.utils.ServerVersion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class CommonItemManager {
    private MineChess plugin;

    public CommonItemManager(MineChess plugin) {
        this.plugin = plugin;
    }

    public CommonItem createCommonItemFromItemStack(ItemStack item) {
        List<String> nbtList;
        CommonItem commonItem = new CommonItem(item.getType().name());
        commonItem.setAmount(item.getAmount());
        if (item.getDurability() != 0) {
            commonItem.setDurability(item.getDurability());
        }
        ServerVersion serverVersion = MineChess.serverVersion;
        boolean isPaper = this.plugin.getDependencyManager().isPaper();
        if (item.hasItemMeta()) {
            LeatherArmorMeta meta2;
            NamespacedKey key;
            Set flags;
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                if (isPaper && serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_19_R1)) {
                    commonItem.setName(LegacyComponentSerializer.legacyAmpersand().serialize(meta.displayName()));
                } else {
                    commonItem.setName(meta.getDisplayName().replace("\u00a7", "&"));
                }
            }
            if (meta.hasLore()) {
                ArrayList<String> lore = new ArrayList<String>();
                if (isPaper && serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_19_R1)) {
                    for (Component component : meta.lore()) {
                        lore.add(LegacyComponentSerializer.legacyAmpersand().serialize(component));
                    }
                } else {
                    for (String string : meta.getLore()) {
                        lore.add(string.replace("\u00a7", "&"));
                    }
                }
                commonItem.setLore(lore);
            }
            if (meta.hasEnchants()) {
                ArrayList<String> enchants = new ArrayList<String>();
                for (Map.Entry entry : meta.getEnchants().entrySet()) {
                    String enchant = ((Enchantment)entry.getKey()).getName();
                    int level = (Integer)entry.getValue();
                    enchants.add(enchant + ";" + level);
                }
                commonItem.setEnchants(enchants);
            }
            if ((flags = meta.getItemFlags()) != null && !flags.isEmpty()) {
                ArrayList<String> flagsList = new ArrayList<String>();
                for (ItemFlag flag : flags) {
                    flagsList.add(flag.name());
                }
                commonItem.setFlags(flagsList);
            }
            if (OtherUtils.isNew() && meta.hasCustomModelData() && !serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3)) {
                commonItem.setCustomModelData(meta.getCustomModelData());
            }
            if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3) && meta.hasCustomModelData()) {
                CustomModelDataComponent customModelDataComponent = meta.getCustomModelDataComponent();
                List<String> list = customModelDataComponent.getFlags().stream().map(String::valueOf).collect(Collectors.toList());
                List<String> customModelDataComponentColorsList = customModelDataComponent.getColors().stream().map(color -> String.valueOf(color.asRGB())).collect(Collectors.toList());
                List<String> customModelDataComponentFloatsList = customModelDataComponent.getFloats().stream().map(String::valueOf).collect(Collectors.toList());
                ArrayList<String> customModelDataComponentStringsList = new ArrayList<String>(customModelDataComponent.getStrings());
                commonItem.setCustomModelComponentData(new CommonItemCustomModelComponentData(list, customModelDataComponentColorsList, customModelDataComponentFloatsList, customModelDataComponentStringsList));
            }
            if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_20_R4) && meta.isHideTooltip()) {
                commonItem.setHideTooltip(true);
            }
            if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R2) && meta.hasTooltipStyle()) {
                key = meta.getTooltipStyle();
                commonItem.setTooltipStyle(key.getNamespace() + ":" + key.getKey());
            }
            if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3) && meta.hasItemModel()) {
                key = meta.getItemModel();
                commonItem.setModel(key.getNamespace() + ":" + key.getKey());
            }
            if (meta instanceof LeatherArmorMeta) {
                meta2 = (LeatherArmorMeta)meta;
                commonItem.setColor(meta2.getColor().asRGB());
            }
            if (meta instanceof EnchantmentStorageMeta) {
                meta2 = (EnchantmentStorageMeta)meta;
                Map map = meta2.getStoredEnchants();
                ArrayList<String> enchantsList = new ArrayList<String>();
                for (Map.Entry entry : map.entrySet()) {
                    enchantsList.add(((Enchantment)entry.getKey()).getName() + ";" + (Integer)entry.getValue());
                }
                if (!enchantsList.isEmpty()) {
                    commonItem.setBookEnchants(enchantsList);
                }
            }
        }
        if (!(nbtList = ItemUtils.getNBT(this.plugin, item)).isEmpty()) {
            commonItem.setNbt(nbtList);
        }
        commonItem.setAttributes(ItemUtils.getAttributes(this.plugin, item));
        commonItem.setSkullData(ItemUtils.getSkullData(item));
        commonItem.setPotionData(ItemUtils.getPotionData(item));
        commonItem.setFireworkData(ItemUtils.getFireworkData(item));
        commonItem.setBannerData(ItemUtils.getBannerData(item));
        commonItem.setBookData(ItemUtils.getBookData(item));
        commonItem.setTrimData(ItemUtils.getArmorTrimData(item));
        return commonItem;
    }

    public ItemStack createItemFromCommonItem(CommonItem commonItem) {
        List<String> bookEnchants;
        String model;
        String tooltipStyle;
        String[] sep;
        List<String> enchants;
        CommonItemCustomModelComponentData kitItemCustomModelComponentData;
        ServerVersion serverVersion;
        int customModelData;
        List<String> lore;
        ItemStack item = ItemUtils.createItemFromID(commonItem.getId());
        item.setAmount(commonItem.getAmount());
        short durability = commonItem.getDurability();
        if (durability != 0) {
            item.setDurability(durability);
        }
        boolean useMiniMessage = this.plugin.getConfigsManager().getMainConfigManager().isUseMiniMessage();
        ItemMeta meta = item.getItemMeta();
        String name = commonItem.getName();
        if (name != null) {
            if (useMiniMessage) {
                meta.displayName(MiniMessage.miniMessage().deserialize((Object)name).decoration(TextDecoration.ITALIC, false));
            } else {
                meta.setDisplayName(MessagesManager.getLegacyColoredMessage(name));
            }
        }
        if ((lore = commonItem.getLore()) != null) {
            ArrayList<String> loreCopy = new ArrayList<String>(lore);
            if (useMiniMessage) {
                ArrayList<Component> loreComponent = new ArrayList<Component>();
                for (int i = 0; i < loreCopy.size(); ++i) {
                    loreComponent.add(MiniMessage.miniMessage().deserialize((Object)((String)loreCopy.get(i))).decoration(TextDecoration.ITALIC, false));
                }
                meta.lore(loreComponent);
            } else {
                for (int i = 0; i < loreCopy.size(); ++i) {
                    loreCopy.set(i, MessagesManager.getLegacyColoredMessage((String)loreCopy.get(i)));
                }
                meta.setLore(loreCopy);
            }
        }
        if ((customModelData = commonItem.getCustomModelData()) != 0) {
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        if ((serverVersion = MineChess.serverVersion).serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3) && (kitItemCustomModelComponentData = commonItem.getCustomModelComponentData()) != null) {
            CustomModelDataComponent customModelDataComponent = meta.getCustomModelDataComponent();
            List<String> cFloats = kitItemCustomModelComponentData.getFloats();
            List<String> cColors = kitItemCustomModelComponentData.getColors();
            List<String> cFlags = kitItemCustomModelComponentData.getFlags();
            List<String> cStrings = kitItemCustomModelComponentData.getStrings();
            customModelDataComponent.setFlags(cFlags.stream().map(Boolean::parseBoolean).collect(Collectors.toList()));
            customModelDataComponent.setFloats(cFloats.stream().map(Float::parseFloat).collect(Collectors.toList()));
            customModelDataComponent.setColors(cColors.stream().map(rgb -> Color.fromRGB((int)Integer.parseInt(rgb))).collect(Collectors.toList()));
            customModelDataComponent.setStrings(new ArrayList<String>(cStrings));
            meta.setCustomModelDataComponent(customModelDataComponent);
        }
        if ((enchants = commonItem.getEnchants()) != null) {
            for (int i = 0; i < enchants.size(); ++i) {
                sep = enchants.get(i).split(";");
                String enchantName = sep[0];
                int enchantLevel = Integer.valueOf(sep[1]);
                meta.addEnchant(Enchantment.getByName((String)enchantName), enchantLevel, true);
            }
        }
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_20_R4) && commonItem.isHideTooltip()) {
            meta.setHideTooltip(true);
        }
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R2) && (tooltipStyle = commonItem.getTooltipStyle()) != null) {
            sep = tooltipStyle.split(":");
            meta.setTooltipStyle(new NamespacedKey(sep[0], sep[1]));
        }
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3) && (model = commonItem.getModel()) != null) {
            sep = model.split(":");
            meta.setItemModel(new NamespacedKey(sep[0], sep[1]));
        }
        item.setItemMeta(meta);
        int color = commonItem.getColor();
        if (color != 0) {
            LeatherArmorMeta meta2 = (LeatherArmorMeta)item.getItemMeta();
            meta2.setColor(Color.fromRGB((int)color));
            item.setItemMeta((ItemMeta)meta2);
        }
        if ((bookEnchants = commonItem.getBookEnchants()) != null && !bookEnchants.isEmpty()) {
            EnchantmentStorageMeta meta2 = (EnchantmentStorageMeta)item.getItemMeta();
            for (int i = 0; i < bookEnchants.size(); ++i) {
                String[] sep2 = bookEnchants.get(i).split(";");
                String enchantName = sep2[0];
                int level = Integer.valueOf(sep2[1]);
                meta2.addStoredEnchant(Enchantment.getByName((String)enchantName), level, true);
            }
            item.setItemMeta((ItemMeta)meta2);
        }
        CommonItemSkullData skullData = commonItem.getSkullData();
        ItemUtils.setSkullData(item, skullData, null);
        CommonItemPotionData potionData = commonItem.getPotionData();
        ItemUtils.setPotionData(item, potionData);
        CommonItemFireworkData fireworkData = commonItem.getFireworkData();
        ItemUtils.setFireworkData(item, fireworkData);
        CommonItemBannerData bannerData = commonItem.getBannerData();
        ItemUtils.setBannerData(item, bannerData);
        CommonItemBookData bookData = commonItem.getBookData();
        ItemUtils.setBookData(item, bookData);
        CommonItemTrimData trimData = commonItem.getTrimData();
        ItemUtils.setArmorTrimData(item, trimData);
        List<String> attributes = commonItem.getAttributes();
        item = ItemUtils.setAttributes(this.plugin, item, attributes);
        meta = item.getItemMeta();
        List<String> flags = commonItem.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                if (flag.equals("HIDE_ATTRIBUTES") && this.plugin.getDependencyManager().isPaper() && serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R1)) {
                    ItemUtils.addDummyAttribute(meta, this.plugin);
                }
                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag)});
            }
        }
        item.setItemMeta(meta);
        if (!serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_20_R4)) {
            List<String> nbtList = commonItem.getNbt();
            item = ItemUtils.setNBT(this.plugin, item, nbtList);
        }
        return item;
    }

    public void saveCommonItemOnConfig(CommonItem item, FileConfiguration config, String path) {
        CommonItemTrimData trimData;
        CommonItemBookData bookData;
        CommonItemBannerData bannerData;
        CommonItemFireworkData fireworkData;
        CommonItemPotionData potionData;
        CommonItemSkullData skullData;
        CommonItemCustomModelComponentData customModelComponentData;
        config.set(path + ".id", (Object)item.getId());
        config.set(path + ".name", (Object)item.getName());
        config.set(path + ".amount", (Object)item.getAmount());
        if (item.getDurability() != 0) {
            config.set(path + ".durability", (Object)item.getDurability());
        }
        if (item.getLore() != null && !item.getLore().isEmpty()) {
            config.set(path + ".lore", item.getLore());
        }
        if (item.getEnchants() != null && !item.getEnchants().isEmpty()) {
            config.set(path + ".enchants", item.getEnchants());
        }
        if (item.getFlags() != null && !item.getFlags().isEmpty()) {
            config.set(path + ".item_flags", item.getFlags());
        }
        if (item.getCustomModelData() != 0) {
            config.set(path + ".custom_model_data", (Object)item.getCustomModelData());
        }
        if ((customModelComponentData = item.getCustomModelComponentData()) != null) {
            if (!customModelComponentData.getFlags().isEmpty()) {
                config.set(path + ".custom_model_component_data.flags", customModelComponentData.getFlags());
            }
            if (!customModelComponentData.getFloats().isEmpty()) {
                config.set(path + ".custom_model_component_data.floats", customModelComponentData.getFloats());
            }
            if (!customModelComponentData.getColors().isEmpty()) {
                config.set(path + ".custom_model_component_data.colors", customModelComponentData.getColors());
            }
            if (!customModelComponentData.getStrings().isEmpty()) {
                config.set(path + ".custom_model_component_data.strings", customModelComponentData.getStrings());
            }
        }
        if (item.isHideTooltip()) {
            config.set(path + ".hide_tooltip", (Object)true);
        }
        if (item.getTooltipStyle() != null) {
            config.set(path + ".tooltip_style", (Object)item.getTooltipStyle());
        }
        if (item.getModel() != null) {
            config.set(path + ".model", (Object)item.getModel());
        }
        if (item.getColor() != 0) {
            config.set(path + ".color", (Object)item.getColor());
        }
        if (item.getNbt() != null && !item.getNbt().isEmpty()) {
            config.set(path + ".nbt", item.getNbt());
        }
        if (item.getAttributes() != null && !item.getAttributes().isEmpty()) {
            config.set(path + ".attributes", item.getAttributes());
        }
        if (item.getBookEnchants() != null && !item.getBookEnchants().isEmpty()) {
            config.set(path + ".book_enchants", item.getBookEnchants());
        }
        if ((skullData = item.getSkullData()) != null) {
            config.set(path + ".skull_data.texture", (Object)skullData.getTexture());
            config.set(path + ".skull_data.id", (Object)skullData.getId());
            config.set(path + ".skull_data.owner", (Object)skullData.getOwner());
        }
        if ((potionData = item.getPotionData()) != null) {
            if (potionData.getPotionEffects() != null && !potionData.getPotionEffects().isEmpty()) {
                config.set(path + ".potion_data.effects", potionData.getPotionEffects());
            }
            config.set(path + ".potion_data.extended", (Object)potionData.isExtended());
            config.set(path + ".potion_data.upgraded", (Object)potionData.isUpgraded());
            config.set(path + ".potion_data.type", (Object)potionData.getPotionType());
            if (potionData.getPotionColor() != 0) {
                config.set(path + ".potion_data.color", (Object)potionData.getPotionColor());
            }
        }
        if ((fireworkData = item.getFireworkData()) != null) {
            if (fireworkData.getFireworkRocketEffects() != null && !fireworkData.getFireworkRocketEffects().isEmpty()) {
                config.set(path + ".firework_data.rocket_effects", fireworkData.getFireworkRocketEffects());
            }
            config.set(path + ".firework_data.star_effect", (Object)fireworkData.getFireworkStarEffect());
            if (fireworkData.getFireworkPower() != 0) {
                config.set(path + ".firework_data.power", (Object)fireworkData.getFireworkPower());
            }
        }
        if ((bannerData = item.getBannerData()) != null) {
            if (bannerData.getPatterns() != null && !bannerData.getPatterns().isEmpty()) {
                config.set(path + ".banner_data.patterns", bannerData.getPatterns());
            }
            config.set(path + ".banner_data.base_color", (Object)bannerData.getBaseColor());
        }
        if ((bookData = item.getBookData()) != null) {
            config.set(path + ".book_data.author", (Object)bookData.getAuthor());
            config.set(path + ".book_data.title", (Object)bookData.getTitle());
            config.set(path + ".book_data.pages", bookData.getPages());
            config.set(path + ".book_data.generation", (Object)bookData.getGeneration());
        }
        if ((trimData = item.getTrimData()) != null) {
            config.set(path + ".trim_data.pattern", (Object)trimData.getPattern());
            config.set(path + ".trim_data.material", (Object)trimData.getMaterial());
        }
    }

    public CommonItem getCommonItemFromConfig(FileConfiguration config, String path) {
        String id = config.getString(path + ".id");
        String name = config.contains(path + ".name") ? config.getString(path + ".name") : null;
        List lore = config.contains(path + ".lore") ? config.getStringList(path + ".lore") : null;
        int amount = config.contains(path + ".amount") ? config.getInt(path + ".amount") : 1;
        short durability = config.contains(path + ".durability") ? (short)config.getInt(path + ".durability") : (short)0;
        int customModelData = config.contains(path + ".custom_model_data") ? config.getInt(path + ".custom_model_data") : 0;
        int color = config.contains(path + ".color") ? config.getInt(path + ".color") : 0;
        List enchants = config.contains(path + ".enchants") ? config.getStringList(path + ".enchants") : null;
        List flags = config.contains(path + ".item_flags") ? config.getStringList(path + ".item_flags") : null;
        List bookEnchants = config.contains(path + ".book_enchants") ? config.getStringList(path + ".book_enchants") : null;
        List nbtList = config.contains(path + ".nbt") ? config.getStringList(path + ".nbt") : null;
        List attributes = config.contains(path + ".attributes") ? config.getStringList(path + ".attributes") : null;
        CommonItemCustomModelComponentData customModelComponentData = null;
        if (config.contains(path + ".custom_model_component_data")) {
            ArrayList<String> cFlags = new ArrayList();
            ArrayList<String> cFloats = new ArrayList();
            ArrayList<String> cColors = new ArrayList();
            ArrayList<String> cStrings = new ArrayList();
            if (config.contains(path + ".custom_model_component_data.flags")) {
                cFlags = config.getStringList(path + ".custom_model_component_data.flags");
            }
            if (config.contains(path + ".custom_model_component_data.floats")) {
                cFloats = config.getStringList(path + ".custom_model_component_data.floats");
            }
            if (config.contains(path + ".custom_model_component_data.colors")) {
                cColors = config.getStringList(path + ".custom_model_component_data.colors");
            }
            if (config.contains(path + ".custom_model_component_data.strings")) {
                cStrings = config.getStringList(path + ".custom_model_component_data.strings");
            }
            customModelComponentData = new CommonItemCustomModelComponentData(cFlags, cColors, cFloats, cStrings);
        }
        boolean hideTooltip = config.getBoolean(path + ".hide_tooltip");
        String tooltipStyle = config.contains(path + ".tooltip_style") ? config.getString(path + ".tooltip_style") : null;
        String model = config.contains(path + ".model") ? config.getString(path + ".model") : null;
        CommonItemSkullData skullData = null;
        if (config.contains(path + ".skull_data")) {
            String skullTexture = null;
            String skullId = null;
            String skullOwner = null;
            if (config.contains(path + ".skull_data.texture")) {
                skullTexture = config.getString(path + ".skull_data.texture");
            }
            if (config.contains(path + ".skull_data.id")) {
                skullId = config.getString(path + ".skull_data.id");
            }
            if (config.contains(path + ".skull_data.owner")) {
                skullOwner = config.getString(path + ".skull_data.owner");
            }
            skullData = new CommonItemSkullData(skullOwner, skullTexture, skullId);
        }
        CommonItemPotionData potionData = null;
        if (config.contains(path + ".potion_data")) {
            List potionEffects = null;
            boolean extended = false;
            boolean upgraded = false;
            String potionType = null;
            int potionColor = 0;
            if (config.contains(path + ".potion_data.effects")) {
                potionEffects = config.getStringList(path + ".potion_data.effects");
            }
            if (config.contains(path + ".potion_data.extended")) {
                extended = config.getBoolean(path + ".potion_data.extended");
            }
            if (config.contains(path + ".potion_data.upgraded")) {
                upgraded = config.getBoolean(path + ".potion_data.upgraded");
            }
            if (config.contains(path + ".potion_data.type")) {
                potionType = config.getString(path + ".potion_data.type");
            }
            if (config.contains(path + ".potion_data.color")) {
                potionColor = config.getInt(path + ".potion_data.color");
            }
            potionData = new CommonItemPotionData(upgraded, extended, potionType, potionColor, potionEffects);
        }
        CommonItemFireworkData fireworkData = null;
        if (config.contains(path + ".firework_data")) {
            List rocketEffects = null;
            String starEffect = null;
            int power = 0;
            if (config.contains(path + ".firework_data.rocket_effects")) {
                rocketEffects = config.getStringList(path + ".firework_data.rocket_effects");
            }
            if (config.contains(path + ".firework_data.star_effect")) {
                starEffect = config.getString(path + ".firework_data.star_effect");
            }
            if (config.contains(path + ".firework_data.power")) {
                power = config.getInt(path + ".firework_data.power");
            }
            fireworkData = new CommonItemFireworkData(rocketEffects, starEffect, power);
        }
        CommonItemBannerData bannerData = null;
        if (config.contains(path + ".banner_data")) {
            List patterns = null;
            String baseColor = null;
            if (config.contains(path + ".banner_data.patterns")) {
                patterns = config.getStringList(path + ".banner_data.patterns");
            }
            if (config.contains(path + ".banner_data.base_color")) {
                baseColor = config.getString(path + ".banner_data.base_color");
            }
            bannerData = new CommonItemBannerData(patterns, baseColor);
        }
        CommonItemBookData bookData = null;
        if (config.contains(path + ".book_data")) {
            List pages = config.getStringList(path + ".book_data.pages");
            String author = null;
            String generation = null;
            String title = null;
            if (config.contains(path + ".book_data.author")) {
                author = config.getString(path + ".book_data.author");
            }
            if (config.contains(path + ".book_data.generation")) {
                generation = config.getString(path + ".book_data.generation");
            }
            if (config.contains(path + ".book_data.title")) {
                title = config.getString(path + ".book_data.title");
            }
            bookData = new CommonItemBookData(pages, author, generation, title);
        }
        CommonItemTrimData trimData = null;
        if (config.contains(path + ".trim_data")) {
            String material = config.getString(path + ".trim_data.material");
            String pattern = config.getString(path + ".trim_data.pattern");
            trimData = new CommonItemTrimData(pattern, material);
        }
        CommonItem commonItem = new CommonItem(id);
        commonItem.setName(name);
        commonItem.setLore(lore);
        commonItem.setAmount(amount);
        commonItem.setDurability(durability);
        commonItem.setCustomModelData(customModelData);
        commonItem.setColor(color);
        commonItem.setEnchants(enchants);
        commonItem.setFlags(flags);
        commonItem.setBookEnchants(bookEnchants);
        commonItem.setNbt(nbtList);
        commonItem.setAttributes(attributes);
        commonItem.setSkullData(skullData);
        commonItem.setPotionData(potionData);
        commonItem.setFireworkData(fireworkData);
        commonItem.setBannerData(bannerData);
        commonItem.setBookData(bookData);
        commonItem.setTrimData(trimData);
        commonItem.setCustomModelComponentData(customModelComponentData);
        commonItem.setHideTooltip(hideTooltip);
        commonItem.setTooltipStyle(tooltipStyle);
        commonItem.setModel(model);
        return commonItem;
    }

    public void replaceVariables(ItemStack item, ArrayList<CommonVariable> variables, Player player) {
        boolean useMiniMessage = this.plugin.getConfigsManager().getMainConfigManager().isUseMiniMessage();
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                if (useMiniMessage) {
                    Component name = meta.displayName();
                    Object newName = name;
                    for (CommonVariable variable : variables) {
                        String finalValue = OtherUtils.replaceGlobalVariables(variable.getValue(), player, this.plugin);
                        newName = newName.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(variable.getVariable()).replacement((ComponentLike)MiniMessage.miniMessage().deserialize((Object)finalValue)).build());
                    }
                    meta.displayName((Component)newName);
                } else {
                    String newName = meta.getDisplayName();
                    for (CommonVariable variable : variables) {
                        newName = newName.replace(variable.getVariable(), variable.getValue());
                    }
                    newName = OtherUtils.replaceGlobalVariables(newName, player, this.plugin);
                    meta.setDisplayName(MessagesManager.getLegacyColoredMessage(newName));
                }
            }
            if (meta.hasLore()) {
                if (useMiniMessage) {
                    lore = meta.lore();
                    ArrayList<Component> newLore = new ArrayList<Component>();
                    Iterator<CommonVariable> iterator = lore.iterator();
                    while (iterator.hasNext()) {
                        Component c;
                        Component newComponent = c = (Component)iterator.next();
                        for (CommonVariable variable : variables) {
                            String finalValue = OtherUtils.replaceGlobalVariables(variable.getValue(), player, this.plugin);
                            newComponent = newComponent.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(variable.getVariable()).replacement((ComponentLike)MiniMessage.miniMessage().deserialize((Object)finalValue)).build());
                        }
                        newLore.add(newComponent);
                    }
                    meta.lore(newLore);
                } else {
                    lore = meta.getLore();
                    for (int i = 0; i < lore.size(); ++i) {
                        for (CommonVariable variable : variables) {
                            String line = ((String)lore.get(i)).replace(variable.getVariable(), variable.getValue());
                            line = OtherUtils.replaceGlobalVariables(line, player, this.plugin);
                            lore.set(i, MessagesManager.getLegacyColoredMessage(line));
                        }
                    }
                    meta.setLore(lore);
                }
            }
            item.setItemMeta(meta);
        }
    }
}

