/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager.editinventory;

import java.util.ArrayList;
import java.util.List;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.MainConfigManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.ArenaEndTimeMode;
import mc.ajneb97.model.editinventory.EditInventoryPlayer;
import mc.ajneb97.utils.InventoryItem;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EditArenaInventoryManager {
    private MineChess plugin;

    public EditArenaInventoryManager(MineChess plugin) {
        this.plugin = plugin;
    }

    public void openMainInventory(EditInventoryPlayer editInventoryPlayer) {
        int i;
        editInventoryPlayer.setCurrentInventory(EditInventoryPlayer.InventoryType.ARENA);
        Arena arena = editInventoryPlayer.getArena();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        Inventory inv = mainConfigManager.isUseMiniMessage() ? Bukkit.createInventory(null, (int)54, (Component)MiniMessage.miniMessage().deserialize((Object)messagesConfig.getString("inventoryEditingArenaTitle"))) : Bukkit.createInventory(null, (int)54, (String)MessagesManager.getLegacyColoredMessage(messagesConfig.getString("inventoryEditingArenaTitle")));
        ItemStack item = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        for (int i2 = 45; i2 < 54; ++i2) {
            inv.setItem(i2, item);
        }
        List lore = messagesConfig.getStringList("inventoryEditingArenaLocationLobbyItemLore");
        new InventoryItem(inv, 10, Material.COMPASS).name(messagesConfig.getString("inventoryEditingArenaLocationLobbyItemName")).lore(this.setLoreLocation(lore, messagesConfig, arena.getLobbyLocation())).ready();
        String colorWhite = messagesConfig.getString("pieceWhite");
        String colorBlack = messagesConfig.getString("pieceBlack");
        lore = messagesConfig.getStringList("inventoryEditingArenaLocationSpawnPlayerItemLore");
        for (i = 0; i < lore.size(); ++i) {
            lore.set(i, ((String)lore.get(i)).replace("%color%", colorWhite));
        }
        new InventoryItem(inv, 19, Material.COMPASS).name(messagesConfig.getString("inventoryEditingArenaLocationSpawnPlayerItemName").replace("%color%", colorWhite)).lore(this.setLoreLocation(lore, messagesConfig, arena.getSpawnPlayer1Location())).ready();
        lore = messagesConfig.getStringList("inventoryEditingArenaLocationSpawnPlayerItemLore");
        for (i = 0; i < lore.size(); ++i) {
            lore.set(i, ((String)lore.get(i)).replace("%color%", colorBlack));
        }
        new InventoryItem(inv, 28, Material.COMPASS).name(messagesConfig.getString("inventoryEditingArenaLocationSpawnPlayerItemName").replace("%color%", colorBlack)).lore(this.setLoreLocation(lore, messagesConfig, arena.getSpawnPlayer2Location())).ready();
        new InventoryItem(inv, 37, Material.REDSTONE_BLOCK).name(messagesConfig.getString("inventoryEditingArenaLocationResetItemName")).lore(messagesConfig.getStringList("inventoryEditingArenaLocationResetItemLore")).ready();
        lore = messagesConfig.getStringList("inventoryEditingArenaGameModeItemLore");
        this.replaceValueVariable(lore, "ARENA_TIME");
        new InventoryItem(inv, 12, Material.REPEATER).name(messagesConfig.getString("inventoryEditingArenaGameModeItemName")).lore(lore).ready();
        lore = messagesConfig.getStringList("inventoryEditingArenaPiecesTypeItemLore");
        this.replaceValueVariable(lore, "BLOCK");
        new InventoryItem(inv, 30, Material.QUARTZ_BLOCK).name(messagesConfig.getString("inventoryEditingArenaPiecesTypeItemName")).lore(lore).ready();
        lore = messagesConfig.getStringList("inventoryEditingMaxTimeArenaTimeItemLore");
        this.replaceValueVariable(lore, "" + arena.getMaxTime());
        new InventoryItem(inv, 23, Material.CLOCK).name(messagesConfig.getString("inventoryEditingMaxTimeArenaTimeItemName")).lore(lore).ready();
        lore = messagesConfig.getStringList("inventoryEditingTurnTimeItemLore");
        this.replaceValueVariable(lore, "" + arena.getTurnTime());
        new InventoryItem(inv, 24, Material.CLOCK).name(messagesConfig.getString("inventoryEditingTurnTimeItemName")).lore(lore).ready();
        lore = messagesConfig.getStringList("inventoryEditingEndModeItemLore");
        this.replaceValueVariable(lore, arena.getEndTimeMode().name());
        new InventoryItem(inv, 25, Material.DISPENSER).name(messagesConfig.getString("inventoryEditingEndModeItemName")).lore(lore).ready();
        editInventoryPlayer.getPlayer().openInventory(inv);
        this.plugin.getEditInventoryManager().getPlayers().add(editInventoryPlayer);
    }

    private void replaceValueVariable(List<String> lore, String value) {
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, lore.get(i).replace("%value%", value));
        }
    }

    private List<String> setLoreLocation(List<String> lore, FileConfiguration messages, Location location) {
        ArrayList<String> finalLore = new ArrayList<String>();
        for (String line : lore) {
            if (line.equals("%location%")) {
                List locationLore = messages.getStringList("inventoryEditingArenaCommonLocationItemLore");
                for (int i = 0; i < locationLore.size(); ++i) {
                    locationLore.set(i, ((String)locationLore.get(i)).replace("%world%", location.getWorld().getName()).replace("%x%", "" + location.getX()).replace("%y%", "" + location.getBlockY()).replace("%z%", "" + location.getBlockZ()).replace("%pitch%", "" + location.getPitch()).replace("%yaw%", "" + location.getYaw()));
                }
                finalLore.addAll(locationLore);
                continue;
            }
            finalLore.add(line);
        }
        return finalLore;
    }

    private void clickItemLocation(EditInventoryPlayer editInventoryPlayer, ClickType clickType, String type) {
        Arena arena = editInventoryPlayer.getArena();
        Location location = editInventoryPlayer.getPlayer().getLocation();
        if (type.equals("lobby")) {
            arena.setLobbyLocation(location.clone());
        } else if (type.equals("spawn_1")) {
            arena.setSpawnPlayer1Location(location.clone());
        } else {
            arena.setSpawnPlayer2Location(location.clone());
        }
        FileConfiguration messages = this.plugin.getMessagesConfig();
        this.plugin.getMessagesManager().sendMessage((CommandSender)editInventoryPlayer.getPlayer(), messages.getString("inventoryEditingArenaCommonLocationSet"), true);
        this.plugin.getConfigsManager().getArenasConfigManager().saveArena(arena);
        this.openMainInventory(editInventoryPlayer);
    }

    private void clickItemResetLocations(EditInventoryPlayer editInventoryPlayer) {
        Arena arena = editInventoryPlayer.getArena();
        Location boardStartLocation = arena.getBoardStartLocation();
        arena.configureLocations(boardStartLocation, 3);
        FileConfiguration messages = this.plugin.getMessagesConfig();
        this.plugin.getMessagesManager().sendMessage((CommandSender)editInventoryPlayer.getPlayer(), messages.getString("inventoryEditingArenaLocationsReset"), true);
        this.plugin.getConfigsManager().getArenasConfigManager().saveArena(arena);
        this.openMainInventory(editInventoryPlayer);
    }

    private void clickItemEndMode(EditInventoryPlayer editInventoryPlayer, ClickType clickType) {
        Arena arena = editInventoryPlayer.getArena();
        if (arena.getEndTimeMode().equals((Object)ArenaEndTimeMode.CHECK_POINTS)) {
            arena.setEndTimeMode(ArenaEndTimeMode.ALWAYS_TIE);
        } else {
            arena.setEndTimeMode(ArenaEndTimeMode.CHECK_POINTS);
        }
        FileConfiguration messages = this.plugin.getMessagesConfig();
        this.plugin.getMessagesManager().sendMessage((CommandSender)editInventoryPlayer.getPlayer(), messages.getString("inventoryEditingEndModeChanged"), true);
        this.plugin.getConfigsManager().getArenasConfigManager().saveArena(arena);
        this.openMainInventory(editInventoryPlayer);
    }

    private void clickItemTime(EditInventoryPlayer editInventoryPlayer, ClickType clickType, String type) {
        int value = 0;
        if (clickType.equals((Object)ClickType.SHIFT_LEFT)) {
            value = type.equals("turn_time") ? 10 : 60;
        } else if (clickType.equals((Object)ClickType.SHIFT_RIGHT)) {
            value = type.equals("turn_time") ? -10 : -60;
        } else if (clickType.equals((Object)ClickType.LEFT)) {
            value = type.equals("turn_time") ? 5 : 10;
        } else if (clickType.equals((Object)ClickType.RIGHT)) {
            value = type.equals("turn_time") ? -5 : -10;
        }
        Arena arena = editInventoryPlayer.getArena();
        int currentValue = type.equals("turn_time") ? arena.getTurnTime() : arena.getMaxTime();
        int newValue = currentValue + value;
        if (newValue < 0) {
            return;
        }
        if (type.equals("turn_time")) {
            arena.setTurnTime(newValue);
        } else {
            arena.setMaxTime(newValue);
        }
        this.plugin.getConfigsManager().getArenasConfigManager().saveArena(arena);
        this.openMainInventory(editInventoryPlayer);
    }

    public void onInventoryClick(EditInventoryPlayer editInventoryPlayer, int slot, ItemStack item, ClickType clickType) {
        switch (slot) {
            case 10: {
                this.clickItemLocation(editInventoryPlayer, clickType, "lobby");
                break;
            }
            case 19: {
                this.clickItemLocation(editInventoryPlayer, clickType, "spawn_1");
                break;
            }
            case 28: {
                this.clickItemLocation(editInventoryPlayer, clickType, "spawn_2");
                break;
            }
            case 37: {
                this.clickItemResetLocations(editInventoryPlayer);
                break;
            }
            case 25: {
                this.clickItemEndMode(editInventoryPlayer, clickType);
                break;
            }
            case 23: {
                this.clickItemTime(editInventoryPlayer, clickType, "max_time");
                break;
            }
            case 24: {
                this.clickItemTime(editInventoryPlayer, clickType, "turn_time");
            }
        }
    }
}

