/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager.inventory;

import java.util.ArrayList;
import java.util.List;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.MainConfigManager;
import mc.ajneb97.manager.CommonItemManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.manager.inventory.CustomItemsInventory;
import mc.ajneb97.manager.inventory.InventoryType;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.PlayerColor;
import mc.ajneb97.model.chess.PieceType;
import mc.ajneb97.model.game.GamePlayer;
import mc.ajneb97.model.internal.CommonVariable;
import mc.ajneb97.model.inventory.CommonInventory;
import mc.ajneb97.model.inventory.CommonInventoryItem;
import mc.ajneb97.model.inventory.InventoryPlayer;
import mc.ajneb97.model.items.CommonItem;
import mc.ajneb97.utils.ActionUtils;
import mc.ajneb97.utils.ItemUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryManager {
    private MineChess plugin;
    private ArrayList<CommonInventory> inventories;
    private CustomItemsInventory customItems;
    private ArrayList<InventoryPlayer> players;

    public InventoryManager(MineChess plugin) {
        this.plugin = plugin;
        this.inventories = new ArrayList();
        this.players = new ArrayList();
    }

    public ArrayList<CommonInventory> getInventories() {
        return this.inventories;
    }

    public void setInventories(ArrayList<CommonInventory> inventories) {
        this.inventories = inventories;
    }

    public CustomItemsInventory getCustomItems() {
        return this.customItems;
    }

    public void setCustomItems(CustomItemsInventory customItems) {
        this.customItems = customItems;
    }

    public ArrayList<InventoryPlayer> getPlayers() {
        return this.players;
    }

    public CommonInventory getInventory(InventoryType inventoryType) {
        for (CommonInventory inventory : this.inventories) {
            if (!inventory.getName().equals(inventoryType.name().toLowerCase())) continue;
            return inventory;
        }
        return null;
    }

    public InventoryPlayer getInventoryPlayer(Player player) {
        for (InventoryPlayer inventoryPlayer : this.players) {
            if (!inventoryPlayer.getPlayer().equals((Object)player)) continue;
            return inventoryPlayer;
        }
        return null;
    }

    public void removeInventoryPlayer(Player player) {
        this.players.removeIf(p -> p.getPlayer().equals((Object)player));
    }

    public void openInventory(InventoryPlayer inventoryPlayer) {
        CommonInventory inventory = this.getInventory(inventoryPlayer.getInventoryType());
        String title = inventory.getTitle();
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        Inventory inv = mainConfigManager.isUseMiniMessage() ? Bukkit.createInventory(null, (int)inventory.getSlots(), (Component)MiniMessage.miniMessage().deserialize((Object)title)) : Bukkit.createInventory(null, (int)inventory.getSlots(), (String)MessagesManager.getLegacyColoredMessage(title));
        List<CommonInventoryItem> items = inventory.getItems();
        CommonItemManager commonItemManager = this.plugin.getCommonItemManager();
        for (CommonInventoryItem itemInventory : items) {
            List<Integer> slots = itemInventory.getSlots();
            String type = itemInventory.getType();
            for (int slot : slots) {
                ItemStack item;
                if (type != null && type.startsWith("piece: ")) {
                    item = this.setPiece(type.replace("piece: ", ""), inventoryPlayer);
                    item = this.setItemActions(itemInventory, item);
                    inv.setItem(slot, item);
                    continue;
                }
                item = commonItemManager.createItemFromCommonItem(itemInventory.getItem());
                String openInventory = itemInventory.getOpenInventory();
                if (openInventory != null) {
                    item = ItemUtils.setTagStringItem(this.plugin, item, "minechess_open_inventory", openInventory);
                }
                if (type != null) {
                    item = ItemUtils.setTagStringItem(this.plugin, item, "minechess_item_type", type);
                }
                item = this.setItemActions(itemInventory, item);
                inv.setItem(slot, item);
            }
        }
        inventoryPlayer.getPlayer().openInventory(inv);
        this.players.add(inventoryPlayer);
    }

    private ItemStack setItemActions(CommonInventoryItem commonItem, ItemStack item) {
        List<String> clickActions = commonItem.getClickActions();
        if (clickActions != null && !clickActions.isEmpty()) {
            Object actionsList = "";
            for (int i = 0; i < clickActions.size(); ++i) {
                actionsList = i == clickActions.size() - 1 ? (String)actionsList + clickActions.get(i) : (String)actionsList + clickActions.get(i) + "|";
            }
            item = ItemUtils.setTagStringItem(this.plugin, item, "minechess_item_actions", (String)actionsList);
        }
        return item;
    }

    private void clickActionsItem(InventoryPlayer inventoryPlayer, String itemCommands) {
        String[] sep;
        for (String action : sep = itemCommands.split("\\|")) {
            ActionUtils.executeAction(inventoryPlayer.getPlayer(), action, this.plugin, new ArrayList<CommonVariable>());
        }
    }

    public void clickInventory(InventoryPlayer inventoryPlayer, ItemStack item, ClickType clickType) {
        String itemActions = ItemUtils.getTagStringItem(this.plugin, item, "minechess_item_actions");
        if (itemActions != null) {
            this.clickActionsItem(inventoryPlayer, itemActions);
        }
        if (inventoryPlayer.getInventoryType().equals((Object)InventoryType.PROMOTION)) {
            this.clickInventoryPromotion(inventoryPlayer, item, clickType);
        }
    }

    public void clickInventoryPromotion(InventoryPlayer inventoryPlayer, ItemStack item, ClickType clickType) {
        Arena arena;
        GamePlayer gamePlayer;
        String pieceName = ItemUtils.getTagStringItem(this.plugin, item, "minechess_piece");
        if (pieceName != null && (gamePlayer = (arena = this.plugin.getArenaManager().getGamePlayerManager().getArenaByPlayer(inventoryPlayer.getPlayer())).getGamePlayer(inventoryPlayer.getPlayer())).isOnPromotion()) {
            this.plugin.getArenaManager().getGamePieceInteractionManager().promotePawn(arena, gamePlayer, PieceType.valueOf(pieceName));
        }
    }

    public ItemStack setPiece(String pieceName, InventoryPlayer inventoryPlayer) {
        Arena arena = this.plugin.getArenaManager().getGamePlayerManager().getArenaByPlayer(inventoryPlayer.getPlayer());
        PlayerColor color = arena.getColor(arena.getGamePlayer(inventoryPlayer.getPlayer()));
        CommonItem pieceItem = null;
        switch (pieceName) {
            case "rook": {
                if (color.equals((Object)PlayerColor.WHITE)) {
                    pieceItem = this.customItems.getPieceRookBlack();
                    break;
                }
                pieceItem = this.customItems.getPieceRookWhite();
                break;
            }
            case "bishop": {
                if (color.equals((Object)PlayerColor.WHITE)) {
                    pieceItem = this.customItems.getPieceBishopBlack();
                    break;
                }
                pieceItem = this.customItems.getPieceBishopWhite();
                break;
            }
            case "knight": {
                if (color.equals((Object)PlayerColor.WHITE)) {
                    pieceItem = this.customItems.getPieceKnightBlack();
                    break;
                }
                pieceItem = this.customItems.getPieceKnightWhite();
                break;
            }
            case "queen": {
                if (color.equals((Object)PlayerColor.WHITE)) {
                    pieceItem = this.customItems.getPieceQueenBlack();
                    break;
                }
                pieceItem = this.customItems.getPieceQueenWhite();
                break;
            }
            default: {
                return null;
            }
        }
        ItemStack item = this.plugin.getCommonItemManager().createItemFromCommonItem(pieceItem);
        item = ItemUtils.setTagStringItem(this.plugin, item, "minechess_piece", pieceName.toUpperCase());
        return item;
    }
}

