/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.utils;

import java.util.ArrayList;
import java.util.List;
import mc.ajneb97.api.MineChessAPI;
import mc.ajneb97.manager.MessagesManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryItem {
    private Inventory inventory;
    private int slot;
    private ItemStack item;
    private ItemMeta meta;
    private boolean useMiniMessage;

    public InventoryItem(Inventory inventory, int slot, Material material) {
        this.inventory = inventory;
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
        this.slot = slot;
        this.useMiniMessage = MineChessAPI.getPlugin().getConfigsManager().getMainConfigManager().isUseMiniMessage();
    }

    public InventoryItem dataValue(short datavalue) {
        this.item.setDurability(datavalue);
        return this;
    }

    public InventoryItem amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public InventoryItem name(String name) {
        if (this.useMiniMessage) {
            this.meta.displayName(MiniMessage.miniMessage().deserialize((Object)name).decoration(TextDecoration.ITALIC, false));
        } else {
            this.meta.setDisplayName(MessagesManager.getLegacyColoredMessage(name));
        }
        return this;
    }

    public InventoryItem lore(List<String> lore) {
        ArrayList<String> loreCopy = new ArrayList<String>(lore);
        if (this.useMiniMessage) {
            ArrayList<Component> loreComponent = new ArrayList<Component>();
            for (int i = 0; i < loreCopy.size(); ++i) {
                loreComponent.add(MiniMessage.miniMessage().deserialize((Object)((String)loreCopy.get(i))).decoration(TextDecoration.ITALIC, false));
            }
            this.meta.lore(loreComponent);
        } else {
            for (int i = 0; i < loreCopy.size(); ++i) {
                loreCopy.set(i, MessagesManager.getLegacyColoredMessage((String)loreCopy.get(i)));
            }
            this.meta.setLore(loreCopy);
        }
        return this;
    }

    public InventoryItem enchanted(boolean enchanted) {
        if (enchanted) {
            this.meta.addEnchant(Enchantment.FIRE_ASPECT, 1, true);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        return this;
    }

    public void ready() {
        this.item.setItemMeta(this.meta);
        this.inventory.setItem(this.slot, this.item);
    }
}

