/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.model.CommonConfig;
import mc.ajneb97.manager.MessagesManager;
import org.bukkit.configuration.file.FileConfiguration;

public class MessagesConfigManager {
    private MineChess plugin;
    private CommonConfig configFile;

    public MessagesConfigManager(MineChess plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("messages.yml", plugin, null, false);
        this.configFile.registerConfig();
        this.checkUpdates();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        MessagesManager messagesManager = new MessagesManager();
        messagesManager.setPrefix(config.getString("prefix"));
        messagesManager.setTimeSeconds(config.getString("seconds"));
        messagesManager.setTimeMinutes(config.getString("minutes"));
        messagesManager.setTimeHours(config.getString("hours"));
        messagesManager.setTimeDays(config.getString("days"));
        this.plugin.setMessagesManager(messagesManager);
    }

    public CommonConfig getConfigFile() {
        return this.configFile;
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    public void checkUpdates() {
        Path pathConfig = Paths.get(this.configFile.getRoute(), new String[0]);
        try {
            String text = new String(Files.readAllBytes(pathConfig));
            FileConfiguration config = this.configFile.getConfig();
            if (!text.contains("playerSpectateNotPlaying:")) {
                config.set("playerSpectateNotPlaying", (Object)"&cThat player is not playing.");
                this.configFile.saveConfig();
            }
            if (!text.contains("inventoryEditingArenaLocationResetItemName:")) {
                config.set("inventoryEditingArenaLocationResetItemName", (Object)"&4&lReset Arena Locations");
                ArrayList<String> list = new ArrayList<String>();
                list.add("&7This will reset the locations of player");
                list.add("&7spawns and arena lobby to the default values.");
                list.add("");
                list.add("&a&lCLICK &ato reset");
                config.set("inventoryEditingArenaLocationResetItemLore", list);
                config.set("inventoryEditingArenaLocationsReset", (Object)"&aLocations reset.");
                this.configFile.saveConfig();
            }
            if (!text.contains("commandJoinComputerError:")) {
                config.set("commandJoinComputerError", (Object)"&cYou must use &7/minechess joincomputer <difficulty>");
                config.set("noValidDifficulty", (Object)"&cThat's not a valid difficulty.");
                config.set("computerGameJoin", (Object)"&eYou have joined a player vs computer game.");
                config.set("computerGameLeave", (Object)"&eYou have left the game.");
                config.set("computerGameCanNotJoin", (Object)"&cA player is currently playing against a computer on that arena.");
                config.set("computerDisplayName", (Object)"Computer");
                this.configFile.saveConfig();
            }
            if (!text.contains("noAvailableArenas:")) {
                config.set("noAvailableArenas", (Object)"&cThere are no available arenas at the moment.");
                this.configFile.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }
}

