/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.DataFolderConfigManager;
import mc.ajneb97.config.model.CommonConfig;
import mc.ajneb97.model.data.PlayerData;
import mc.ajneb97.model.data.PlayerDataBackup;
import org.bukkit.GameMode;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class PlayersConfigManager
extends DataFolderConfigManager {
    public PlayersConfigManager(MineChess plugin, String folderName) {
        super(plugin, folderName);
    }

    @Override
    public void createFiles() {
    }

    @Override
    public void loadConfigs() {
        HashMap<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();
        HashMap<UUID, PlayerDataBackup> playersBackup = new HashMap<UUID, PlayerDataBackup>();
        ArrayList<CommonConfig> configFiles = this.getConfigs();
        for (CommonConfig commonConfig : configFiles) {
            FileConfiguration config = commonConfig.getConfig();
            String uuidString = commonConfig.getPath().replace(".yml", "");
            String name = config.getString("name");
            int wins = config.getInt("wins");
            int loses = config.getInt("loses");
            int ties = config.getInt("ties");
            long millisPlayed = config.getLong("millis_played");
            PlayerDataBackup backup = null;
            if (config.contains("backup")) {
                GameMode gamemode = GameMode.valueOf((String)config.getString("backup.gamemode"));
                float xp = (float)config.getDouble("backup.xp");
                int level = config.getInt("backup.level");
                int food = config.getInt("backup.food");
                double health = config.getDouble("backup.health");
                double maxHealth = config.getDouble("backup.max_health");
                boolean allowFlight = config.getBoolean("backup.allow_flight");
                boolean isFlying = config.getBoolean("backup.is_flying");
                ItemStack[] inventory = new ItemStack[41];
                if (config.contains("backup.inventory")) {
                    for (String key : config.getConfigurationSection("backup.inventory").getKeys(false)) {
                        inventory[Integer.parseInt((String)key)] = config.getItemStack("backup.inventory." + key);
                    }
                }
                backup = new PlayerDataBackup(inventory, gamemode, xp, level, food, health, maxHealth, allowFlight, isFlying);
            }
            UUID uuid = UUID.fromString(uuidString);
            PlayerData playerData = new PlayerData(uuid, name);
            playerData.setWins(wins);
            playerData.setLoses(loses);
            playerData.setTies(ties);
            playerData.setMillisPlayed(millisPlayed);
            if (backup != null) {
                playersBackup.put(uuid, backup);
            }
            players.put(uuid, playerData);
        }
        this.plugin.getPlayerDataManager().setPlayers(players);
        this.plugin.getPlayerDataManager().getPlayerDataBackupManager().setPlayers(playersBackup);
    }

    public void saveConfig(PlayerData playerData) {
        String playerName = playerData.getName();
        CommonConfig playerConfig = this.getConfigFile(String.valueOf(playerData.getUuid()) + ".yml");
        FileConfiguration config = playerConfig.getConfig();
        config.set("name", (Object)playerName);
        config.set("wins", (Object)playerData.getWins());
        config.set("loses", (Object)playerData.getLoses());
        config.set("ties", (Object)playerData.getTies());
        config.set("millis_played", (Object)playerData.getMillisPlayed());
        playerConfig.saveConfig();
    }

    public void saveBackupConfig(String uuid, PlayerDataBackup playerDataBackup) {
        CommonConfig playerConfig = this.getConfigFile(uuid + ".yml");
        FileConfiguration config = playerConfig.getConfig();
        config.set("backup", null);
        if (playerDataBackup != null) {
            config.set("backup.gamemode", (Object)playerDataBackup.getGamemode().name());
            config.set("backup.xp", (Object)Float.valueOf(playerDataBackup.getXp()));
            config.set("backup.level", (Object)playerDataBackup.getLevel());
            config.set("backup.food", (Object)playerDataBackup.getFood());
            config.set("backup.health", (Object)playerDataBackup.getHealth());
            config.set("backup.max_health", (Object)playerDataBackup.getMaxHealth());
            config.set("backup.allow_flight", (Object)playerDataBackup.isAllowFlight());
            config.set("backup.is_flying", (Object)playerDataBackup.isFlying());
            ItemStack[] items = playerDataBackup.getInventory();
            for (int i = 0; i < items.length; ++i) {
                config.set("backup.inventory." + i, (Object)items[i]);
            }
        }
        playerConfig.saveConfig();
    }

    @Override
    public void saveConfigs() {
        Map<UUID, PlayerData> players = this.plugin.getPlayerDataManager().getPlayers();
        boolean isMySQL = this.plugin.getConfigsManager().getMainConfigManager().isMySQL();
        if (!isMySQL) {
            for (Map.Entry<UUID, PlayerData> entry : players.entrySet()) {
                PlayerData playerData = entry.getValue();
                if (playerData.isModified()) {
                    this.saveConfig(playerData);
                }
                playerData.setModified(false);
            }
        }
    }
}

