/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import mc.ajneb97.MineChess;
import mc.ajneb97.api.ArenaStartEvent;
import mc.ajneb97.config.MainConfigManager;
import mc.ajneb97.config.model.gameitems.GameItemConfig;
import mc.ajneb97.config.model.gameitems.GameItemsConfig;
import mc.ajneb97.manager.BoardManager;
import mc.ajneb97.manager.CommonItemManager;
import mc.ajneb97.manager.GameEndManager;
import mc.ajneb97.manager.GameItemManager;
import mc.ajneb97.manager.GamePlayerManager;
import mc.ajneb97.manager.GameSpectatorManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.manager.interactions.GamePieceInteractionManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.chess.PieceType;
import mc.ajneb97.model.game.GameEndsReason;
import mc.ajneb97.model.game.GameLeaveReason;
import mc.ajneb97.model.game.GamePlayer;
import mc.ajneb97.model.game.GameStatus;
import mc.ajneb97.model.internal.CommonVariable;
import mc.ajneb97.model.internal.CoordinateMovement;
import mc.ajneb97.utils.ActionUtils;
import mc.ajneb97.utils.GameUtils;
import mc.ajneb97.utils.ItemUtils;
import mc.ajneb97.utils.PlayerUtils;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArenaManager {
    private MineChess plugin;
    private ArrayList<Arena> arenas;
    private Location mainLobbyLocation;
    private GamePlayerManager gamePlayerManager;
    private GameItemManager gameItemManager;
    private GamePieceInteractionManager gamePieceInteractionManager;
    private GameEndManager gameEndManager;
    private GameSpectatorManager gameSpectatorManager;

    public ArenaManager(MineChess plugin) {
        this.plugin = plugin;
        this.arenas = new ArrayList();
        this.gamePlayerManager = new GamePlayerManager(plugin);
        this.gameItemManager = new GameItemManager(plugin);
        this.gamePieceInteractionManager = new GamePieceInteractionManager(plugin);
        this.gameEndManager = new GameEndManager(plugin);
        this.gameSpectatorManager = new GameSpectatorManager(plugin);
    }

    public Arena getArenaByName(String name) {
        for (Arena arena : this.arenas) {
            if (!arena.getName().equals(name)) continue;
            return arena;
        }
        return null;
    }

    public ArrayList<Arena> getArenas() {
        return this.arenas;
    }

    public void setArenas(ArrayList<Arena> arenas) {
        this.arenas = arenas;
    }

    public Location getMainLobbyLocation() {
        return this.mainLobbyLocation;
    }

    public void setMainLobbyLocation(Location mainLobbyLocation) {
        this.mainLobbyLocation = mainLobbyLocation;
    }

    public String arenaIsValid(Arena arena, FileConfiguration messagesConfig) {
        if (this.mainLobbyLocation == null) {
            return messagesConfig.getString("arenaMainLobbyError");
        }
        if (arena.locationsAreMissing()) {
            return messagesConfig.getString("arenaLocationsMissing");
        }
        return null;
    }

    public void addArena(String name) {
        Arena arena = new Arena(name);
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        arena.setDefaults(mainConfigManager.getArenaDefaultValues());
        this.arenas.add(arena);
        this.plugin.getConfigsManager().getArenasConfigManager().saveArena(arena);
        this.plugin.getVerifyManager().verify();
    }

    public void removeArena(String name) {
        BoardManager boardManager = this.plugin.getBoardManager();
        for (int i = 0; i < this.arenas.size(); ++i) {
            if (!this.arenas.get(i).getName().equals(name)) continue;
            this.arenas.get(i).stopCooldownTask();
            boardManager.removeBoardFloor(this.arenas.get(i));
            this.arenas.remove(i);
            this.plugin.getConfigsManager().getArenasConfigManager().deleteArena(name);
            this.plugin.getVerifyManager().verify();
            return;
        }
    }

    public void joinArena(Player player, Arena arena) {
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        if (this.plugin.getVerifyManager().isCriticalErrors()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("pluginCriticalErrors"), true);
            return;
        }
        if (arena.isDisabled()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaIsDisabled"), true);
            return;
        }
        if (arena.isInGame()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaIsInGame"), true);
            return;
        }
        if (arena.isFull()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaIsFull"), true);
            return;
        }
        if (this.gamePlayerManager.getArenaByPlayer(player, true) != null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("playerAlreadyPlaying"), true);
            return;
        }
        boolean emptyInventoryToJoin = this.plugin.getConfigsManager().getMainConfigManager().isEmptyInventoryToJoin();
        if (emptyInventoryToJoin && !PlayerUtils.isEmptyInventory(player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("emptyInventoryToJoin"), true);
            return;
        }
        this.playerJoinsArena(player, arena, messagesConfig, msgManager);
    }

    public void joinRandomArena(Player player) {
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        if (this.plugin.getVerifyManager().isCriticalErrors()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("pluginCriticalErrors"), true);
            return;
        }
        if (this.gamePlayerManager.getArenaByPlayer(player, true) != null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("playerAlreadyPlaying"), true);
            return;
        }
        boolean emptyInventoryToJoin = this.plugin.getConfigsManager().getMainConfigManager().isEmptyInventoryToJoin();
        if (emptyInventoryToJoin && !PlayerUtils.isEmptyInventory(player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("emptyInventoryToJoin"), true);
            return;
        }
        Arena arena = this.getAvailableArena();
        if (arena == null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noAvailableArenas"), true);
            return;
        }
        this.playerJoinsArena(player, arena, messagesConfig, msgManager);
    }

    public Arena getAvailableArena() {
        ArrayList<Arena> availableArenas = new ArrayList<Arena>();
        for (Arena a2 : this.arenas) {
            if (a2.isDisabled() || a2.isInGame() || a2.isFull()) continue;
            availableArenas.add(a2);
        }
        if (availableArenas.isEmpty()) {
            return null;
        }
        availableArenas.sort(Comparator.comparing(a -> a.getGamePlayers().size()).reversed());
        if (!((Arena)availableArenas.get(0)).getGamePlayers().isEmpty()) {
            return (Arena)availableArenas.get(0);
        }
        return (Arena)availableArenas.get(new Random().nextInt(availableArenas.size()));
    }

    private void playerJoinsArena(Player player, Arena arena, FileConfiguration messagesConfig, MessagesManager msgManager) {
        int minPlayers;
        GamePlayer gamePlayer = new GamePlayer(player);
        arena.addPlayer(gamePlayer);
        player.teleport(arena.getLobbyLocation());
        this.gamePlayerManager.clearPlayer(player);
        int maxPlayers = 2;
        int currentPlayers = arena.getGamePlayers().size();
        for (GamePlayer p : arena.getGamePlayers()) {
            msgManager.sendMessage((CommandSender)p.getPlayer(), messagesConfig.getString("playerJoin").replace("%current_players%", "" + currentPlayers).replace("%max_players%", "" + maxPlayers).replace("%player%", player.getName()), true);
        }
        PlayerInventory inv = player.getInventory();
        GameItemsConfig gameItemsConfig = this.plugin.getConfigsManager().getMainConfigManager().getGameItemsConfig();
        CommonItemManager commonItemManager = this.plugin.getCommonItemManager();
        GameItemConfig leaveItem = gameItemsConfig.getLeaveItem();
        if (leaveItem.isEnabled()) {
            ItemStack item = commonItemManager.createItemFromCommonItem(leaveItem.getItem());
            inv.setItem(8, ItemUtils.setTagStringItem(this.plugin, item, "minechess_item_type", "leave"));
        }
        if (currentPlayers >= (minPlayers = 2) && arena.getStatus().equals((Object)GameStatus.WAITING)) {
            this.startStartingStage(arena, messagesConfig, msgManager);
        }
    }

    private void startStartingStage(Arena arena, FileConfiguration messagesConfig, MessagesManager msgManager) {
        arena.setStatus(GameStatus.STARTING);
        int time = this.plugin.getConfigsManager().getMainConfigManager().getArenaStartingCooldown();
        for (GamePlayer p : arena.getGamePlayers()) {
            msgManager.sendMessage((CommandSender)p.getPlayer(), messagesConfig.getString("gameStarting").replace("%time%", "" + time), true);
        }
        arena.startCooldownTask(this.plugin, time);
    }

    public void startPlayingStage(Arena arena) {
        arena.stopCooldownTask();
        arena.setStatus(GameStatus.PLAYING);
        arena.setMillisStart(System.currentTimeMillis());
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        int num = new Random().nextInt(2);
        GamePlayer backup1 = arena.getPlayerBlack();
        GamePlayer backup2 = arena.getPlayerWhite();
        if (num == 0) {
            arena.setPlayerBlack(backup2);
            arena.setPlayerWhite(backup1);
        }
        msgManager.sendMessage((CommandSender)arena.getPlayerBlack().getPlayer(), messagesConfig.getString("gameStarted").replace("%piece_color%", messagesConfig.getString("pieceBlack")), true);
        msgManager.sendMessage((CommandSender)arena.getPlayerWhite().getPlayer(), messagesConfig.getString("gameStarted").replace("%piece_color%", messagesConfig.getString("pieceWhite")), true);
        arena.getPlayerBlack().getPlayer().teleport(arena.getSpawnPlayer1Location());
        arena.getPlayerWhite().getPlayer().teleport(arena.getSpawnPlayer2Location());
        this.plugin.getBoardManager().buildBoardPieces(arena);
        this.changeTurn(arena, true);
        for (GamePlayer gamePlayer : arena.getGamePlayers()) {
            Player player = gamePlayer.getPlayer();
            PlayerInventory inv = player.getInventory();
            GameItemsConfig gameItemsConfig = mainConfigManager.getGameItemsConfig();
            CommonItemManager commonItemManager = this.plugin.getCommonItemManager();
            GameItemConfig leaveItem = gameItemsConfig.getSelectItem();
            ItemStack item = commonItemManager.createItemFromCommonItem(leaveItem.getItem());
            inv.setItem(0, ItemUtils.setTagStringItem(this.plugin, item, "minechess_item_type", "select_piece"));
            if (!mainConfigManager.isColoredArmor()) continue;
            GameUtils.setColoredArmor(player, arena.getColor(gamePlayer));
        }
        int time = arena.getMaxTime();
        arena.startCooldownTask(this.plugin, time);
        this.plugin.getServer().getPluginManager().callEvent((Event)new ArenaStartEvent(arena));
    }

    public void changeTurn(Arena arena, boolean sendActions) {
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        arena.changeTurn();
        GamePlayer gamePlayer = arena.getPlayerTurn();
        ArrayList<CommonVariable> variables = new ArrayList<CommonVariable>();
        variables.add(new CommonVariable("%player%", gamePlayer.getName()));
        if (sendActions) {
            ActionUtils.executeActions(gamePlayer, arena, mainConfigManager.getGameActions().getGameActionsGame().getChangeTurn(), this.plugin, variables, true);
        }
        for (GamePlayer g : arena.getGamePlayers()) {
            this.gamePieceInteractionManager.updateInteractions(g);
        }
    }

    public void automaticMove(Arena arena) {
        GamePlayer gamePlayer = arena.getPlayerTurn();
        if (gamePlayer.isOnPromotion()) {
            List<PieceType> pieces = Arrays.asList(PieceType.BISHOP, PieceType.KNIGHT, PieceType.QUEEN, PieceType.ROOK);
            PieceType piece = pieces.get(new Random().nextInt(pieces.size()));
            this.gamePieceInteractionManager.promotePawn(arena, gamePlayer, piece);
        } else {
            ArrayList<CoordinateMovement> allPossibleMovements = arena.getBoard().getAllPossibleMovements(arena.getPlayerColorTurn());
            CoordinateMovement m = allPossibleMovements.get(new Random().nextInt(allPossibleMovements.size()));
            this.gamePieceInteractionManager.movePieceAutomatically(gamePlayer, arena, m.getFromX(), m.getFromY(), m.getMovement());
        }
    }

    public void leaveArena(Player player, Arena arena, GameLeaveReason reason) {
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        GamePlayer gamePlayer = arena.getGamePlayer(player, true);
        if (gamePlayer.isSpectator()) {
            this.gameSpectatorManager.leaveArena(player, arena, reason);
            return;
        }
        this.plugin.getScoreboardManager().removeScoreboard(player);
        this.gamePieceInteractionManager.updateInteractions(gamePlayer);
        int minPlayers = 2;
        int currentPlayers = arena.getGamePlayers().size() - 1;
        if (!reason.equals((Object)GameLeaveReason.SERVER_STOP) && !reason.equals((Object)GameLeaveReason.ARENA_DISABLED)) {
            if (currentPlayers < minPlayers && arena.getStatus().equals((Object)GameStatus.STARTING)) {
                arena.setStatus(GameStatus.WAITING);
                arena.stopCooldownTask();
                for (GamePlayer p : arena.getGamePlayers()) {
                    msgManager.sendMessage((CommandSender)p.getPlayer(), messagesConfig.getString("gameStartingCancelled"), true);
                }
            } else if (arena.getStatus().equals((Object)GameStatus.PLAYING) && currentPlayers < minPlayers) {
                if (arena.getPlayerWhite() != null && arena.getPlayerWhite().equals(gamePlayer)) {
                    arena.setWinner(arena.getPlayerBlack());
                } else if (arena.getPlayerBlack() != null && arena.getPlayerBlack().equals(gamePlayer)) {
                    arena.setWinner(arena.getPlayerWhite());
                }
                this.gameEndManager.startEndingStage(arena, GameEndsReason.PLAYER_LEAVES);
            }
        }
        Location location = this.plugin.getArenaManager().getMainLobbyLocation();
        player.teleport(location);
        this.plugin.getPlayerDataManager().getPlayerDataBackupManager().restorePlayerDataBackup(player, false, !reason.equals((Object)GameLeaveReason.SERVER_STOP));
        arena.removeGamePlayer(player);
        if (reason.equals((Object)GameLeaveReason.ARENA_DISABLED)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaDisabledKickMessage"), true);
        }
        int maxPlayers = 2;
        if (!reason.equals((Object)GameLeaveReason.END_GAME)) {
            for (GamePlayer p : arena.getGamePlayers(true)) {
                msgManager.sendMessage((CommandSender)p.getPlayer(), messagesConfig.getString("playerLeave").replace("%current_players%", "" + currentPlayers).replace("%max_players%", "" + maxPlayers).replace("%player%", player.getName()), true);
            }
        }
    }

    public void disableArena(Arena arena) {
        this.gameEndManager.endGame(arena, GameLeaveReason.ARENA_DISABLED);
        arena.disable();
    }

    private void kickPlayersFromArena(Arena arena, GameLeaveReason reason) {
        ArrayList<GamePlayer> playersCopy = new ArrayList<GamePlayer>(arena.getGamePlayers());
        for (GamePlayer p : playersCopy) {
            this.leaveArena(p.getPlayer(), arena, reason);
        }
    }

    public void endAllArenasFromServerStop() {
        for (Arena arena : this.arenas) {
            this.gameEndManager.endGame(arena, GameLeaveReason.SERVER_STOP);
        }
    }

    public GamePlayerManager getGamePlayerManager() {
        return this.gamePlayerManager;
    }

    public void winnersFireworks(final Arena arena) {
        new BukkitRunnable(){

            public void run() {
                GamePlayer winner = arena.getWinner();
                if (winner == null) {
                    return;
                }
                Player player = winner.getPlayer();
                if (player == null) {
                    return;
                }
                Arena arenaPlayer = ArenaManager.this.plugin.getArenaManager().getGamePlayerManager().getArenaByPlayer(player);
                if (arenaPlayer != null && arenaPlayer.equals(arena)) {
                    MainConfigManager mainConfigManager = ArenaManager.this.plugin.getConfigsManager().getMainConfigManager();
                    ActionUtils.firework(arena.getWinner().getPlayer(), mainConfigManager.getWinnerFireworksConfig(), ArenaManager.this.plugin);
                }
            }
        }.runTask((Plugin)this.plugin);
    }

    public GameItemManager getGameItemManager() {
        return this.gameItemManager;
    }

    public GamePieceInteractionManager getGamePieceInteractionManager() {
        return this.gamePieceInteractionManager;
    }

    public GameEndManager getGameEndManager() {
        return this.gameEndManager;
    }

    public GameSpectatorManager getGameSpectatorManager() {
        return this.gameSpectatorManager;
    }
}

