/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import mc.ajneb97.MineChess;
import mc.ajneb97.manager.ArenaManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.chess.Movement;
import mc.ajneb97.model.chess.Piece;
import mc.ajneb97.model.game.GameLeaveReason;
import mc.ajneb97.model.game.GamePlayer;
import mc.ajneb97.utils.ItemUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;

public class GameItemManager {
    private MineChess plugin;

    public GameItemManager(MineChess plugin) {
        this.plugin = plugin;
    }

    public void clickItem(Player player, ItemStack item, Arena arena, Action clickType) {
        ArenaManager arenasManager = this.plugin.getArenaManager();
        String type = ItemUtils.getTagStringItem(this.plugin, item, "minechess_item_type");
        if (type == null) {
            return;
        }
        GamePlayer gamePlayer = arena.getGamePlayer(player, true);
        if (gamePlayer.isOnPromotion()) {
            return;
        }
        if (clickType.name().contains("RIGHT")) {
            switch (type) {
                case "leave": {
                    arenasManager.leaveArena(player, arena, GameLeaveReason.ITEM);
                    break;
                }
                case "select_piece": {
                    this.rightClickSelectPiece(gamePlayer, arena);
                    break;
                }
                case "play_again": {
                    this.clickPlayAgainItem(gamePlayer, arena);
                }
            }
        } else {
            switch (type) {
                case "select_piece": {
                    this.leftClickSelectPiece(gamePlayer, arena);
                    return;
                }
            }
        }
    }

    public void leftClickSelectPiece(GamePlayer gamePlayer, Arena arena) {
        if (!arena.isTurnPlayer(gamePlayer)) {
            return;
        }
        if (!gamePlayer.isAfterDelaySelectPiece()) {
            return;
        }
        int[] seeingPos = gamePlayer.getSeeingPos();
        if (seeingPos == null) {
            return;
        }
        Piece piece = arena.getBoard().getPiece(seeingPos[0], seeingPos[1]);
        if (piece == null) {
            return;
        }
        if (!piece.getColor().equals((Object)arena.getColor(gamePlayer))) {
            return;
        }
        this.plugin.getArenaManager().getGamePieceInteractionManager().selectPiece(gamePlayer, arena, piece);
    }

    public void rightClickSelectPiece(GamePlayer gamePlayer, Arena arena) {
        if (!arena.isTurnPlayer(gamePlayer)) {
            return;
        }
        int[] seeingPos = gamePlayer.getSeeingPos();
        int[] selectedPos = gamePlayer.getSelectedPos();
        if (seeingPos == null || selectedPos == null) {
            return;
        }
        Movement movement = gamePlayer.getPossibleMovementCell(seeingPos);
        if (movement == null) {
            return;
        }
        this.plugin.getArenaManager().getGamePieceInteractionManager().movePieceManually(gamePlayer, arena, movement);
    }

    public void clickPlayAgainItem(GamePlayer gamePlayer, Arena arena) {
        ArenaManager arenaManager = this.plugin.getArenaManager();
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        Player player = gamePlayer.getPlayer();
        Arena availableArena = arenaManager.getAvailableArena();
        if (availableArena == null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("noAvailableArenas"), true);
            return;
        }
        arenaManager.leaveArena(player, arena, GameLeaveReason.ITEM);
        arenaManager.joinArena(player, availableArena);
    }
}

