/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import mc.ajneb97.MineChess;
import mc.ajneb97.config.model.gameitems.GameItemConfig;
import mc.ajneb97.config.model.gameitems.GameItemsConfig;
import mc.ajneb97.manager.CommonItemManager;
import mc.ajneb97.manager.GamePlayerManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.game.GameLeaveReason;
import mc.ajneb97.utils.ItemUtils;
import mc.ajneb97.utils.PlayerUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GameSpectatorManager {
    private MineChess plugin;

    public GameSpectatorManager(MineChess plugin) {
        this.plugin = plugin;
    }

    public void joinArena(Player player, Arena arena) {
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        GamePlayerManager gamePlayerManager = this.plugin.getArenaManager().getGamePlayerManager();
        if (arena.isDisabled()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaIsDisabled"), true);
            return;
        }
        if (!arena.isInGame()) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaIsNotInGame"), true);
            return;
        }
        if (gamePlayerManager.getArenaByPlayer(player, true) != null) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("playerAlreadyPlaying"), true);
            return;
        }
        boolean emptyInventoryToJoin = this.plugin.getConfigsManager().getMainConfigManager().isEmptyInventoryToJoin();
        if (emptyInventoryToJoin && !PlayerUtils.isEmptyInventory(player)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("emptyInventoryToJoin"), true);
            return;
        }
        this.spectatorJoinsArena(player, arena, gamePlayerManager);
    }

    private void spectatorJoinsArena(Player player, Arena arena, GamePlayerManager gamePlayerManager) {
        arena.addSpectator(player);
        player.teleport(arena.getLobbyLocation());
        gamePlayerManager.clearPlayer(player);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 99999999, 0, false, false));
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.hidePlayer((Plugin)this.plugin, player);
        }
        PlayerInventory inv = player.getInventory();
        GameItemsConfig gameItemsConfig = this.plugin.getConfigsManager().getMainConfigManager().getGameItemsConfig();
        CommonItemManager commonItemManager = this.plugin.getCommonItemManager();
        GameItemConfig leaveItem = gameItemsConfig.getLeaveItem();
        if (leaveItem.isEnabled()) {
            ItemStack item = commonItemManager.createItemFromCommonItem(leaveItem.getItem());
            inv.setItem(8, ItemUtils.setTagStringItem(this.plugin, item, "minechess_item_type", "leave"));
        }
    }

    public void leaveArena(Player player, Arena arena, GameLeaveReason reason) {
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.showPlayer((Plugin)this.plugin, player);
        }
        this.plugin.getScoreboardManager().removeScoreboard(player);
        this.plugin.getPlayerDataManager().getPlayerDataBackupManager().restorePlayerDataBackup(player, false, !reason.equals((Object)GameLeaveReason.SERVER_STOP));
        arena.removeSpectator(player);
        if (reason.equals((Object)GameLeaveReason.ARENA_DISABLED)) {
            msgManager.sendMessage((CommandSender)player, messagesConfig.getString("arenaDisabledKickMessage"), true);
        }
        Location location = this.plugin.getArenaManager().getMainLobbyLocation();
        player.teleport(location);
    }
}

