/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.tasks;

import java.util.ArrayList;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.MainConfigManager;
import mc.ajneb97.config.model.PieceInteraction;
import mc.ajneb97.manager.ArenaManager;
import mc.ajneb97.manager.BoardManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.chess.Movement;
import mc.ajneb97.model.chess.Piece;
import mc.ajneb97.model.game.GamePlayer;
import mc.ajneb97.utils.ParticleUtils;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArenaParticlesTask {
    private MineChess plugin;

    public ArenaParticlesTask(MineChess plugin) {
        this.plugin = plugin;
    }

    public void start() {
        new BukkitRunnable(){

            public void run() {
                ArenaParticlesTask.this.execute();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 5L);
    }

    public void execute() {
        ArenaManager arenaManager = this.plugin.getArenaManager();
        BoardManager boardManager = this.plugin.getBoardManager();
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        PieceInteraction seePieceInteraction = mainConfigManager.getPieceInteractions().getSeeCell();
        PieceInteraction selectedPieceInteraction = mainConfigManager.getPieceInteractions().getSelectedPiece();
        PieceInteraction validMovementsInteraction = mainConfigManager.getPieceInteractions().getValidMovements();
        PieceInteraction seeValidMovementsCellInteraction = mainConfigManager.getPieceInteractions().getSeeValidMovementCell();
        PieceInteraction invalidCheckMovementsInteraction = mainConfigManager.getPieceInteractions().getInvalidCheckMovements();
        for (Arena arena : arenaManager.getArenas()) {
            for (GamePlayer gamePlayer : arena.getGamePlayers()) {
                Piece piece;
                int[] seeingPos = gamePlayer.getSeeingPos();
                int[] selectedPos = gamePlayer.getSelectedPos();
                ArrayList<Movement> movementsPos = gamePlayer.getSelectedPieceAvailableMovements();
                if (selectedPos != null) {
                    this.particlesAtPos(gamePlayer, arena, selectedPos, selectedPieceInteraction, boardManager);
                }
                boolean alreadySeeing = false;
                if (movementsPos != null) {
                    for (Movement movement : movementsPos) {
                        if (movement.isPutsInCheck()) {
                            this.particlesAtPos(gamePlayer, arena, new int[]{movement.getX(), movement.getY()}, invalidCheckMovementsInteraction, boardManager);
                            continue;
                        }
                        this.particlesAtPos(gamePlayer, arena, new int[]{movement.getX(), movement.getY()}, validMovementsInteraction, boardManager);
                        if (seeingPos == null || seeingPos[0] != movement.getX() || seeingPos[1] != movement.getY()) continue;
                        this.particlesAtPos(gamePlayer, arena, new int[]{movement.getX(), movement.getY()}, seeValidMovementsCellInteraction, boardManager);
                        alreadySeeing = true;
                    }
                }
                if (alreadySeeing || seeingPos == null || ((piece = arena.getBoard().getPiece(seeingPos[0], seeingPos[1])) == null || !piece.getColor().equals((Object)arena.getColor(gamePlayer))) && !gamePlayer.isPossibleMovementCell(seeingPos)) continue;
                this.particlesAtPos(gamePlayer, arena, seeingPos, seePieceInteraction, boardManager);
            }
        }
    }

    private void particlesAtPos(GamePlayer gamePlayer, Arena arena, int[] pos, PieceInteraction pieceInteraction, BoardManager boardManager) {
        if (!pieceInteraction.isEnabled()) {
            return;
        }
        Location l = boardManager.getCellLocationFromPositionCentered(pos, arena);
        l.add(0.0, 1.5 + pieceInteraction.getOffsetY(), 0.0);
        String particle = pieceInteraction.getValue();
        double size = pieceInteraction.getSize();
        if (pieceInteraction.getType().equals((Object)PieceInteraction.ParticleFormType.CIRCLE)) {
            ParticleUtils.spawnCircleParticle(gamePlayer.getPlayer(), particle, l, size);
        } else {
            ParticleUtils.spawnSquareParticle(gamePlayer.getPlayer(), particle, l, size);
        }
    }
}

