/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.utils;

import java.util.List;
import mc.ajneb97.manager.MessagesManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class JSONMessage {
    private Player player;
    private String text;
    private BaseComponent[] hover;
    private String suggestCommand;
    private String executeCommand;

    public JSONMessage(Player player, String text) {
        this.player = player;
        this.hover = null;
        this.text = text;
    }

    public JSONMessage hover(List<String> list) {
        this.hover = new BaseComponent[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            TextComponent line = new TextComponent();
            if (i == list.size() - 1) {
                line.setText(ChatColor.translateAlternateColorCodes((char)'&', (String)list.get(i)));
            } else {
                line.setText(ChatColor.translateAlternateColorCodes((char)'&', (String)list.get(i)) + "\n");
            }
            this.hover[i] = line;
        }
        return this;
    }

    public JSONMessage setSuggestCommand(String command) {
        this.suggestCommand = command;
        return this;
    }

    public JSONMessage setExecuteCommand(String command) {
        this.executeCommand = command;
        return this;
    }

    public void send() {
        TextComponent message = new TextComponent();
        message.setText(MessagesManager.getLegacyColoredMessage(this.text));
        if (this.hover != null) {
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.hover));
        }
        if (this.suggestCommand != null) {
            message.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, this.suggestCommand));
        }
        if (this.executeCommand != null) {
            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.executeCommand));
        }
        this.player.spigot().sendMessage((BaseComponent)message);
    }
}

