/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.config;

import java.io.File;
import java.util.ArrayList;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.model.CommonConfig;

public abstract class DataFolderConfigManager {
    protected String folderName;
    protected MineChess plugin;

    public DataFolderConfigManager(MineChess plugin, String folderName) {
        this.plugin = plugin;
        this.folderName = folderName;
    }

    public void configure() {
        this.createFolder();
        this.loadConfigs();
    }

    public void createFolder() {
        try {
            File folder = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + this.folderName);
            if (!folder.exists()) {
                folder.mkdirs();
                this.createFiles();
            }
        }
        catch (SecurityException e) {
            Object folder = null;
        }
    }

    public CommonConfig getConfigFile(String pathName) {
        CommonConfig commonConfig = new CommonConfig(pathName, this.plugin, this.folderName, true);
        commonConfig.registerConfig();
        return commonConfig;
    }

    public ArrayList<CommonConfig> getConfigs() {
        File[] listOfFiles;
        ArrayList<CommonConfig> configs = new ArrayList<CommonConfig>();
        String pathFile = String.valueOf(this.plugin.getDataFolder()) + File.separator + this.folderName;
        File folder = new File(pathFile);
        for (File file : listOfFiles = folder.listFiles()) {
            if (!file.isFile()) continue;
            String pathName = file.getName();
            CommonConfig commonConfig = new CommonConfig(pathName, this.plugin, this.folderName, true);
            commonConfig.registerConfig();
            configs.add(commonConfig);
        }
        return configs;
    }

    public abstract void createFiles();

    public abstract void loadConfigs();

    public abstract void saveConfigs();
}

