/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mc.ajneb97.MineChess;
import mc.ajneb97.database.MySQLConnection;
import mc.ajneb97.manager.PlayerDataBackupManager;
import mc.ajneb97.model.data.PlayerData;
import mc.ajneb97.utils.OtherUtils;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private MineChess plugin;
    private Map<UUID, PlayerData> players;
    private Map<String, UUID> playerNames;
    private PlayerDataBackupManager playerDataBackupManager;

    public PlayerDataManager(MineChess plugin) {
        this.plugin = plugin;
        this.playerNames = new HashMap<String, UUID>();
        this.playerDataBackupManager = new PlayerDataBackupManager(plugin);
    }

    public Map<UUID, PlayerData> getPlayers() {
        return this.players;
    }

    public void setPlayers(Map<UUID, PlayerData> players) {
        this.players = players;
        for (Map.Entry<UUID, PlayerData> entry : players.entrySet()) {
            this.playerNames.put(entry.getValue().getName(), entry.getKey());
        }
    }

    public void addPlayer(PlayerData p) {
        this.players.put(p.getUuid(), p);
        this.playerNames.put(p.getName(), p.getUuid());
    }

    public PlayerData getPlayer(Player player, boolean create) {
        PlayerData playerData = this.players.get(player.getUniqueId());
        if (playerData == null && create) {
            playerData = new PlayerData(player.getUniqueId(), player.getName());
            this.addPlayer(playerData);
        }
        return playerData;
    }

    private void updatePlayerName(String oldName, String newName, UUID uuid) {
        this.playerNames.remove(oldName);
        this.playerNames.put(newName, uuid);
    }

    public PlayerData getPlayerByUUID(UUID uuid) {
        return this.players.get(uuid);
    }

    private UUID getPlayerUUID(String name) {
        return this.playerNames.get(name);
    }

    public PlayerData getPlayerByName(String name) {
        UUID uuid = this.getPlayerUUID(name);
        return this.players.get(uuid);
    }

    public void removePlayerByUUID(UUID uuid) {
        this.players.remove(uuid);
    }

    public void setJoinPlayerData(Player player) {
        if (this.plugin.getMySQLConnection() != null) {
            MySQLConnection mySQLConnection = this.plugin.getMySQLConnection();
            UUID uuid = player.getUniqueId();
            mySQLConnection.getPlayer(uuid.toString(), playerData -> {
                this.removePlayerByUUID(uuid);
                if (playerData != null) {
                    this.addPlayer(playerData);
                    if (!playerData.getName().equals(player.getName())) {
                        this.updatePlayerName(playerData.getName(), player.getName(), player.getUniqueId());
                        playerData.setName(player.getName());
                        mySQLConnection.updatePlayerName(playerData);
                    }
                }
            });
        } else {
            PlayerData playerData2 = this.getPlayer(player, false);
            if (!(playerData2 == null || playerData2.getName() != null && playerData2.getName().equals(player.getName()))) {
                this.updatePlayerName(playerData2.getName(), player.getName(), player.getUniqueId());
                playerData2.setName(player.getName());
                playerData2.setModified(true);
            }
        }
        this.playerDataBackupManager.restorePlayerDataBackup(player, true, true);
    }

    public int getWins(Player player) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData != null) {
            return playerData.getWins();
        }
        return 0;
    }

    public int getLoses(Player player) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData != null) {
            return playerData.getLoses();
        }
        return 0;
    }

    public int getTies(Player player) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData != null) {
            return playerData.getTies();
        }
        return 0;
    }

    public String getTimePlayed(Player player) {
        PlayerData playerData = this.getPlayer(player, false);
        if (playerData != null) {
            return OtherUtils.getTimeFormat2(playerData.getMillisPlayed() / 1000L, this.plugin.getMessagesManager());
        }
        return OtherUtils.getTimeFormat2(0L, this.plugin.getMessagesManager());
    }

    public void endGame(Player player, boolean win, boolean lose, long millisPlayed) {
        PlayerData playerData = this.getPlayer(player, true);
        if (win) {
            playerData.setWins(playerData.getWins() + 1);
        } else if (lose) {
            playerData.setLoses(playerData.getLoses() + 1);
        } else {
            playerData.setTies(playerData.getTies() + 1);
        }
        playerData.setMillisPlayed(playerData.getMillisPlayed() + millisPlayed);
        playerData.setModified(true);
        if (this.plugin.getMySQLConnection() != null) {
            this.plugin.getMySQLConnection().updatePlayer(playerData);
        }
    }

    public PlayerDataBackupManager getPlayerDataBackupManager() {
        return this.playerDataBackupManager;
    }
}

