/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97;

import mc.ajneb97.api.ExpansionMineChess;
import mc.ajneb97.api.MineChessAPI;
import mc.ajneb97.command.MainCommand;
import mc.ajneb97.config.ConfigsManager;
import mc.ajneb97.database.MySQLConnection;
import mc.ajneb97.listener.EditInventoryListener;
import mc.ajneb97.listener.OtherListenerNew;
import mc.ajneb97.listener.PlayerListener;
import mc.ajneb97.manager.ArenaManager;
import mc.ajneb97.manager.BoardManager;
import mc.ajneb97.manager.CommonItemManager;
import mc.ajneb97.manager.DependencyManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.manager.PlayerDataManager;
import mc.ajneb97.manager.UpdateCheckerManager;
import mc.ajneb97.manager.VerifyManager;
import mc.ajneb97.manager.editinventory.EditInventoryManager;
import mc.ajneb97.manager.inventory.InventoryManager;
import mc.ajneb97.model.internal.UpdateCheckerResult;
import mc.ajneb97.tasks.ArenaParticlesTask;
import mc.ajneb97.tasks.ArenaTpLobbyTask;
import mc.ajneb97.tasks.PlayerDataSaveTask;
import mc.ajneb97.tasks.ScoreboardManager;
import mc.ajneb97.tasks.SignManager;
import mc.ajneb97.utils.ServerVersion;
import mc.ajneb97.versions.NMSItemManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MineChess
extends JavaPlugin {
    PluginDescriptionFile pdfFile = this.getDescription();
    public String version = this.pdfFile.getVersion();
    public static String prefix;
    public static ServerVersion serverVersion;
    private ConfigsManager configsManager;
    private MessagesManager messagesManager;
    private ArenaManager arenaManager;
    private BoardManager boardManager;
    private PlayerDataManager playerDataManager;
    private CommonItemManager commonItemManager;
    private InventoryManager inventoryManager;
    private NMSItemManager nmsItemManager;
    private DependencyManager dependencyManager;
    private EditInventoryManager editInventoryManager;
    private ScoreboardManager scoreboardManager;
    private SignManager signManager;
    private ArenaTpLobbyTask arenaTpLobbyTask;
    private ArenaParticlesTask arenaParticlesTask;
    private PlayerDataSaveTask playerDataSaveTask;
    private MySQLConnection mySQLConnection;
    private VerifyManager verifyManager;
    private UpdateCheckerManager updateCheckerManager;

    public void onEnable() {
        this.setVersion();
        this.setPrefix();
        this.playerDataManager = new PlayerDataManager(this);
        this.commonItemManager = new CommonItemManager(this);
        this.arenaManager = new ArenaManager(this);
        this.boardManager = new BoardManager(this);
        this.inventoryManager = new InventoryManager(this);
        this.nmsItemManager = new NMSItemManager(this);
        this.dependencyManager = new DependencyManager(this);
        this.editInventoryManager = new EditInventoryManager(this);
        this.scoreboardManager = new ScoreboardManager(this);
        this.signManager = new SignManager(this);
        this.arenaTpLobbyTask = new ArenaTpLobbyTask(this);
        this.arenaParticlesTask = new ArenaParticlesTask(this);
        this.configsManager = new ConfigsManager(this);
        this.configsManager.configure();
        this.registerEvents();
        this.registerCommands();
        this.scoreboardManager.start();
        this.signManager.start();
        this.arenaTpLobbyTask.start();
        this.arenaParticlesTask.start();
        this.reloadPlayerDataSaveTask();
        this.boardManager.cleanArenas();
        MineChessAPI api = new MineChessAPI(this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new ExpansionMineChess(this).register();
        }
        this.verifyManager = new VerifyManager(this);
        this.verifyManager.verify();
        if (this.configsManager.getMainConfigManager().isMySQL()) {
            this.mySQLConnection = new MySQLConnection(this);
            this.mySQLConnection.setupMySql();
        }
        Bukkit.getConsoleSender().sendMessage(prefix + MessagesManager.getColoredMessage("&eHas been enabled! &fVersion: " + this.version));
        Bukkit.getConsoleSender().sendMessage(prefix + MessagesManager.getColoredMessage("&eThanks for using my plugin!   &f~Ajneb97"));
        this.updateCheckerManager = new UpdateCheckerManager(this.version);
        this.updateMessage(this.updateCheckerManager.check());
    }

    public void onDisable() {
        this.arenaManager.endAllArenasFromServerStop();
        this.configsManager.getPlayersConfigManager().saveConfigs();
        Bukkit.getConsoleSender().sendMessage(prefix + MessagesManager.getColoredMessage("&eHas been disabled! &fVersion: " + this.version));
    }

    public void registerCommands() {
        this.getCommand("minechess").setExecutor((CommandExecutor)new MainCommand(this));
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        pm.registerEvents((Listener)new EditInventoryListener(this), (Plugin)this);
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_20_R2)) {
            pm.registerEvents((Listener)new OtherListenerNew(this), (Plugin)this);
        }
    }

    public void setPrefix() {
        prefix = MessagesManager.getColoredMessage("&6[&fMineChess&6] ");
    }

    public void setVersion() {
        String bukkitVersion;
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        switch (bukkitVersion = Bukkit.getServer().getBukkitVersion().split("-")[0]) {
            case "1.20.5": 
            case "1.20.6": {
                serverVersion = ServerVersion.v1_20_R4;
                break;
            }
            case "1.21": 
            case "1.21.1": {
                serverVersion = ServerVersion.v1_21_R1;
                break;
            }
            case "1.21.2": 
            case "1.21.3": {
                serverVersion = ServerVersion.v1_21_R2;
                break;
            }
            case "1.21.4": {
                serverVersion = ServerVersion.v1_21_R3;
                break;
            }
            case "1.21.5": {
                serverVersion = ServerVersion.v1_21_R4;
                break;
            }
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": {
                serverVersion = ServerVersion.v1_21_R5;
                break;
            }
            case "1.21.9": 
            case "1.21.10": {
                serverVersion = ServerVersion.v1_21_R6;
                break;
            }
            default: {
                try {
                    serverVersion = ServerVersion.valueOf(packageName.replace("org.bukkit.craftbukkit.", ""));
                    break;
                }
                catch (Exception e) {
                    serverVersion = ServerVersion.v1_21_R6;
                }
            }
        }
    }

    public void reloadPlayerDataSaveTask() {
        if (this.playerDataSaveTask != null) {
            this.playerDataSaveTask.end();
        }
        this.playerDataSaveTask = new PlayerDataSaveTask(this);
        this.playerDataSaveTask.start(this.configsManager.getMainConfigManager().getPlayerDataSave());
    }

    public ConfigsManager getConfigsManager() {
        return this.configsManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public void setMessagesManager(MessagesManager messagesManager) {
        this.messagesManager = messagesManager;
    }

    public FileConfiguration getMessagesConfig() {
        return this.configsManager.getMessagesConfigManager().getConfigFile().getConfig();
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public BoardManager getBoardManager() {
        return this.boardManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public CommonItemManager getCommonItemManager() {
        return this.commonItemManager;
    }

    public NMSItemManager getNmsItemManager() {
        return this.nmsItemManager;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public SignManager getSignManager() {
        return this.signManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public EditInventoryManager getEditInventoryManager() {
        return this.editInventoryManager;
    }

    public MySQLConnection getMySQLConnection() {
        return this.mySQLConnection;
    }

    public VerifyManager getVerifyManager() {
        return this.verifyManager;
    }

    public UpdateCheckerManager getUpdateCheckerManager() {
        return this.updateCheckerManager;
    }

    public void updateMessage(UpdateCheckerResult result) {
        if (!result.isError()) {
            String latestVersion = result.getLatestVersion();
            if (latestVersion != null) {
                Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cThere is a new version available. &e(&7" + latestVersion + "&e)"));
                Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cYou can download it at: &fhttps://modrinth.com/plugin/minechess-minigame"));
            }
        } else {
            Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(prefix + " &cError while checking update."));
        }
    }
}

