/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mc.ajneb97.MineChess;
import mc.ajneb97.libs.fastboard.FastBoard;
import mc.ajneb97.manager.ArenaManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.game.GamePlayer;
import mc.ajneb97.model.game.GameStatus;
import mc.ajneb97.utils.OtherUtils;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ScoreboardManager {
    private final Map<UUID, FastBoard> boards;
    private MineChess plugin;
    private boolean stop;

    public ScoreboardManager(MineChess plugin) {
        this.plugin = plugin;
        this.boards = new HashMap<UUID, FastBoard>();
        this.stop = false;
    }

    public void start() {
        new BukkitRunnable(){

            public void run() {
                if (ScoreboardManager.this.stop) {
                    this.cancel();
                } else {
                    ScoreboardManager.this.execute();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 20L);
    }

    public void stop() {
        this.stop = true;
    }

    public void execute() {
        ArenaManager arenaManager = this.plugin.getArenaManager();
        ArrayList<Arena> arenas = arenaManager.getArenas();
        boolean isPlaceholderAPI = this.plugin.getDependencyManager().isPlaceholderAPI();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        String scoreboardTitle1 = messagesConfig.getString("scoreboards.arenaTimeGameMode.title");
        List scoreboardBody1 = messagesConfig.getStringList("scoreboards.arenaTimeGameMode.body");
        String statusWaiting = messagesConfig.getString("statusWaiting");
        String statusStarting = messagesConfig.getString("statusStarting");
        String statusIngame = messagesConfig.getString("statusIngame");
        String statusFinishing = messagesConfig.getString("statusFinishing");
        for (Arena arena : arenas) {
            String status = null;
            int time = arena.getCooldownTime();
            switch (arena.getStatus()) {
                case WAITING: {
                    status = statusWaiting;
                    break;
                }
                case STARTING: {
                    status = statusStarting.replace("%time%", OtherUtils.getTimeFormat1(time));
                    break;
                }
                case PLAYING: {
                    status = statusIngame.replace("%time%", OtherUtils.getTimeFormat1(time));
                    break;
                }
                case ENDING: {
                    status = statusFinishing.replace("%time%", OtherUtils.getTimeFormat1(time));
                }
            }
            this.updateScoreboard(arena, scoreboardBody1, status, isPlaceholderAPI, scoreboardTitle1);
        }
    }

    private void updateScoreboard(Arena arena, List<String> gameScoreboardBody, String status, boolean isPlaceholderAPI, String gameScoreboardTitle) {
        ArrayList<GamePlayer> players = arena.getGamePlayers(true);
        int whitePoints = arena.getWhitePoints();
        int blackPoints = arena.getBlackPoints();
        String whiteTime = this.getPlayerTime(arena, arena.getPlayerWhite());
        String blackTime = this.getPlayerTime(arena, arena.getPlayerBlack());
        for (GamePlayer gamePlayer : players) {
            Player player = gamePlayer.getPlayer();
            if (player == null) continue;
            FastBoard board = this.boards.get(player.getUniqueId());
            if (board == null) {
                board = new FastBoard(player);
                this.boards.put(player.getUniqueId(), board);
            }
            ArrayList<String> replacedScoreboardBody = new ArrayList<String>();
            for (String line : gameScoreboardBody) {
                line = line.replace("%white_points%", "" + whitePoints).replace("%black_points%", "" + blackPoints).replace("%status%", status).replace("%white_time%", whiteTime).replace("%black_time%", blackTime);
                if (isPlaceholderAPI) {
                    line = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                }
                replacedScoreboardBody.add(MessagesManager.getColoredMessage(line));
            }
            if (board.isDeleted()) continue;
            try {
                board.updateTitle(MessagesManager.getColoredMessage(gameScoreboardTitle));
                board.updateLines(replacedScoreboardBody);
            }
            catch (Exception exception) {}
        }
    }

    private String getPlayerTime(Arena arena, GamePlayer gamePlayer) {
        int time = arena.getPlayerWhite() != null ? (arena.getStatus().equals((Object)GameStatus.PLAYING) ? gamePlayer.getTurnTime() : arena.getMaxTime()) : arena.getMaxTime();
        return OtherUtils.getTimeFormat1(time);
    }

    public void removeScoreboard(Player player) {
        FastBoard board = this.boards.remove(player.getUniqueId());
        if (board != null) {
            board.delete();
        }
    }
}

