/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.tasks;

import java.util.ArrayList;
import java.util.List;
import mc.ajneb97.MineChess;
import mc.ajneb97.manager.ArenaManager;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.ArenaSign;
import mc.ajneb97.model.game.GameStatus;
import mc.ajneb97.utils.OtherUtils;
import mc.ajneb97.utils.PlayerUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SignManager {
    private MineChess plugin;
    private ArrayList<ArenaSign> arenaSigns;
    private boolean stop;

    public SignManager(MineChess plugin) {
        this.plugin = plugin;
        this.arenaSigns = new ArrayList();
        this.stop = false;
    }

    public void setArenaSigns(ArrayList<ArenaSign> arenaSigns) {
        this.arenaSigns = arenaSigns;
    }

    public ArenaSign getSignByLocation(Location location) {
        String world = location.getWorld().getName();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        for (ArenaSign sign : this.arenaSigns) {
            Location lS = sign.getLocation();
            String worldS = lS.getWorld().getName();
            int xS = lS.getBlockX();
            int yS = lS.getBlockY();
            int zS = lS.getBlockZ();
            if (!world.equals(worldS) || x != xS || y != yS || z != zS) continue;
            return sign;
        }
        return null;
    }

    public void removeSign(int id) {
        this.arenaSigns.removeIf(sign -> sign.getId() == id);
    }

    public void createSign(Player player, SignChangeEvent event) {
        if (!PlayerUtils.isMineChessAdmin((CommandSender)player)) {
            return;
        }
        String[] lines = event.getLines();
        if (!lines[0].equals("[minechess]")) {
            return;
        }
        String arenaName = lines[1];
        Arena arena = this.plugin.getArenaManager().getArenaByName(arenaName);
        if (arena == null) {
            return;
        }
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        List signFormat = messagesConfig.getStringList("signFormat");
        String status = SignManager.getSignStatus(arena, messagesConfig);
        int currentPlayers = arena.getGamePlayers().size();
        int maxPlayers = 2;
        for (int i = 0; i < signFormat.size(); ++i) {
            String line = ((String)signFormat.get(i)).replace("%arena%", arenaName).replace("%status%", status).replace("%current_players%", "" + currentPlayers).replace("%max_players%", "" + maxPlayers);
            event.setLine(i, MessagesManager.getColoredMessage(line));
        }
        ArenaSign arenaSign = new ArenaSign(this.arenaSigns.size() + 1, arenaName, event.getBlock().getLocation());
        this.arenaSigns.add(arenaSign);
        this.plugin.getConfigsManager().getSignsConfigManager().saveSign(arenaSign);
    }

    public void breakSign(Player player, BlockBreakEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (!block.getType().name().contains("SIGN")) {
            return;
        }
        ArenaSign arenaSign = this.getSignByLocation(location);
        if (arenaSign != null) {
            if (!PlayerUtils.isMineChessAdmin((CommandSender)player)) {
                event.setCancelled(true);
                return;
            }
            this.removeSign(arenaSign.getId());
            this.plugin.getConfigsManager().getSignsConfigManager().deleteSign(arenaSign.getId());
        }
    }

    public void openSign(PlayerSignOpenEvent event) {
        ArenaSign arenaSign = this.getSignByLocation(event.getSign().getLocation());
        if (arenaSign != null) {
            event.setCancelled(true);
        }
    }

    public void start() {
        new BukkitRunnable(){

            public void run() {
                if (SignManager.this.stop) {
                    this.cancel();
                } else {
                    SignManager.this.execute();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 30L);
    }

    public void stop() {
        this.stop = true;
    }

    public void execute() {
        ArenaManager arenaManager = this.plugin.getArenaManager();
        ArrayList<ArenaSign> arenaSignsClone = new ArrayList<ArenaSign>(this.arenaSigns);
        for (ArenaSign arenaSign : arenaSignsClone) {
            Location l = arenaSign.getLocation();
            Arena arena = arenaManager.getArenaByName(arenaSign.getArenaName());
            if (arena == null) continue;
            GameStatus currentStatus = arena.getStatus();
            int currentPlayers = arena.getGamePlayers().size();
            if (currentStatus.equals((Object)arenaSign.getPreviousGameStatus()) && currentPlayers == arenaSign.getPreviousNumberOfPlayers() || !OtherUtils.isChunkLoaded(l)) continue;
            Block block = l.getWorld().getBlockAt(l);
            if (!block.getType().name().contains("SIGN")) {
                this.removeSign(arenaSign.getId());
                this.plugin.getConfigsManager().getSignsConfigManager().deleteSign(arenaSign.getId());
                continue;
            }
            Sign sign = (Sign)block.getState();
            String arenaName = arena.getName();
            FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
            List signFormat = messagesConfig.getStringList("signFormat");
            String status = SignManager.getSignStatus(arena, messagesConfig);
            int maxPlayers = 2;
            for (int i = 0; i < signFormat.size(); ++i) {
                String line = ((String)signFormat.get(i)).replace("%arena%", arenaName).replace("%status%", status).replace("%current_players%", "" + currentPlayers).replace("%max_players%", "" + maxPlayers);
                sign.setLine(i, MessagesManager.getColoredMessage(line));
            }
            sign.update();
            arenaSign.setPreviousGameStatus(arena.getStatus());
            arenaSign.setPreviousNumberOfPlayers(currentPlayers);
        }
    }

    public static String getSignStatus(Arena arena, FileConfiguration messagesConfig) {
        return switch (arena.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case GameStatus.WAITING -> messagesConfig.getString("signStatusWaiting");
            case GameStatus.STARTING -> messagesConfig.getString("signStatusStarting");
            case GameStatus.PLAYING -> messagesConfig.getString("signStatusIngame");
            case GameStatus.ENDING -> messagesConfig.getString("signStatusFinishing");
            case GameStatus.DISABLED -> messagesConfig.getString("signStatusDisabled");
        };
    }

    public void clickSign(Player player, PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !block.getType().name().contains("SIGN")) {
            return;
        }
        ArenaSign arenaSign = this.getSignByLocation(block.getLocation());
        if (arenaSign != null) {
            event.setCancelled(true);
            ArenaManager arenaManager = this.plugin.getArenaManager();
            Arena arena = arenaManager.getArenaByName(arenaSign.getArenaName());
            if (arena != null) {
                this.plugin.getArenaManager().joinArena(player, arena);
            }
        }
    }
}

