/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager.editinventory;

import java.util.ArrayList;
import mc.ajneb97.MineChess;
import mc.ajneb97.manager.editinventory.EditArenaInventoryManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.editinventory.EditInventoryPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class EditInventoryManager {
    private MineChess plugin;
    private ArrayList<EditInventoryPlayer> players;
    private EditArenaInventoryManager arenaInventoryManager;

    public EditInventoryManager(MineChess plugin) {
        this.plugin = plugin;
        this.players = new ArrayList();
        this.arenaInventoryManager = new EditArenaInventoryManager(plugin);
    }

    public ArrayList<EditInventoryPlayer> getPlayers() {
        return this.players;
    }

    public EditInventoryPlayer getEditInventoryPlayer(Player player) {
        for (EditInventoryPlayer p : this.players) {
            if (!player.getName().equals(p.getPlayer().getName())) continue;
            return p;
        }
        return null;
    }

    public void removeEditInventoryPlayer(Player player) {
        this.players.removeIf(p -> p.getPlayer().equals((Object)player));
    }

    public void openArenaInventory(Player player, Arena arena) {
        EditInventoryPlayer editInventoryPlayer = new EditInventoryPlayer(player);
        editInventoryPlayer.setArena(arena);
        this.arenaInventoryManager.openMainInventory(editInventoryPlayer);
    }

    public void onClick(EditInventoryPlayer editInventoryPlayer, int slot, ItemStack item, ClickType clickType) {
        EditInventoryPlayer.InventoryType inventoryType = editInventoryPlayer.getCurrentInventory();
        switch (inventoryType) {
            case ARENA: {
                this.arenaInventoryManager.onInventoryClick(editInventoryPlayer, slot, item, clickType);
            }
        }
    }
}

