/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.model;

import java.util.ArrayList;
import mc.ajneb97.MineChess;
import mc.ajneb97.model.ArenaEndTimeMode;
import mc.ajneb97.model.PlayerColor;
import mc.ajneb97.model.chess.Board;
import mc.ajneb97.model.game.GameEndsReason;
import mc.ajneb97.model.game.GamePlayer;
import mc.ajneb97.model.game.GameStatus;
import mc.ajneb97.tasks.ArenaCooldownManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class Arena {
    private String name;
    private Board board;
    private Material boardBlackCellBlock;
    private Material boardWhiteCellBlock;
    private int maxTime;
    private int turnTime;
    private ArenaEndTimeMode endTimeMode;
    private Location lobbyLocation;
    private Location spawnPlayer1Location;
    private Location spawnPlayer2Location;
    private Location boardStartLocation;
    private GameStatus status;
    private GamePlayer playerBlack;
    private GamePlayer playerWhite;
    private GamePlayer winner;
    private PlayerColor playerColorTurn;
    private GameEndsReason endReason;
    private long millisStart;
    private ArrayList<GamePlayer> spectators;
    private int movementsWithoutProgress;
    private ArenaCooldownManager arenaCooldownManager;

    public Arena(String name) {
        this.name = name;
        this.status = GameStatus.DISABLED;
        this.board = new Board();
        this.board.createInitialBoard();
        this.spectators = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GameStatus getStatus() {
        return this.status;
    }

    public void setStatus(GameStatus status) {
        this.status = status;
    }

    public Board getBoard() {
        return this.board;
    }

    public void setBoard(Board board) {
        this.board = board;
    }

    public Material getBoardBlackCellBlock() {
        return this.boardBlackCellBlock;
    }

    public void setBoardBlackCellBlock(Material boardBlackCellBlock) {
        this.boardBlackCellBlock = boardBlackCellBlock;
    }

    public Material getBoardWhiteCellBlock() {
        return this.boardWhiteCellBlock;
    }

    public void setBoardWhiteCellBlock(Material boardWhiteCellBlock) {
        this.boardWhiteCellBlock = boardWhiteCellBlock;
    }

    public Location getLobbyLocation() {
        return this.lobbyLocation;
    }

    public void setLobbyLocation(Location lobbyLocation) {
        this.lobbyLocation = lobbyLocation;
    }

    public Location getSpawnPlayer1Location() {
        return this.spawnPlayer1Location;
    }

    public void setSpawnPlayer1Location(Location spawnPlayer1Location) {
        this.spawnPlayer1Location = spawnPlayer1Location;
    }

    public Location getSpawnPlayer2Location() {
        return this.spawnPlayer2Location;
    }

    public void setSpawnPlayer2Location(Location spawnPlayer2Location) {
        this.spawnPlayer2Location = spawnPlayer2Location;
    }

    public Location getBoardStartLocation() {
        return this.boardStartLocation;
    }

    public void setBoardStartLocation(Location boardStartLocation) {
        this.boardStartLocation = boardStartLocation;
    }

    public boolean isDisabled() {
        return this.status.equals((Object)GameStatus.DISABLED);
    }

    public void configureLocations(Location boardStartLocation, int cellSize) {
        this.boardStartLocation = boardStartLocation;
        this.lobbyLocation = boardStartLocation.clone().add((double)(cellSize * 4), (double)cellSize * 1.5, (double)(cellSize * 4));
        this.spawnPlayer1Location = boardStartLocation.clone().add((double)(cellSize * 4), (double)(cellSize * 2), (double)cellSize);
        this.spawnPlayer1Location.setYaw(0.0f);
        this.spawnPlayer1Location.setPitch(40.0f);
        this.spawnPlayer2Location = boardStartLocation.clone().add((double)(cellSize * 4), (double)(cellSize * 2), (double)(cellSize * 7));
        this.spawnPlayer2Location.setYaw(180.0f);
        this.spawnPlayer2Location.setPitch(40.0f);
    }

    public boolean locationsAreMissing() {
        return this.lobbyLocation == null || this.spawnPlayer1Location == null || this.spawnPlayer2Location == null;
    }

    public void enable() {
        this.status = GameStatus.WAITING;
    }

    public void disable() {
        this.status = GameStatus.DISABLED;
    }

    public boolean isInGame() {
        return this.status.equals((Object)GameStatus.PLAYING) || this.status.equals((Object)GameStatus.ENDING);
    }

    public boolean isEnding() {
        return this.status.equals((Object)GameStatus.ENDING);
    }

    public GamePlayer getPlayerBlack() {
        return this.playerBlack;
    }

    public void setPlayerBlack(GamePlayer playerBlack) {
        this.playerBlack = playerBlack;
    }

    public GamePlayer getPlayerWhite() {
        return this.playerWhite;
    }

    public void setPlayerWhite(GamePlayer playerWhite) {
        this.playerWhite = playerWhite;
    }

    public ArrayList<GamePlayer> getGamePlayers() {
        ArrayList<GamePlayer> players = new ArrayList<GamePlayer>();
        if (this.playerBlack != null) {
            players.add(this.playerBlack);
        }
        if (this.playerWhite != null) {
            players.add(this.playerWhite);
        }
        return players;
    }

    public ArrayList<GamePlayer> getGamePlayers(boolean includeSpectators) {
        ArrayList<GamePlayer> players = this.getGamePlayers();
        if (includeSpectators) {
            players.addAll(this.spectators);
        }
        return players;
    }

    public boolean isFull() {
        return this.playerBlack != null && this.playerWhite != null;
    }

    public GamePlayer getGamePlayer(Player player) {
        if (this.playerWhite != null && this.playerWhite.getPlayer() != null && this.playerWhite.getPlayer().equals((Object)player)) {
            return this.playerWhite;
        }
        if (this.playerBlack != null && this.playerBlack.getPlayer() != null && this.playerBlack.getPlayer().equals((Object)player)) {
            return this.playerBlack;
        }
        return null;
    }

    public GamePlayer getGamePlayer(Player player, boolean includeSpectator) {
        GamePlayer gamePlayer = this.getGamePlayer(player);
        if (gamePlayer != null) {
            return gamePlayer;
        }
        if (includeSpectator) {
            for (GamePlayer g : this.spectators) {
                if (!g.getPlayer().equals((Object)player)) continue;
                return g;
            }
        }
        return null;
    }

    public void addPlayer(GamePlayer gamePlayer) {
        if (this.playerWhite == null) {
            this.playerWhite = gamePlayer;
            return;
        }
        if (this.playerBlack == null) {
            this.playerBlack = gamePlayer;
        }
    }

    public void startCooldownTask(MineChess plugin, int time) {
        this.stopCooldownTask();
        this.arenaCooldownManager = new ArenaCooldownManager(plugin, this, time);
        this.arenaCooldownManager.start();
    }

    public void stopCooldownTask() {
        if (this.arenaCooldownManager != null) {
            this.arenaCooldownManager.stop();
            this.arenaCooldownManager = null;
        }
    }

    public int getCooldownTime() {
        if (this.arenaCooldownManager != null) {
            return this.arenaCooldownManager.getTime();
        }
        return 0;
    }

    public int getWhitePoints() {
        if (this.playerWhite != null) {
            return this.playerWhite.getPoints();
        }
        return 0;
    }

    public int getBlackPoints() {
        if (this.playerBlack != null) {
            return this.playerBlack.getPoints();
        }
        return 0;
    }

    public void removeGamePlayer(Player player) {
        if (this.playerWhite != null && this.playerWhite.getPlayer().equals((Object)player)) {
            this.playerWhite = null;
            return;
        }
        if (this.playerBlack != null && this.playerBlack.getPlayer().equals((Object)player)) {
            this.playerBlack = null;
        }
    }

    public GamePlayer getWinner() {
        return this.winner;
    }

    public void setWinner(GamePlayer winner) {
        this.winner = winner;
    }

    public void resetArena() {
        this.winner = null;
        this.playerColorTurn = null;
        this.board = new Board();
        this.board.createInitialBoard();
        this.millisStart = 0L;
        this.endReason = null;
        this.movementsWithoutProgress = 0;
    }

    public PlayerColor getColor(GamePlayer gamePlayer) {
        if (this.playerWhite != null && this.playerWhite.equals(gamePlayer)) {
            return PlayerColor.WHITE;
        }
        if (this.playerBlack != null && this.playerBlack.equals(gamePlayer)) {
            return PlayerColor.BLACK;
        }
        return null;
    }

    public GamePlayer getPlayerByColor(PlayerColor playerColor) {
        if (playerColor.equals((Object)PlayerColor.WHITE)) {
            return this.playerWhite;
        }
        return this.playerBlack;
    }

    public PlayerColor getPlayerColorTurn() {
        return this.playerColorTurn;
    }

    public GamePlayer getPlayerTurn() {
        return this.getPlayerByColor(this.playerColorTurn);
    }

    public GamePlayer getOpponentPlayer(GamePlayer gamePlayer) {
        if (this.playerWhite == gamePlayer) {
            return this.playerBlack;
        }
        return this.playerWhite;
    }

    public void setPlayerColorTurn(PlayerColor playerColorTurn) {
        this.playerColorTurn = playerColorTurn;
    }

    public void changeTurn() {
        this.playerBlack.setTurnTime(this.turnTime);
        this.playerWhite.setTurnTime(this.turnTime);
        if (this.playerColorTurn == null) {
            this.playerColorTurn = PlayerColor.WHITE;
            return;
        }
        this.playerColorTurn = this.playerColorTurn.equals((Object)PlayerColor.WHITE) ? PlayerColor.BLACK : PlayerColor.WHITE;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    public int getTurnTime() {
        return this.turnTime;
    }

    public void setTurnTime(int turnTime) {
        this.turnTime = turnTime;
    }

    public ArenaEndTimeMode getEndTimeMode() {
        return this.endTimeMode;
    }

    public void setEndTimeMode(ArenaEndTimeMode endTimeMode) {
        this.endTimeMode = endTimeMode;
    }

    public void setDefaults(Arena defaultArena) {
        this.endTimeMode = defaultArena.getEndTimeMode();
        this.maxTime = defaultArena.getMaxTime();
        this.turnTime = defaultArena.getTurnTime();
        this.boardBlackCellBlock = defaultArena.getBoardBlackCellBlock();
        this.boardWhiteCellBlock = defaultArena.getBoardWhiteCellBlock();
    }

    public boolean isTurnPlayer(GamePlayer gamePlayer) {
        return this.getPlayerTurn() == gamePlayer;
    }

    public long getMillisStart() {
        return this.millisStart;
    }

    public void setMillisStart(long millisStart) {
        this.millisStart = millisStart;
    }

    public GameEndsReason getEndReason() {
        return this.endReason;
    }

    public void setEndReason(GameEndsReason endReason) {
        this.endReason = endReason;
    }

    public ArrayList<GamePlayer> getSpectators() {
        return this.spectators;
    }

    public void setSpectators(ArrayList<GamePlayer> spectators) {
        this.spectators = spectators;
    }

    public void addSpectator(Player player) {
        GamePlayer gamePlayer = new GamePlayer(player);
        gamePlayer.setSpectator(true);
        this.spectators.add(gamePlayer);
    }

    public void removeSpectator(Player player) {
        this.spectators.removeIf(g -> g.getPlayer().equals((Object)player));
    }

    public int getMovementsWithoutProgress() {
        return this.movementsWithoutProgress;
    }

    public void setMovementsWithoutProgress(int movementsWithoutProgress) {
        this.movementsWithoutProgress = movementsWithoutProgress;
    }
}

