/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.model.game;

import java.util.ArrayList;
import mc.ajneb97.model.chess.Movement;
import org.bukkit.entity.Player;

public class GamePlayer {
    private Player player;
    private int[] previousPos;
    private int[] seeingPos;
    private int[] selectedPos;
    private ArrayList<Movement> selectedPieceAvailableMovements;
    private int points;
    private int turnTime;
    private int[] promotionPos;
    private long delaySelectPieceNextMillis;
    private boolean isSpectator;

    public GamePlayer(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void addPoints(int value) {
        this.points += value;
    }

    public int[] getSeeingPos() {
        return this.seeingPos;
    }

    public void setSeeingPos(int[] seeingPos) {
        this.seeingPos = seeingPos;
    }

    public int[] getPreviousPos() {
        return this.previousPos;
    }

    public void setPreviousPos(int[] previousPos) {
        this.previousPos = previousPos;
    }

    public int[] getSelectedPos() {
        return this.selectedPos;
    }

    public void setSelectedPos(int[] selectedPos) {
        this.selectedPos = selectedPos;
    }

    public ArrayList<Movement> getSelectedPieceAvailableMovements() {
        return this.selectedPieceAvailableMovements;
    }

    public void setSelectedPieceAvailableMovements(ArrayList<Movement> selectedPieceAvailableMovements) {
        this.selectedPieceAvailableMovements = selectedPieceAvailableMovements;
    }

    public boolean isPossibleMovementCell(int[] pos) {
        if (this.selectedPieceAvailableMovements != null) {
            for (Movement m : this.selectedPieceAvailableMovements) {
                if (pos[0] != m.getX() || pos[1] != m.getY()) continue;
                return true;
            }
        }
        return false;
    }

    public Movement getPossibleMovementCell(int[] pos) {
        if (this.selectedPieceAvailableMovements != null) {
            for (Movement m : this.selectedPieceAvailableMovements) {
                if (pos[0] != m.getX() || pos[1] != m.getY()) continue;
                return m;
            }
        }
        return null;
    }

    public int getTurnTime() {
        return this.turnTime;
    }

    public void setTurnTime(int turnTime) {
        this.turnTime = turnTime;
    }

    public void reduceTurnTime() {
        --this.turnTime;
    }

    public boolean isOnPromotion() {
        return this.promotionPos != null;
    }

    public int[] getPromotionPos() {
        return this.promotionPos;
    }

    public void setPromotionPos(int[] promotionPos) {
        this.promotionPos = promotionPos;
    }

    public long getDelaySelectPieceNextMillis() {
        return this.delaySelectPieceNextMillis;
    }

    public void setDelaySelectPieceNextMillis(long delaySelectPieceNextMillis) {
        this.delaySelectPieceNextMillis = delaySelectPieceNextMillis;
    }

    public boolean isAfterDelaySelectPiece() {
        return System.currentTimeMillis() >= this.delaySelectPieceNextMillis;
    }

    public boolean isSpectator() {
        return this.isSpectator;
    }

    public void setSpectator(boolean spectator) {
        this.isSpectator = spectator;
    }

    public String getName() {
        return this.player.getName();
    }
}

