/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.utils;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public class ParticleUtils {
    public static void spawnCircleParticle(Player player, String particleName, Location location, double radius) {
        int particles = 20;
        Location location1 = location.clone();
        for (int i = 0; i < particles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particles;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            location1.add(x, 0.0, z);
            ParticleUtils.spawnParticle(player, particleName, location1, 0.01f, 1, 0.0, 0.0, 0.0);
            location1.subtract(x, 0.0, z);
        }
    }

    public static void spawnSquareParticle(Player player, String particleName, Location location, double radius) {
        int particlesPerSide = 7;
        Location particleLocation = location.clone();
        for (int i = 0; i < particlesPerSide; ++i) {
            float ratio = (float)i / (float)particlesPerSide;
            particleLocation.setX(location.getX() - radius + 2.0 * radius * (double)ratio);
            particleLocation.setZ(location.getZ() - radius);
            ParticleUtils.spawnParticle(player, particleName, particleLocation, 0.01f, 1, 0.0, 0.0, 0.0);
            particleLocation.setX(location.getX() + radius);
            particleLocation.setZ(location.getZ() - radius + 2.0 * radius * (double)ratio);
            ParticleUtils.spawnParticle(player, particleName, particleLocation, 0.01f, 1, 0.0, 0.0, 0.0);
            particleLocation.setX(location.getX() + radius - 2.0 * radius * (double)ratio);
            particleLocation.setZ(location.getZ() + radius);
            ParticleUtils.spawnParticle(player, particleName, particleLocation, 0.01f, 1, 0.0, 0.0, 0.0);
            particleLocation.setX(location.getX() - radius);
            particleLocation.setZ(location.getZ() + radius - 2.0 * radius * (double)ratio);
            ParticleUtils.spawnParticle(player, particleName, particleLocation, 0.01f, 1, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticle(Player player, String particle, Location l, float speed, int amount, double offsetX, double offsetY, double offsetZ) {
        try {
            if (particle.startsWith("REDSTONE;") || particle.startsWith("DUST;")) {
                String[] sep = particle.split(";");
                int rgb = Integer.parseInt(sep[1]);
                Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)rgb), 1.0f);
                player.spawnParticle(Particle.valueOf((String)sep[0]), l, amount, offsetX, offsetY, offsetZ, (double)speed, (Object)dustOptions);
            } else {
                player.spawnParticle(Particle.valueOf((String)particle), l, amount, offsetX, offsetY, offsetZ, (double)speed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

