/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.model.PerArenaChatConfig;
import mc.ajneb97.libs.actionbar.ActionBarAPI;
import mc.ajneb97.manager.MessagesManager;
import mc.ajneb97.manager.inventory.InventoryManager;
import mc.ajneb97.manager.inventory.InventoryType;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.game.GameLeaveReason;
import mc.ajneb97.model.game.GamePlayer;
import mc.ajneb97.model.game.GameStatus;
import mc.ajneb97.model.inventory.InventoryPlayer;
import mc.ajneb97.utils.InventoryUtils;
import mc.ajneb97.utils.ItemUtils;
import mc.ajneb97.utils.OtherUtils;
import mc.ajneb97.utils.PlayerUtils;
import mc.ajneb97.utils.ServerVersion;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;

public class GamePlayerManager {
    private MineChess plugin;

    public GamePlayerManager(MineChess plugin) {
        this.plugin = plugin;
    }

    public Arena getArenaByPlayer(Player player) {
        ArrayList<Arena> arenas = this.plugin.getArenaManager().getArenas();
        for (Arena arena : arenas) {
            if (arena.getGamePlayer(player) == null) continue;
            return arena;
        }
        return null;
    }

    public Arena getArenaByPlayer(Player player, boolean checkSpectator) {
        ArrayList<Arena> arenas = this.plugin.getArenaManager().getArenas();
        for (Arena arena : arenas) {
            if (arena.getGamePlayer(player, checkSpectator) == null) continue;
            return arena;
        }
        return null;
    }

    public GamePlayer getGamePlayer(Player player) {
        ArrayList<Arena> arenas = this.plugin.getArenaManager().getArenas();
        for (Arena arena : arenas) {
            GamePlayer gamePlayer = arena.getGamePlayer(player);
            if (gamePlayer == null) continue;
            return gamePlayer;
        }
        return null;
    }

    public GamePlayer getGamePlayer(Player player, boolean checkSpectator) {
        ArrayList<Arena> arenas = this.plugin.getArenaManager().getArenas();
        for (Arena arena : arenas) {
            GamePlayer gamePlayer = arena.getGamePlayer(player, checkSpectator);
            if (gamePlayer == null) continue;
            return gamePlayer;
        }
        return null;
    }

    public void clearPlayer(Player player) {
        this.plugin.getPlayerDataManager().getPlayerDataBackupManager().createPlayerDataBackup(player);
        player.getInventory().clear();
        player.getEquipment().clear();
        player.setGameMode(GameMode.SURVIVAL);
        player.setFoodLevel(20);
        ServerVersion serverVersion = MineChess.serverVersion;
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R2)) {
            player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(20.0);
        } else {
            player.getAttribute(ItemUtils.getAttributeByName("GENERIC_MAX_HEALTH")).setBaseValue(20.0);
        }
        player.setHealth(20.0);
        player.setLevel(0);
        player.setExp(0.0f);
        player.setAllowFlight(true);
        player.setFlying(true);
        for (PotionEffect p : player.getActivePotionEffects()) {
            player.removePotionEffect(p.getType());
        }
    }

    public void swapHand(Player player, PlayerSwapHandItemsEvent event) {
        if (this.getGamePlayer(player, true) != null) {
            event.setCancelled(true);
        }
    }

    public void breakBlock(Player player, BlockBreakEvent event) {
        this.plugin.getSignManager().breakSign(player, event);
        if (this.getGamePlayer(player, true) != null) {
            event.setCancelled(true);
        }
    }

    public void placeBlock(Player player, BlockPlaceEvent event) {
        if (this.getGamePlayer(player, true) != null) {
            event.setCancelled(true);
        }
    }

    public void dropItem(Player player, PlayerDropItemEvent event) {
        if (this.getGamePlayer(player, true) != null) {
            event.setCancelled(true);
        }
    }

    public void foodChange(Player player, FoodLevelChangeEvent event) {
        if (this.getGamePlayer(player, true) != null) {
            event.setCancelled(true);
        }
    }

    public void interactEntity(Player player, PlayerInteractAtEntityEvent event) {
        if (this.getGamePlayer(player, true) != null) {
            event.setCancelled(true);
        }
    }

    public void useCommand(Player player, PlayerCommandPreprocessEvent event) {
        GamePlayer gamePlayer = this.getGamePlayer(player, true);
        if (gamePlayer == null) {
            return;
        }
        if (PlayerUtils.isMineChessAdmin((CommandSender)player)) {
            return;
        }
        List<String> commandWhitelist = this.plugin.getConfigsManager().getMainConfigManager().getCommandsWhitelist();
        String command = event.getMessage();
        for (String c : commandWhitelist) {
            if (!c.equalsIgnoreCase(command)) continue;
            return;
        }
        MessagesManager msgManager = this.plugin.getMessagesManager();
        FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        msgManager.sendMessage((CommandSender)player, messagesConfig.getString("commandBlocked"), true);
        event.setCancelled(true);
    }

    public void chat(Player player, AsyncPlayerChatEvent event) {
        Arena arena = this.getArenaByPlayer(player);
        PerArenaChatConfig config = this.plugin.getConfigsManager().getMainConfigManager().getPerArenaChat();
        if (!config.isEnabled()) {
            return;
        }
        if (arena == null) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.getArenaByPlayer(p) == null) continue;
                event.getRecipients().remove(p);
            }
        } else {
            event.setCancelled(true);
            String format = config.getFormat();
            String message = event.getMessage();
            for (GamePlayer p : arena.getGamePlayers()) {
                String msg = MessagesManager.getColoredMessage(format.replace("%player%", player.getName()).replace("%message%", message));
                p.getPlayer().sendMessage(msg);
            }
        }
    }

    public void interact(Player player, PlayerInteractEvent event) {
        this.plugin.getSignManager().clickSign(player, event);
        Arena arena = this.getArenaByPlayer(player, true);
        if (arena == null) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getItem();
        Action action = event.getAction();
        if (action.name().contains("CLICK") && item != null) {
            this.plugin.getArenaManager().getGameItemManager().clickItem(player, item, arena, action);
        }
    }

    public void damageEntity(Player player, EntityDamageByEntityEvent event) {
        if (this.getGamePlayer(player, true) != null) {
            event.setCancelled(true);
        }
    }

    public void receiveDamage(Player player, EntityDamageEvent event) {
        if (this.getGamePlayer(player, true) != null) {
            event.setCancelled(true);
        }
    }

    public void leaveServer(Player player) {
        Arena arena = this.getArenaByPlayer(player, true);
        if (arena != null) {
            this.plugin.getArenaManager().leaveArena(player, arena, GameLeaveReason.LEAVE_SERVER);
        }
    }

    public void moveCamera(Player player, PlayerMoveEvent event) {
        Block b;
        Arena arena = this.getArenaByPlayer(player);
        if (arena == null) {
            return;
        }
        if (!arena.getStatus().equals((Object)GameStatus.PLAYING)) {
            return;
        }
        GamePlayer gamePlayer = arena.getGamePlayer(player);
        if (!arena.isTurnPlayer(gamePlayer)) {
            return;
        }
        if (gamePlayer.isOnPromotion()) {
            event.setCancelled(true);
            return;
        }
        gamePlayer.setPreviousPos(gamePlayer.getSeeingPos());
        try {
            b = player.getTargetBlock(null, this.plugin.getConfigsManager().getMainConfigManager().getSelectPieceMaxDistance());
            if (b.getType().isAir()) {
                gamePlayer.setSeeingPos(null);
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        int[] pos = this.plugin.getBoardManager().getPiecePositionFromLocation(b.getLocation(), arena);
        if (pos == null) {
            gamePlayer.setSeeingPos(null);
            return;
        }
        int[] currentSeeingPos = gamePlayer.getSeeingPos();
        if (currentSeeingPos != null && Arrays.equals(pos, currentSeeingPos)) {
            return;
        }
        gamePlayer.setSeeingPos(pos);
    }

    public void showActionbar(final Arena arena) {
        final GamePlayer playerTurn = arena.getPlayerTurn();
        final GamePlayer opponentPlayer = arena.getOpponentPlayer(playerTurn);
        final String time = OtherUtils.getTimeFormat1(playerTurn.getTurnTime());
        final FileConfiguration messagesConfig = this.plugin.getMessagesConfig();
        new BukkitRunnable(){

            public void run() {
                ActionBarAPI.sendActionBar(playerTurn.getPlayer(), messagesConfig.getString("actionbarYourTurn").replace("%time%", time));
                String globalMessage = messagesConfig.getString("actionbarPlayerTurn").replace("%time%", time).replace("%player%", playerTurn.getName());
                ActionBarAPI.sendActionBar(opponentPlayer.getPlayer(), globalMessage);
                for (GamePlayer g : arena.getSpectators()) {
                    ActionBarAPI.sendActionBar(g.getPlayer(), globalMessage);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void checkMustTeleportArenaLobby(Arena arena) {
        ArrayList<GamePlayer> players = arena.getGamePlayers(true);
        int maxDistance = this.plugin.getConfigsManager().getMainConfigManager().getMaxDistanceFromArenaLobby();
        Location lobbyLocation = arena.getLobbyLocation();
        for (GamePlayer gamePlayer : players) {
            double distance;
            Player player = gamePlayer.getPlayer();
            if (player == null || !lobbyLocation.getWorld().equals((Object)player.getLocation().getWorld()) || !((distance = lobbyLocation.distance(player.getLocation())) >= (double)maxDistance)) continue;
            player.teleport(lobbyLocation);
        }
    }

    public void inventoryClick(Player player, InventoryClickEvent event) {
        InventoryManager invManager;
        InventoryPlayer inventoryPlayer;
        Arena arena = this.getArenaByPlayer(player, true);
        if (arena != null) {
            event.setCancelled(true);
        }
        if ((inventoryPlayer = (invManager = this.plugin.getInventoryManager()).getInventoryPlayer(player)) != null) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getClickedInventory() == null) {
                return;
            }
            if (event.getClickedInventory().equals((Object)InventoryUtils.getTopInventory(player))) {
                this.plugin.getInventoryManager().clickInventory(inventoryPlayer, event.getCurrentItem(), event.getClick());
            }
        }
    }

    public void inventoryClose(final Player player, final InventoryCloseEvent event) {
        InventoryManager invManager = this.plugin.getInventoryManager();
        if (event.getInventory().getType().equals((Object)org.bukkit.event.inventory.InventoryType.CRAFTING)) {
            return;
        }
        InventoryPlayer inventoryPlayer = invManager.getInventoryPlayer(player);
        if (inventoryPlayer != null) {
            if (inventoryPlayer.getInventoryType().equals((Object)InventoryType.PROMOTION)) {
                GamePlayer gamePlayer = this.getGamePlayer(player, true);
                if (gamePlayer != null && gamePlayer.isOnPromotion()) {
                    new BukkitRunnable(){

                        public void run() {
                            player.openInventory(event.getInventory());
                        }
                    }.runTaskLater((Plugin)this.plugin, 3L);
                } else {
                    this.plugin.getInventoryManager().removeInventoryPlayer(player);
                }
            } else {
                this.plugin.getInventoryManager().removeInventoryPlayer(player);
            }
        }
    }
}

