/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.manager;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.ajneb97.libs.centeredmessages.DefaultFontInfo;
import mc.ajneb97.model.game.GamePlayer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;

public class MessagesManager {
    private String prefix;
    private String timeSeconds;
    private String timeMinutes;
    private String timeHours;
    private String timeDays;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getTimeSeconds() {
        return this.timeSeconds;
    }

    public void setTimeSeconds(String timeSeconds) {
        this.timeSeconds = timeSeconds;
    }

    public String getTimeMinutes() {
        return this.timeMinutes;
    }

    public void setTimeMinutes(String timeMinutes) {
        this.timeMinutes = timeMinutes;
    }

    public String getTimeHours() {
        return this.timeHours;
    }

    public void setTimeHours(String timeHours) {
        this.timeHours = timeHours;
    }

    public String getTimeDays() {
        return this.timeDays;
    }

    public void setTimeDays(String timeDays) {
        this.timeDays = timeDays;
    }

    public void sendMessage(CommandSender sender, String message, boolean prefix) {
        if (!message.isEmpty()) {
            if (prefix) {
                sender.sendMessage(MessagesManager.getColoredMessage(this.prefix + message));
            } else {
                sender.sendMessage(MessagesManager.getColoredMessage(message));
            }
        }
    }

    public void sendMessage(ArrayList<GamePlayer> gamePlayers, String message, boolean prefix) {
        if (!message.isEmpty()) {
            for (GamePlayer gamePlayer : gamePlayers) {
                if (prefix) {
                    gamePlayer.getPlayer().sendMessage(MessagesManager.getColoredMessage(this.prefix + message));
                    continue;
                }
                gamePlayer.getPlayer().sendMessage(MessagesManager.getColoredMessage(message));
            }
        }
    }

    public static String getColoredMessage(String message) {
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher match = pattern.matcher(message);
        while (match.find()) {
            String color = message.substring(match.start(), match.end());
            message = message.replace(color, String.valueOf(ChatColor.of((String)color)));
            match = pattern.matcher(message);
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public static String getCenteredMessage(String message) {
        int CENTER_PX = 154;
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = CENTER_PX - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb.toString() + message;
    }
}

