/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.utils;

import java.util.List;
import mc.ajneb97.manager.MessagesManager;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryItem {
    private Inventory inventory;
    private int slot;
    private ItemStack item;
    private ItemMeta meta;

    public InventoryItem(Inventory inventory, int slot, Material material) {
        this.inventory = inventory;
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
        this.slot = slot;
    }

    public InventoryItem dataValue(short datavalue) {
        this.item.setDurability(datavalue);
        return this;
    }

    public InventoryItem amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public InventoryItem name(String name) {
        this.meta.setDisplayName(MessagesManager.getColoredMessage(name));
        return this;
    }

    public InventoryItem lore(List<String> lore) {
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, MessagesManager.getColoredMessage(lore.get(i)));
        }
        this.meta.setLore(lore);
        return this;
    }

    public InventoryItem enchanted(boolean enchanted) {
        if (enchanted) {
            this.meta.addEnchant(Enchantment.FIRE_ASPECT, 1, true);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        return this;
    }

    public void ready() {
        this.item.setItemMeta(this.meta);
        this.inventory.setItem(this.slot, this.item);
    }
}

