/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.config;

import mc.ajneb97.MineChess;
import mc.ajneb97.config.ArenasConfigManager;
import mc.ajneb97.config.InventoryConfigManager;
import mc.ajneb97.config.MainConfigManager;
import mc.ajneb97.config.MessagesConfigManager;
import mc.ajneb97.config.PlayersConfigManager;
import mc.ajneb97.config.SignsConfigManager;

public class ConfigsManager {
    private MineChess plugin;
    private MainConfigManager mainConfigManager;
    private MessagesConfigManager messagesConfigManager;
    private ArenasConfigManager arenasConfigManager;
    private InventoryConfigManager inventoryConfigManager;
    private PlayersConfigManager playersConfigManager;
    private SignsConfigManager signsConfigManager;

    public ConfigsManager(MineChess plugin) {
        this.plugin = plugin;
        this.mainConfigManager = new MainConfigManager(plugin);
        this.messagesConfigManager = new MessagesConfigManager(plugin);
        this.arenasConfigManager = new ArenasConfigManager(plugin);
        this.inventoryConfigManager = new InventoryConfigManager(plugin);
        this.signsConfigManager = new SignsConfigManager(plugin);
        this.playersConfigManager = new PlayersConfigManager(plugin, "players");
    }

    public void configure() {
        this.mainConfigManager.configure();
        this.messagesConfigManager.configure();
        this.arenasConfigManager.configure();
        this.inventoryConfigManager.configure();
        this.signsConfigManager.configure();
        this.playersConfigManager.configure();
    }

    public MainConfigManager getMainConfigManager() {
        return this.mainConfigManager;
    }

    public MessagesConfigManager getMessagesConfigManager() {
        return this.messagesConfigManager;
    }

    public ArenasConfigManager getArenasConfigManager() {
        return this.arenasConfigManager;
    }

    public PlayersConfigManager getPlayersConfigManager() {
        return this.playersConfigManager;
    }

    public InventoryConfigManager getInventoryConfigManager() {
        return this.inventoryConfigManager;
    }

    public SignsConfigManager getSignsConfigManager() {
        return this.signsConfigManager;
    }

    public boolean reload() {
        if (!this.messagesConfigManager.reloadConfig()) {
            return false;
        }
        if (!this.mainConfigManager.reloadConfig()) {
            return false;
        }
        if (!this.inventoryConfigManager.reloadConfig()) {
            return false;
        }
        this.plugin.reloadPlayerDataSaveTask();
        this.plugin.getVerifyManager().verify();
        return true;
    }
}

