/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.model.CommonConfig;
import mc.ajneb97.config.model.GameActions;
import mc.ajneb97.config.model.GameActionsEndGame;
import mc.ajneb97.config.model.GameActionsGame;
import mc.ajneb97.config.model.GameActionsRewards;
import mc.ajneb97.config.model.GameTimeLimitations;
import mc.ajneb97.config.model.PerArenaChatConfig;
import mc.ajneb97.config.model.PieceColorStructure;
import mc.ajneb97.config.model.PieceHologramsValues;
import mc.ajneb97.config.model.PieceInteraction;
import mc.ajneb97.config.model.PieceInteractions;
import mc.ajneb97.config.model.PieceStructure;
import mc.ajneb97.config.model.PiecesHologramsConfig;
import mc.ajneb97.config.model.gameitems.GameItemConfig;
import mc.ajneb97.config.model.gameitems.GameItemsConfig;
import mc.ajneb97.config.model.gameitems.SoundConfig;
import mc.ajneb97.manager.CommonItemManager;
import mc.ajneb97.model.Arena;
import mc.ajneb97.model.ArenaEndTimeMode;
import mc.ajneb97.model.chess.PieceType;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class MainConfigManager {
    private MineChess plugin;
    private CommonConfig configFile;
    private int arenaStartingCooldown;
    private int arenaEndingPhaseCooldown;
    private boolean emptyInventoryToJoin;
    private int selectPieceMaxDistance;
    private int maxDistanceFromArenaLobby;
    private int playerDataSave;
    private boolean coloredArmor;
    private GameTimeLimitations gameTimeLimitations;
    private ArrayList<PieceStructure> pieceStructures;
    private GameItemsConfig gameItemsConfig;
    private List<String> commandsWhitelist;
    private PerArenaChatConfig perArenaChat;
    private PieceInteractions pieceInteractions;
    private GameActions gameActions;
    private Arena arenaDefaultValues;
    private PiecesHologramsConfig piecesHologramsConfig;
    private int maxConsecutiveMovementsWithoutProgress;
    private boolean isMySQL;
    private boolean updateNotify;

    public MainConfigManager(MineChess plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("config.yml", plugin, null, false);
        this.configFile.registerConfig();
        this.checkUpdate();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        this.updateNotify = config.getBoolean("update_notify");
        this.arenaStartingCooldown = config.getInt("arena_starting_cooldown");
        this.arenaEndingPhaseCooldown = config.getInt("arena_ending_phase_cooldown");
        this.emptyInventoryToJoin = config.getBoolean("empty_inventory_to_join");
        this.selectPieceMaxDistance = config.getInt("select_piece_max_distance");
        this.maxDistanceFromArenaLobby = config.getInt("max_distance_from_arena_lobby");
        this.playerDataSave = config.getInt("player_data_save");
        this.coloredArmor = config.getBoolean("colored_armor");
        this.gameTimeLimitations = new GameTimeLimitations(config.getInt("game_time_limitations.min_time"), config.getBoolean("game_time_limitations.limit_rewards"), config.getBoolean("game_time_limitations.limit_stats"));
        this.pieceStructures = new ArrayList();
        for (String key : config.getConfigurationSection("pieces").getKeys(false)) {
            PieceType pieceType = PieceType.valueOf(key.toUpperCase());
            int points = config.getInt("pieces." + key + ".points");
            List blocksBlack = config.contains("pieces." + key + ".black.blocks") ? config.getStringList("pieces." + key + ".black.blocks") : null;
            List blocksWhite = config.contains("pieces." + key + ".white.blocks") ? config.getStringList("pieces." + key + ".white.blocks") : null;
            PieceHologramsValues hologramBlack = this.configurePieceHologram(config, "pieces." + key + ".black");
            PieceHologramsValues hologramWhite = this.configurePieceHologram(config, "pieces." + key + ".white");
            PieceColorStructure pieceBlack = new PieceColorStructure(blocksBlack, hologramBlack);
            PieceColorStructure pieceWhite = new PieceColorStructure(blocksWhite, hologramWhite);
            this.pieceStructures.add(new PieceStructure(pieceType, points, pieceBlack, pieceWhite));
        }
        CommonItemManager commonItemManager = this.plugin.getCommonItemManager();
        GameItemConfig leaveItem = new GameItemConfig(config.getBoolean("game_items.leave_item.enabled"), commonItemManager.getCommonItemFromConfig(config, "game_items.leave_item.item"));
        GameItemConfig selectItem = new GameItemConfig(true, commonItemManager.getCommonItemFromConfig(config, "game_items.select_item.item"));
        GameItemConfig playAgainItem = new GameItemConfig(config.getBoolean("game_items.play_again_item.enabled"), commonItemManager.getCommonItemFromConfig(config, "game_items.play_again_item.item"));
        this.gameItemsConfig = new GameItemsConfig(leaveItem, selectItem, playAgainItem);
        this.commandsWhitelist = config.getStringList("commands_whitelist");
        this.perArenaChat = new PerArenaChatConfig(config.getBoolean("per_arena_chat.enabled"), config.getString("per_arena_chat.format"));
        this.pieceInteractions = new PieceInteractions(this.configurePieceInteraction(config, "piece_interactions.interact.see_cell"), this.configurePieceInteraction(config, "piece_interactions.interact.selected_piece"), this.configurePieceInteraction(config, "piece_interactions.interact.valid_movements"), this.configurePieceInteraction(config, "piece_interactions.interact.see_valid_movement_cell"), this.configurePieceInteraction(config, "piece_interactions.interact.invalid_check_movements"));
        GameActionsGame gameActionsGame = new GameActionsGame(config.getStringList("actions.game.select_piece"), config.getStringList("actions.game.deselect_piece"), config.getStringList("actions.game.change_turn"), config.getStringList("actions.game.move_piece"), config.getStringList("actions.game.capture_piece"), config.getStringList("actions.game.capture_piece_enpassant"), config.getStringList("actions.game.king_in_check"), config.getStringList("actions.game.castling"), config.getStringList("actions.game.promotion"));
        GameActionsEndGame gameActionsEndGame = new GameActionsEndGame(config.getStringList("actions.end_game.end_by_time"), config.getStringList("actions.end_game.end_by_player_time"), config.getStringList("actions.end_game.end_by_time_tie"), config.getStringList("actions.end_game.end_by_stalemate_tie"), config.getStringList("actions.end_game.end_by_checkmate"), config.getStringList("actions.end_game.end_by_leave"), config.getStringList("actions.end_game.end_by_movements_without_progress_tie"));
        GameActionsRewards gameActionsRewards = new GameActionsRewards(config.getBoolean("actions.rewards.after_teleport"), config.getStringList("actions.rewards.end_by_time"), config.getStringList("actions.rewards.end_by_player_time"), config.getStringList("actions.rewards.end_by_time_tie"), config.getStringList("actions.rewards.end_by_stalemate_tie"), config.getStringList("actions.rewards.end_by_checkmate"), config.getStringList("actions.rewards.end_by_leave"), config.getStringList("actions.rewards.end_by_movements_without_progress_tie"));
        this.gameActions = new GameActions(gameActionsGame, gameActionsEndGame, gameActionsRewards);
        this.piecesHologramsConfig = new PiecesHologramsConfig(config.getBoolean("pieces_holograms.enabled"), new PieceHologramsValues(config.getString("pieces_holograms.default_values.text"), config.getDouble("pieces_holograms.default_values.offset_y")));
        this.maxConsecutiveMovementsWithoutProgress = config.getInt("max_consecutive_movements_without_progress");
        this.isMySQL = config.getBoolean("mysql_database.enabled");
        this.configureArenaDefaultValues(config);
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    private void configureArenaDefaultValues(FileConfiguration config) {
        this.arenaDefaultValues = new Arena("default");
        this.arenaDefaultValues.setEndTimeMode(ArenaEndTimeMode.valueOf(config.getString("arenas_default_values.end_time")));
        this.arenaDefaultValues.setMaxTime(config.getInt("arenas_default_values.gamemode_values.max_time"));
        this.arenaDefaultValues.setTurnTime(config.getInt("arenas_default_values.gamemode_values.turn_time"));
        this.arenaDefaultValues.setBoardBlackCellBlock(Material.valueOf((String)config.getString("arenas_default_values.board_black_cell_block")));
        this.arenaDefaultValues.setBoardWhiteCellBlock(Material.valueOf((String)config.getString("arenas_default_values.board_white_cell_block")));
    }

    private PieceHologramsValues configurePieceHologram(FileConfiguration config, String path) {
        if (!config.contains(path + ".hologram")) {
            return null;
        }
        return new PieceHologramsValues(config.getString(path + ".hologram.text"), config.getDouble(path + ".hologram.offset_y"));
    }

    private PieceInteraction configurePieceInteraction(FileConfiguration config, String path) {
        String value = config.getString(path + ".value");
        PieceInteraction.ParticleFormType type = null;
        double size = 0.0;
        double offsetY = 0.0;
        boolean enabled = true;
        if (config.contains(path + ".type")) {
            type = PieceInteraction.ParticleFormType.valueOf(config.getString(path + ".type"));
        }
        if (config.contains(path + ".size")) {
            size = config.getDouble(path + ".size");
        }
        if (config.contains(path + ".offset_y")) {
            offsetY = config.getDouble(path + ".offset_y");
        }
        if (config.contains(path + ".enabled")) {
            enabled = config.getBoolean(path + ".enabled");
        }
        PieceInteraction pieceInteraction = new PieceInteraction(value);
        pieceInteraction.setType(type);
        pieceInteraction.setSize(size);
        pieceInteraction.setOffsetY(offsetY);
        pieceInteraction.setEnabled(enabled);
        return pieceInteraction;
    }

    private SoundConfig configureSound(FileConfiguration config, String path) {
        String soundString = config.getString(path);
        if (soundString.equals("none")) {
            return null;
        }
        String[] soundStringSep = soundString.split(";");
        return new SoundConfig(soundStringSep[0], Float.parseFloat(soundStringSep[1]), Float.parseFloat(soundStringSep[2]));
    }

    public void checkUpdate() {
        Path pathConfig = Paths.get(this.configFile.getRoute(), new String[0]);
        try {
            String text = new String(Files.readAllBytes(pathConfig));
            FileConfiguration config = this.getConfig();
            if (!text.contains("invalid_check_movements:")) {
                config.set("piece_interactions.interact.invalid_check_movements.enabled", (Object)true);
                config.set("piece_interactions.interact.invalid_check_movements.value", (Object)"DUST;255;41;0");
                config.set("piece_interactions.interact.invalid_check_movements.type", (Object)"SQUARE");
                config.set("piece_interactions.interact.invalid_check_movements.size", (Object)0.75);
                this.configFile.saveConfig();
            }
            if (!text.contains("max_consecutive_movements_without_progress:")) {
                config.set("max_consecutive_movements_without_progress", (Object)50);
                ArrayList<String> list = new ArrayList<String>();
                list.add("to_all: title: 10;80;10;&e&lFIFTY-MOVE RULE!;&eIt's a tie!");
                list.add("to_all: centered_message: &e&m                                               ");
                list.add("to_all: centered_message: ");
                list.add("to_all: centered_message: &e&l%max% MOVEMENTS WITHOUT PROGRESS!");
                list.add("to_all: centered_message: &eIt's a tie! No captures or pawns moves have occurred in");
                list.add("to_all: centered_message: &ethe last &6%max% &emovements!");
                list.add("to_all: centered_message: ");
                list.add("to_all: centered_message: &e&m                                               ");
                config.set("actions.end_game.end_by_movements_without_progress_tie", list);
                list = new ArrayList();
                list.add("to_all: console_command: eco give %player% 50");
                config.set("actions.rewards.end_by_movements_without_progress_tie", list);
                this.configFile.saveConfig();
            }
            if (!text.contains("verifyServerCertificate:")) {
                config.set("mysql_database.pool.connectionTimeout", (Object)5000);
                config.set("mysql_database.advanced.verifyServerCertificate", (Object)false);
                config.set("mysql_database.advanced.useSSL", (Object)true);
                config.set("mysql_database.advanced.allowPublicKeyRetrieval", (Object)true);
                this.configFile.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CommonConfig getConfigFile() {
        return this.configFile;
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }

    public ArrayList<PieceStructure> getPieceStructures() {
        return this.pieceStructures;
    }

    public PieceStructure getPieceStructure(PieceType pieceType) {
        for (PieceStructure pieceStructure : this.pieceStructures) {
            if (!pieceStructure.getPieceType().equals((Object)pieceType)) continue;
            return pieceStructure;
        }
        return null;
    }

    public boolean isEmptyInventoryToJoin() {
        return this.emptyInventoryToJoin;
    }

    public GameItemsConfig getGameItemsConfig() {
        return this.gameItemsConfig;
    }

    public int getArenaStartingCooldown() {
        return this.arenaStartingCooldown;
    }

    public int getArenaEndingPhaseCooldown() {
        return this.arenaEndingPhaseCooldown;
    }

    public List<String> getCommandsWhitelist() {
        return this.commandsWhitelist;
    }

    public PerArenaChatConfig getPerArenaChat() {
        return this.perArenaChat;
    }

    public int getSelectPieceMaxDistance() {
        return this.selectPieceMaxDistance;
    }

    public PieceInteractions getPieceInteractions() {
        return this.pieceInteractions;
    }

    public Arena getArenaDefaultValues() {
        return this.arenaDefaultValues;
    }

    public GameActions getGameActions() {
        return this.gameActions;
    }

    public boolean isColoredArmor() {
        return this.coloredArmor;
    }

    public int getMaxDistanceFromArenaLobby() {
        return this.maxDistanceFromArenaLobby;
    }

    public int getPlayerDataSave() {
        return this.playerDataSave;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public PiecesHologramsConfig getPiecesHologramsConfig() {
        return this.piecesHologramsConfig;
    }

    public boolean isUpdateNotify() {
        return this.updateNotify;
    }

    public GameTimeLimitations getGameTimeLimitations() {
        return this.gameTimeLimitations;
    }

    public int getMaxConsecutiveMovementsWithoutProgress() {
        return this.maxConsecutiveMovementsWithoutProgress;
    }
}

