/*
 * Decompiled with CFR 0.152.
 */
package mc.ajneb97.config;

import java.util.ArrayList;
import mc.ajneb97.MineChess;
import mc.ajneb97.config.model.CommonConfig;
import mc.ajneb97.model.ArenaSign;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;

public class SignsConfigManager {
    private MineChess plugin;
    private CommonConfig configFile;

    public SignsConfigManager(MineChess plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("signs.yml", plugin, null, false);
        this.configFile.registerConfig();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        ArrayList<ArenaSign> arenaSigns = new ArrayList<ArenaSign>();
        if (config.contains("signs")) {
            for (String key : config.getConfigurationSection("signs").getKeys(false)) {
                String path = "signs." + key;
                String arenaName = config.getString(path + ".arena");
                Location l = this.getBlockLocationFromPath(config, path + ".location");
                arenaSigns.add(new ArenaSign(Integer.parseInt(key), arenaName, l));
            }
        }
        this.plugin.getSignManager().setArenaSigns(arenaSigns);
    }

    public void saveSign(ArenaSign arenaSign) {
        FileConfiguration config = this.configFile.getConfig();
        String path = "signs." + arenaSign.getId();
        this.setConfigFromBlockLocation(config, path + ".location", arenaSign.getLocation());
        config.set(path + ".arena", (Object)arenaSign.getArenaName());
        this.saveConfig();
    }

    public void deleteSign(int id) {
        FileConfiguration config = this.configFile.getConfig();
        config.set("signs." + id, null);
        this.saveConfig();
    }

    private Location getBlockLocationFromPath(FileConfiguration config, String path) {
        if (!config.contains(path)) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)config.getString(path + ".world")), (double)config.getInt(path + ".x"), (double)config.getInt(path + ".y"), (double)config.getInt(path + ".z"));
    }

    private void setConfigFromBlockLocation(FileConfiguration config, String path, Location location) {
        if (location == null) {
            return;
        }
        config.set(path + ".world", (Object)location.getWorld().getName());
        config.set(path + ".x", (Object)location.getBlockX());
        config.set(path + ".y", (Object)location.getBlockY());
        config.set(path + ".z", (Object)location.getBlockZ());
    }

    public void saveConfig() {
        this.configFile.saveConfig();
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }
}

